/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.commonee;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.TestsT;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Properties;

@Stateful
@Remote(value={TestsT.class})
public class TestsTEJB
implements TestsT {
    @Resource
    private SessionContext sessionContext;
    private Properties harnessProps = null;
    private TSNamingContext nctx = null;
    private transient Destination testDestination = null;
    private transient ConnectionFactory cf = null;
    private transient Connection conn = null;
    private transient Connection connr = null;
    private static final String TESTTOPICNAME = "java:comp/env/jms/MY_TOPIC";
    private static final String DURABLETOPICCONNECTIONFACTORY = "java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY";
    private String name = "ctssub";
    private String username = null;
    private String password = null;
    private long timeout;

    public TestsTEJB() {
        TestUtil.logTrace((String)"TestsTEJB => default constructor called");
    }

    @Override
    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(TestUtil.getProperty((Properties)this.harnessProps, (String)"jms_timeout"));
            this.username = TestUtil.getProperty((Properties)this.harnessProps, (String)"user");
            this.password = TestUtil.getProperty((Properties)this.harnessProps, (String)"password");
            if (this.timeout < 1L) {
                throw new EJBException("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.username == null) {
                throw new EJBException("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new EJBException("'password' in ts.jte must be null");
            }
            if (this.sessionContext == null) {
                throw new EJBException("@Resource injection failed");
            }
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("initLogging: Failed!", (Exception)((Object)e));
        }
    }

    @PostConstruct
    public void postConstruct() {
        TestUtil.logTrace((String)"postConstruct");
        try {
            TestUtil.logMsg((String)"obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
    }

    @PostActivate
    public void activate() {
        TestUtil.logTrace((String)"activate");
        try {
            TestUtil.logTrace((String)"Getting ConnectionFactory java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY");
            this.cf = (ConnectionFactory)this.nctx.lookup(DURABLETOPICCONNECTIONFACTORY);
            TestUtil.logTrace((String)"Getting Destination java:comp/env/jms/MY_TOPIC");
            this.testDestination = (Destination)this.nctx.lookup(TESTTOPICNAME);
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected Exception in Activate: ", (Throwable)ex);
        }
    }

    @PrePassivate
    public void passivate() {
        TestUtil.logTrace((String)"passivate");
        this.testDestination = null;
        this.cf = null;
        this.conn = null;
        this.connr = null;
    }

    @Override
    @Remove
    public void remove() {
        TestUtil.logTrace((String)"remove");
    }

    private void common_T() throws Exception {
        TestUtil.logTrace((String)"Getting ConnectionFactory java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY");
        this.cf = (ConnectionFactory)this.nctx.lookup(DURABLETOPICCONNECTIONFACTORY);
        TestUtil.logTrace((String)"Getting Destination java:comp/env/jms/MY_TOPIC");
        this.testDestination = (Destination)this.nctx.lookup(TESTTOPICNAME);
    }

    @Override
    public void common_T_setup() {
        try {
            this.common_T();
            this.connr = this.cf.createConnection(this.username, this.password);
            Session sessr = this.connr.createSession(true, 1);
            TopicSubscriber recr = sessr.createDurableSubscriber((Topic)this.testDestination, this.name);
            recr.close();
        }
        catch (Exception el) {
            TestUtil.printStackTrace((Throwable)el);
            TestUtil.logErr((String)"Failed to set up Consumer for Topic", (Throwable)el);
        }
        finally {
            try {
                this.connr.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception closing receiving Connection:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTextMessage_CT(String TestName, String message) {
        try {
            this.common_T();
            TestUtil.logTrace((String)("Creating Connection with  username, " + this.username + " password, " + this.password));
            this.conn = this.cf.createConnection(this.username, this.password);
            TestUtil.logTrace((String)"Creating Session");
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace((String)"Creating messageProducer");
            MessageProducer sender = sess.createProducer(this.testDestination);
            TestUtil.logMsg((String)"Creating 1 message");
            TextMessage messageSent = sess.createTextMessage();
            messageSent.setText(message);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", TestName);
            TestUtil.logMsg((String)"Sending message");
            sender.send((Message)messageSent);
            sender.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed to send a Message in sendTextMessage_CQ");
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace((String)"Closing Connection in sendTextMessage_CT");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr((String)("Error closing conn in sendTextMessage_CQ" + ce.getMessage()), (Throwable)ce);
                }
            }
        }
    }

    @Override
    public String receiveTextMessage_CT() {
        String tmp;
        block13: {
            TextMessage receivedM = null;
            tmp = null;
            try {
                TestUtil.logTrace((String)("Creating Connection with  username, " + this.username + " password, " + this.password));
                this.connr = this.cf.createConnection(this.username, this.password);
                this.connr.start();
                Session sessr = this.connr.createSession(true, 1);
                TopicSubscriber recr = sessr.createDurableSubscriber((Topic)this.testDestination, this.name);
                receivedM = (TextMessage)recr.receive(this.timeout);
                recr.close();
                if (receivedM != null) {
                    tmp = receivedM.getText();
                    break block13;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Failed to receive a message in receiveTextMessage_CT: ", (Throwable)e);
                throw new EJBException(e);
            }
            finally {
                if (this.connr != null) {
                    try {
                        TestUtil.logTrace((String)"Closing Connection in receiveTextMessage_CT");
                        this.connr.close();
                    }
                    catch (Exception ce) {
                        TestUtil.logErr((String)("Error closing conn in receiveTextMessage_CT" + ce.getMessage()), (Throwable)ce);
                    }
                }
            }
        }
        return tmp;
    }
}

