/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.mixedmode;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.Util;
import com.sun.ts.tests.common.connector.whitebox.mixedmode.PMDWorkManager;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.AuthenticationMechanism;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.Connector;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.SecurityPermission;
import jakarta.resource.spi.TransactionSupport;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.HintsContext;
import jakarta.resource.spi.work.SecurityContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkManager;
import java.io.Serializable;
import javax.transaction.xa.XAResource;

@Connector(description={"CTS Test Resource Adapter with No DD"}, licenseDescription={"CTS License Required"}, licenseRequired=true, authMechanisms={@AuthenticationMechanism(credentialInterface=AuthenticationMechanism.CredentialInterface.PasswordCredential, authMechanism="BasicPassword", description={"Basic Password Authentication"})}, reauthenticationSupport=false, securityPermissions={@SecurityPermission}, transactionSupport=TransactionSupport.TransactionSupportLevel.NoTransaction, requiredWorkContexts={HintsContext.class, SecurityContext.class})
public class PMDResourceAdapterImpl
implements ResourceAdapter,
Serializable {
    private transient BootstrapContext bsc;
    private transient PMDWorkManager pwm;
    private transient WorkManager wm;
    private transient Work work;
    @ConfigProperty(defaultValue="PartialMDResourceAdapter", description={"String value"}, ignore=false)
    String raName;
    @ConfigProperty(defaultValue="VAL_FROM_ANNOTATION", description={"String value"}, ignore=false)
    String overRide;
    String mdPropOnly;

    public PMDResourceAdapterImpl() {
        this.debug("enterred constructor...");
        this.debug("leaving constructor...");
    }

    public void start(BootstrapContext bsc) throws ResourceAdapterInternalException {
        this.debug("enterred start");
        this.debug("PMDResourceAdapterImpl.start called");
        this.bsc = bsc;
        this.wm = bsc.getWorkManager();
        this.pwm = new PMDWorkManager(bsc);
        this.pwm.runTests();
        this.debug("leaving start");
    }

    public void stop() {
        this.debug("entered stop");
        this.debug("leaving stop");
    }

    public void endpointActivation(MessageEndpointFactory factory, ActivationSpec spec) throws NotSupportedException {
        this.debug("enterred endpointActivation");
        this.debug("leaving endpointActivation");
    }

    public void endpointDeactivation(MessageEndpointFactory ep, ActivationSpec spec) {
        this.debug("enterred endpointDeactivation");
        this.debug("leaving endpointDeactivation");
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        this.debug("enterred getXAResources");
        this.debug("leaving getXAResources");
        throw new UnsupportedOperationException();
    }

    public void setRaName(String name) {
        this.raName = name;
        String str = "setRAName called with raname=" + this.raName;
        this.debug(str);
        ConnectorStatus.getConnectorStatus().logState(str);
    }

    public String getRaName() {
        return this.raName;
    }

    public void setOverRide(String name) {
        String str = "PMDResourceAdapterImpl overRide=" + name;
        ConnectorStatus.getConnectorStatus().logState(str);
        this.debug(str);
        this.overRide = name;
    }

    public String getOverRide() {
        return this.overRide;
    }

    public void setMdPropOnly(String name) {
        String str = "PMDResourceAdapterImpl mdPropOnly=" + name;
        this.debug(str);
        this.mdPropOnly = name;
    }

    public String getMdPropOnly() {
        return this.mdPropOnly;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PMDResourceAdapterImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PMDResourceAdapterImpl that = (PMDResourceAdapterImpl)obj;
        if (!Util.isEqual(this.mdPropOnly, that.getMdPropOnly())) {
            return false;
        }
        if (!Util.isEqual(this.overRide, that.getOverRide())) {
            return false;
        }
        return Util.isEqual(this.raName, that.getRaName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void debug(String out) {
        Debug.trace("PMDResourceAdapterImpl:  " + out);
    }
}

