/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.none.proxy;

import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.tests.common.vehicle.none.proxy.DirectDispatcher;
import com.sun.ts.tests.common.vehicle.none.proxy.InvocationProxy;
import com.sun.ts.tests.common.vehicle.none.proxy.ServletDispatcher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;

public abstract class AbstractBaseProxy<I, IP extends InvocationProxy>
implements InvocationProxy<I> {
    private Function<Object[], RemoteStatus> dispatcher;
    private I lastProxy;

    @Override
    public abstract RemoteStatus runTest(String var1);

    public I newProxy() {
        ClassLoader cl = AbstractBaseProxy.class.getClassLoader();
        Class<I> interfaceClass = this.getInterfaceClass();
        Class[] interfaces = new Class[]{interfaceClass};
        I proxy = interfaceClass.cast(Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)this));
        this.lastProxy = proxy;
        return proxy;
    }

    public I newProxy(Object testCase) {
        I proxy = this.newProxy();
        this.useDirectDispatcher(testCase);
        return proxy;
    }

    @Override
    public I newProxy(String host, String port) {
        I proxy = this.newProxy();
        this.useServletDispatcher(host, port);
        return proxy;
    }

    public I getLastProxy() {
        return this.lastProxy;
    }

    @Override
    public Class<I> getInterfaceClass() {
        Class<?>[] typeArguments = this.getReifiedTypeArguments();
        return typeArguments[0];
    }

    public Class<IP> getInvocationProxyClass() {
        Class<?>[] typeArguments = this.getReifiedTypeArguments();
        return typeArguments[1];
    }

    public Class<?>[] getReifiedTypeArguments() {
        Class<?> currentClass = this.getClass();
        ParameterizedType genericType = (ParameterizedType)currentClass.getGenericSuperclass();
        Type[] typeArguments = genericType.getActualTypeArguments();
        Class[] reifiedTypeArguments = new Class[]{(Class)typeArguments[0], (Class)typeArguments[1]};
        return reifiedTypeArguments;
    }

    public String getGenericInfo() {
        Class<?>[] typeArguments = this.getReifiedTypeArguments();
        StringBuilder genericInfo = new StringBuilder();
        genericInfo.append("I.class: ");
        genericInfo.append(typeArguments[0].toString());
        genericInfo.append("\nIH.class: ");
        genericInfo.append(typeArguments[1].toString());
        return genericInfo.toString();
    }

    public Function<Object[], RemoteStatus> getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Function<Object[], RemoteStatus> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void useDirectDispatcher(Object testCase) {
        this.setDispatcher(new DirectDispatcher(testCase));
    }

    public void useServletDispatcher(String host, String port) {
        this.setDispatcher(new ServletDispatcher(host, port));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            return this.getClass().getName() + "-proxy";
        }
        if (methodName.equals("hashCode")) {
            return this.hashCode();
        }
        if (methodName.equals("equals")) {
            return this.equals(proxy);
        }
        if (this.dispatcher != null) {
            Object[] newArgs = this.copyOf(args);
            newArgs[newArgs.length - 1] = methodName;
            return this.dispatcher.apply(newArgs);
        }
        return null;
    }

    private Object[] copyOf(Object[] args) {
        Object[] newArgs = args != null ? Arrays.copyOf(args, args.length + 1) : new Object[1];
        return newArgs;
    }
}

