/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.none.proxy;

import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.vehicle.none.proxy.AbstractBaseProxy;
import com.sun.ts.tests.common.vehicle.none.proxy.InvocationProxy;
import com.sun.ts.tests.common.vehicle.none.proxy.ServletDispatcher;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Properties;

public class AppClient<IC, ICP extends InvocationProxy<IC>> {
    private static final Class[] appClasses = new Class[]{AbstractBaseProxy.class, AppClient.class, InvocationProxy.class, ServletDispatcher.class};

    public static Class[] getAppClasses() {
        return appClasses;
    }

    public void run(String[] args) throws IOException {
        String webServerPort;
        String testName = "";
        boolean exit = true;
        Properties testProps = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                testName = args[++i];
                continue;
            }
            if (args[i].equals("-p")) {
                testProps = AppClient.readProperties(args[++i]);
                continue;
            }
            if (!args[i].equals("-x")) continue;
            exit = false;
        }
        if (testProps == null) {
            throw new IllegalArgumentException("Test properties not provided, use -p <properties file>");
        }
        String webServerHost = testProps.getProperty("webServerHost", "localhost");
        RemoteStatus status = this.runTest(testName, webServerHost, webServerPort = testProps.getProperty("webServerPort", "8080"));
        if (status.toStatus().isFailed()) {
            System.out.println("FAILED: " + testName);
            System.err.printf("%s failed\n, additional stuats:\n", testName);
            System.err.println(status);
        } else {
            System.out.println("PASSED: " + testName);
        }
        if (exit) {
            status.toStatus().exit();
        }
    }

    RemoteStatus runTest(String testName, String webServerHost, String webServerPort) {
        RemoteStatus status;
        Class<ICP> clientProxyClass = this.getInvocationProxyClass();
        try {
            Constructor<ICP> clientProxyCtor = clientProxyClass.getDeclaredConstructor(new Class[0]);
            InvocationProxy clientProxy = (InvocationProxy)clientProxyCtor.newInstance(new Object[0]);
            clientProxy.newProxy(webServerHost, webServerPort);
            status = clientProxy.runTest(testName);
        }
        catch (Throwable e) {
            status = new RemoteStatus(Status.failed(testName + "  failure in main"), e);
        }
        return status;
    }

    private static Properties readProperties(String fileName) throws IOException {
        Properties props = new Properties();
        props.load(new FileReader(fileName));
        return props;
    }

    protected Class<ICP> getInvocationProxyClass() {
        Class<?>[] typeArguments = this.getReifiedTypeArguments();
        return typeArguments[1];
    }

    protected Class<?>[] getReifiedTypeArguments() {
        Class<?> currentClass = this.getClass();
        ParameterizedType genericType = (ParameterizedType)currentClass.getGenericSuperclass();
        Type[] typeArguments = genericType.getActualTypeArguments();
        Class[] reifiedTypeArguments = new Class[]{(Class)typeArguments[0], (Class)typeArguments[1]};
        return reifiedTypeArguments;
    }
}

