/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.none.proxy;

import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;

public abstract class ServletNoVehicle
extends HttpServlet {
    protected String testName;

    public void init(ServletConfig config) throws ServletException {
        TestUtil.logTrace("init " + ((Object)((Object)this)).getClass().getName() + " ...");
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            TestUtil.logTrace("ServletNoVehicle - In doGet");
            ObjectOutputStream objOutStream = new ObjectOutputStream((OutputStream)res.getOutputStream());
            System.out.println("got outputstream");
            this.testName = req.getParameter("test");
            RemoteStatus finalStatus = this.runTest();
            System.out.println("ran test");
            objOutStream.writeObject(finalStatus);
            objOutStream.flush();
            objOutStream.close();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            TestUtil.logTrace(t.getMessage());
            t.printStackTrace();
            throw new ServletException("test failed to run within the Servlet Vehicle");
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        System.out.println("In doPost!");
        TestUtil.logTrace("In doPost");
        Object[] args = null;
        Properties props = null;
        int contentLength = req.getContentLength();
        ServletInputStream inputStream = req.getInputStream();
        try (ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)inputStream);){
            Object[] payload = (Object[])objectInputStream.readObject();
            args = (String[])payload[0];
            if (payload.length > 1) {
                props = (Properties)payload[1];
            }
            System.out.println("Received POST request with body: " + Arrays.toString(args));
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize request body", e);
        }
        TestUtil.logTrace("post args: " + Arrays.toString(args));
        try {
            ObjectOutputStream objOutStream = new ObjectOutputStream((OutputStream)res.getOutputStream());
            System.out.println("got outputstream");
            RemoteStatus finalStatus = props != null ? this.setup((String[])args, props) : this.setup((String[])args);
            System.out.println("ran setup");
            objOutStream.writeObject(finalStatus);
            objOutStream.flush();
            objOutStream.close();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            TestUtil.logTrace(t.getMessage());
            t.printStackTrace();
            throw new ServletException("test failed to run within the Servlet Vehicle");
        }
    }

    protected RemoteStatus setup(String[] args) {
        return new RemoteStatus(Status.passed("No setup required"));
    }

    protected RemoteStatus setup(String[] args, Properties props) {
        return new RemoteStatus(Status.passed("No setup required"));
    }

    protected abstract RemoteStatus runTest();
}

