/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util.sec.misc;

import com.sun.ts.lib.util.sec.misc.FileURLMapper;
import com.sun.ts.lib.util.sec.misc.InvalidJarIndexException;
import com.sun.ts.lib.util.sec.misc.JarIndex;
import com.sun.ts.lib.util.sec.misc.MetaIndex;
import com.sun.ts.lib.util.sec.misc.Resource;
import com.sun.ts.lib.util.sec.misc.SharedSecrets;
import com.sun.ts.lib.util.sec.net.www.ParseUtil;
import com.sun.ts.lib.util.sec.security.action.GetPropertyAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class URLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private static final boolean DEBUG = AccessController.doPrivileged(new GetPropertyAction("sun.misc.URLClassPath.debug")) != null;
    private ArrayList path = new ArrayList();
    Stack urls = new Stack();
    ArrayList loaders = new ArrayList();
    HashMap lmap = new HashMap();
    private URLStreamHandler jarHandler;

    public URLClassPath(URL[] urls, URLStreamHandlerFactory factory) {
        for (int i = 0; i < urls.length; ++i) {
            this.path.add(urls[i]);
        }
        this.push(urls);
        if (factory != null) {
            this.jarHandler = factory.createURLStreamHandler("jar");
        }
    }

    public URLClassPath(URL[] urls) {
        this(urls, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURL(URL url) {
        Stack stack = this.urls;
        synchronized (stack) {
            if (this.path.contains(url)) {
                return;
            }
            this.urls.add(0, url);
            this.path.add(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        Stack stack = this.urls;
        synchronized (stack) {
            return this.path.toArray(new URL[this.path.size()]);
        }
    }

    public URL findResource(String name, boolean check) {
        Loader loader;
        int i = 0;
        while ((loader = this.getLoader(i)) != null) {
            URL url = loader.findResource(name, check);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    public Resource getResource(String name, boolean check) {
        Loader loader;
        if (DEBUG) {
            System.err.println("URLClassPath.getResource(\"" + name + "\")");
        }
        int i = 0;
        while ((loader = this.getLoader(i)) != null) {
            Resource res = loader.getResource(name, check);
            if (res != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public Enumeration findResources(final String name, final boolean check) {
        return new Enumeration(){
            private int index = 0;
            private URL url = null;

            private boolean next() {
                Loader loader;
                if (this.url != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.url = loader.findResource(name, check);
                    if (this.url == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }
        };
    }

    public Resource getResource(String name) {
        return this.getResource(name, true);
    }

    public Enumeration getResources(final String name, final boolean check) {
        return new Enumeration(){
            private int index = 0;
            private Resource res = null;

            private boolean next() {
                Loader loader;
                if (this.res != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.res = loader.getResource(name, check);
                    if (this.res == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource r = this.res;
                this.res = null;
                return r;
            }
        };
    }

    public Enumeration getResources(String name) {
        return this.getResources(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Loader getLoader(int index) {
        while (this.loaders.size() < index + 1) {
            Loader loader;
            URL url;
            block7: {
                Stack stack = this.urls;
                synchronized (stack) {
                    if (this.urls.empty()) {
                        return null;
                    }
                    url = (URL)this.urls.pop();
                }
                if (this.lmap.containsKey(url)) continue;
                try {
                    loader = this.getLoader(url);
                    URL[] urls = loader.getClassPath();
                    if (urls == null) break block7;
                    this.push(urls);
                }
                catch (IOException e) {
                    continue;
                }
            }
            this.loaders.add(loader);
            this.lmap.put(url, loader);
        }
        return (Loader)this.loaders.get(index);
    }

    private Loader getLoader(final URL url) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String file = url.getFile();
                    if (file != null && file.endsWith("/")) {
                        if ("file".equals(url.getProtocol())) {
                            return new FileLoader(url);
                        }
                        return new Loader(url);
                    }
                    return new JarLoader(url, URLClassPath.this.jarHandler, URLClassPath.this.lmap);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] us) {
        Stack stack = this.urls;
        synchronized (stack) {
            for (int i = us.length - 1; i >= 0; --i) {
                this.urls.push(us[i]);
            }
        }
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            File f = new File(st.nextToken());
            try {
                f = new File(f.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                urls[count++] = ParseUtil.fileToEncodedURL(f);
            }
            catch (IOException iOException) {}
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    public URL checkURL(URL url) {
        return url;
    }

    private static class Loader {
        private final URL base;

        Loader(URL url) {
            this.base = url;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL findResource(String name, boolean check) {
            URL url;
            try {
                url = new URL(this.base, ParseUtil.encodePath(name, false));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("name");
            }
            try {
                URLConnection uc = url.openConnection();
                if (uc instanceof HttpURLConnection) {
                    HttpURLConnection hconn = (HttpURLConnection)uc;
                    hconn.setRequestMethod("HEAD");
                    if (hconn.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    InputStream is = url.openStream();
                    is.close();
                }
                return url;
            }
            catch (Exception e) {
                return null;
            }
        }

        Resource getResource(final String name, boolean check) {
            URLConnection uc;
            URL url;
            try {
                url = new URL(this.base, ParseUtil.encodePath(name, false));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("name");
            }
            try {
                uc = url.openConnection();
                InputStream inputStream = uc.getInputStream();
            }
            catch (Exception e) {
                return null;
            }
            return new Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return base;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return uc.getInputStream();
                }

                @Override
                public int getContentLength() throws IOException {
                    return uc.getContentLength();
                }
            };
        }

        Resource getResource(String name) {
            return this.getResource(name, true);
        }

        URL[] getClassPath() throws IOException {
            return null;
        }
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL url) throws IOException {
            super(url);
            if (!"file".equals(url.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            String path = url.getFile().replace('/', File.separatorChar);
            path = ParseUtil.decode(path);
            this.dir = new File(path);
        }

        @Override
        URL findResource(String name, boolean check) {
            Resource rsc = this.getResource(name, check);
            if (rsc != null) {
                return rsc.getURL();
            }
            return null;
        }

        @Override
        Resource getResource(final String name, boolean check) {
            try {
                URL normalizedBase = new URL(this.getBaseURL(), ".");
                final URL url = new URL(this.getBaseURL(), ParseUtil.encodePath(name, false));
                if (!url.getFile().startsWith(normalizedBase.getFile())) {
                    return null;
                }
                final File file = new File(this.dir, name.replace('/', File.separatorChar));
                if (file.exists()) {
                    return new Resource(){

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public URL getURL() {
                            return url;
                        }

                        @Override
                        public URL getCodeSourceURL() {
                            return this.getBaseURL();
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(file);
                        }

                        @Override
                        public int getContentLength() throws IOException {
                            return (int)file.length();
                        }
                    };
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
    }

    static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private JarIndex index;
        private MetaIndex metaIndex;
        private URLStreamHandler handler;
        private HashMap lmap;

        JarLoader(URL url, URLStreamHandler jarHandler, HashMap loaderMap) throws IOException {
            super(new URL("jar", "", -1, url + "!/", jarHandler));
            this.csu = url;
            this.handler = jarHandler;
            this.lmap = loaderMap;
            if (!this.isOptimizable(url)) {
                this.ensureOpen();
            } else {
                String fileName = url.getFile();
                if (fileName != null) {
                    fileName = ParseUtil.decode(fileName);
                    File f = new File(fileName);
                    this.metaIndex = MetaIndex.forJar(f);
                    if (this.metaIndex != null && !f.exists()) {
                        this.metaIndex = null;
                    }
                }
                if (this.metaIndex == null) {
                    this.ensureOpen();
                }
            }
        }

        JarFile getJarFile() {
            return this.jar;
        }

        private boolean isOptimizable(URL url) {
            return "file".equals(url.getProtocol());
        }

        private void ensureOpen() throws IOException {
            if (this.jar == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            if (DEBUG) {
                                System.err.println("Opening " + csu);
                                Thread.dumpStack();
                            }
                            jar = this.getJarFile(csu);
                            index = JarIndex.getJarIndex(jar, metaIndex);
                            if (index != null) {
                                String[] jarfiles = index.getJarFiles();
                                for (int i = 0; i < jarfiles.length; ++i) {
                                    try {
                                        URL jarURL = new URL(csu, jarfiles[i]);
                                        if (lmap.containsKey(jarURL)) continue;
                                        lmap.put(jarURL, null);
                                        continue;
                                    }
                                    catch (MalformedURLException e) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
            }
        }

        private JarFile getJarFile(URL url) throws IOException {
            if (this.isOptimizable(url)) {
                FileURLMapper p = new FileURLMapper(url);
                if (!p.exists()) {
                    throw new FileNotFoundException(p.getPath());
                }
                return new JarFile(p.getPath());
            }
            URLConnection uc = this.getBaseURL().openConnection();
            uc.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            return ((JarURLConnection)uc).getJarFile();
        }

        JarIndex getIndex() {
            try {
                this.ensureOpen();
            }
            catch (IOException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            return this.index;
        }

        Resource checkResource(final String name, boolean check, final JarEntry entry) {
            URL url;
            try {
                url = new URL(this.getBaseURL(), ParseUtil.encodePath(name, false));
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            return new Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return csu;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return jar.getInputStream(entry);
                }

                @Override
                public int getContentLength() {
                    return (int)entry.getSize();
                }

                @Override
                public Manifest getManifest() throws IOException {
                    return jar.getManifest();
                }

                @Override
                public Certificate[] getCertificates() {
                    return entry.getCertificates();
                }

                @Override
                public CodeSigner[] getCodeSigners() {
                    return entry.getCodeSigners();
                }
            };
        }

        boolean validIndex(String name) {
            String packageName = name;
            int pos = name.lastIndexOf("/");
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Enumeration<JarEntry> enum_ = this.jar.entries();
            while (enum_.hasMoreElements()) {
                ZipEntry entry = enum_.nextElement();
                String entryName = entry.getName();
                pos = entryName.lastIndexOf("/");
                if (pos != -1) {
                    entryName = entryName.substring(0, pos);
                }
                if (!entryName.equals(packageName)) continue;
                return true;
            }
            return false;
        }

        @Override
        URL findResource(String name, boolean check) {
            Resource rsc = this.getResource(name, check);
            if (rsc != null) {
                return rsc.getURL();
            }
            return null;
        }

        @Override
        Resource getResource(String name, boolean check) {
            if (this.metaIndex != null && !this.metaIndex.mayContain(name)) {
                return null;
            }
            try {
                this.ensureOpen();
            }
            catch (IOException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            JarEntry entry = this.jar.getJarEntry(name);
            if (entry != null) {
                return this.checkResource(name, check, entry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet visited = new HashSet();
            return this.getResource(name, check, visited);
        }

        Resource getResource(String name, boolean check, Set visited) {
            boolean done = false;
            int count = 0;
            LinkedList jarFilesList = null;
            jarFilesList = this.index.get(name);
            if (jarFilesList == null) {
                return null;
            }
            do {
                Object[] jarFiles = jarFilesList.toArray();
                int size = jarFilesList.size();
                while (count < size) {
                    Resource res;
                    boolean visitedURL;
                    JarLoader newLoader;
                    URL url;
                    block12: {
                        String jarName = (String)jarFiles[count++];
                        try {
                            url = new URL(this.csu, jarName);
                            newLoader = (JarLoader)this.lmap.get(url);
                            if (newLoader != null) break block12;
                            newLoader = (JarLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return new JarLoader(url, handler, lmap);
                                }
                            });
                            JarIndex newIndex = newLoader.getIndex();
                            if (newIndex != null) {
                                int pos = jarName.lastIndexOf("/");
                                newIndex.merge(this.index, pos == -1 ? null : jarName.substring(0, pos + 1));
                            }
                            this.lmap.put(url, newLoader);
                        }
                        catch (PrivilegedActionException pae) {
                            continue;
                        }
                        catch (MalformedURLException e) {
                            continue;
                        }
                    }
                    boolean bl = visitedURL = !visited.add(url);
                    if (!visitedURL) {
                        try {
                            newLoader.ensureOpen();
                        }
                        catch (IOException e) {
                            throw (InternalError)new InternalError().initCause(e);
                        }
                        JarEntry entry = newLoader.jar.getJarEntry(name);
                        if (entry != null) {
                            return newLoader.checkResource(name, check, entry);
                        }
                        if (!newLoader.validIndex(name)) {
                            throw new InvalidJarIndexException("Invalid index");
                        }
                    }
                    if (visitedURL || newLoader == this || newLoader.getIndex() == null || (res = newLoader.getResource(name, check, visited)) == null) continue;
                    return res;
                }
            } while (count < (jarFilesList = this.index.get(name)).size());
            return null;
        }

        @Override
        URL[] getClassPath() throws IOException {
            String value;
            Attributes attr;
            Manifest man;
            if (this.index != null) {
                return null;
            }
            if (this.metaIndex != null) {
                return null;
            }
            this.ensureOpen();
            if (SharedSecrets.javaUtilJarAccess().jarFileHasClassPathAttribute(this.jar) && (man = this.jar.getManifest()) != null && (attr = man.getMainAttributes()) != null && (value = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, value);
            }
            return null;
        }

        private URL[] parseClassPath(URL base, String value) throws MalformedURLException {
            StringTokenizer st = new StringTokenizer(value);
            URL[] urls = new URL[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                urls[i] = new URL(base, path);
                ++i;
            }
            return urls;
        }
    }
}

