/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Merge;
import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.ClassSet;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Exclude;
import com.sun.tdk.signaturetest.core.ExcludeException;
import com.sun.tdk.signaturetest.core.JDKExclude;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.core.ThrowsNormalizer;
import com.sun.tdk.signaturetest.errors.BCProcessor;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.HumanErrorFormatter;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.errors.SortedErrorFormatter;
import com.sun.tdk.signaturetest.loaders.LoadingHints;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.AnnotationItemEx;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.updater.Updater;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignatureTest
extends SigTest {
    public static final String CHECKVALUE_OPTION = "-CheckValue";
    public static final String NOCHECKVALUE_OPTION = "-NoCheckValue";
    public static final String MODE_OPTION = "-Mode";
    public static final String ENABLESUPERSET_OPTION = "-EnableSuperSet";
    public static final String FILES_OPTION = "-Files";
    public static final String NOMERGE_OPTION = "-NoMerge";
    public static final String WRITE_OPTION = "-Write";
    public static final String UPDATE_FILE_OPTION = "-Update";
    public static final String EXCLUDE_JDK_CLASS_OPTION = "-IgnoreJDKClass";
    private String logName = null;
    private String outFormat = null;
    private boolean extensibleInterfaces = false;
    private static Logger logger = Logger.getLogger(SignatureTest.class.getName());
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SignatureTest.class);
    private boolean logFile = false;
    private Set trackedClassNames;
    private boolean isVerbose = false;
    private Boolean isValueTracked = null;
    private boolean isOneWayConstantChecking = false;
    private String writeFileName = null;
    private String updateFileName = null;
    private String mode = null;
    public static final String BINARY_MODE = "bin";
    private static final String SOURCE_MODE = "src";
    private static final String FORMAT_PLAIN = "plain";
    private static final String FORMAT_HUMAN = "human";
    private static final String FORMAT_BACKWARD = "backward";
    private boolean isSupersettingEnabled = false;
    private boolean isThrowsRemoved = false;
    private ClassHierarchy signatureClassesHierarchy;
    private Erasurator erasurator = new Erasurator();
    protected Exclude exclude;
    private int readMode = 2;
    private JDKExclude jdkExclude = new DefaultJDKExclude();
    private static PackageGroup excludedJdkClasses = new PackageGroup(true);

    public SignatureTest() {
        this.normalizer = new ThrowsNormalizer(this.jdkExclude);
    }

    public static void main(String[] args) {
        SignatureTest t = SignatureTest.getInstance();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    protected static SignatureTest getInstance() {
        return new SignatureTest();
    }

    public void run(String[] args, PrintWriter log, PrintWriter ref) {
        this.setLog(log);
        this.mode = null;
        try {
            ClassLoader cl = SignatureTest.class.getClassLoader();
            this.exclude = (Exclude)cl.loadClass(System.getProperty("exclude.plugin")).newInstance();
        }
        catch (Exception e) {
            this.exclude = new DefaultExcludeList();
        }
        if (this.parseParameters(args)) {
            this.check();
            if (this.logFile) {
                this.getLog().println(this.toString());
            }
        } else if (args.length > 0 && args[0].equalsIgnoreCase("-Version")) {
            System.err.println(Version.getVersionInfo());
        } else {
            this.usage();
        }
        if (this.classpath != null) {
            this.classpath.close();
        }
        if (this.logFile) {
            this.getLog().close();
            System.out.println(i18n.getString("SignatureTest.mesg.see_log", (Object)this.logName));
        }
    }

    private void correctConstants(ClassDescription currentClass) {
        FieldDescr[] fields = currentClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescr fd = fields[i];
            if (fd.isStatic()) continue;
            fd.setConstantValue(null);
        }
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], "-Help") || parser.isOptionSpecified(args[0], "-?"))) {
            return false;
        }
        args = this.exclude.parseParameters(args);
        logger.info("SignatureTest.args: " + Arrays.asList(args));
        String optionsDecoder = "decodeOptions";
        parser.addOption("-Package", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Classpath", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-BootCp", OptionInfo.optionVariableParams(0, 1), "decodeOptions");
        parser.addOption("-FileName", OptionInfo.option(1), "decodeOptions");
        parser.addOption(FILES_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-TestURL", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-PackageWithoutSubpackages", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Exclude", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-ApiVersion", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Out", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Static", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-ClassCacheSize", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-FormatPlain", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-FormatHuman", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-H", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Backward", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-B", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-ExtensibleInterfaces", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Debug", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-XnoTiger", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Xverbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(CHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(NOCHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(ENABLESUPERSET_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(UPDATE_FILE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(MODE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-AllPublic", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(EXCLUDE_JDK_CLASS_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Verbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Help", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-?", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Version", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Plugin", OptionInfo.option(1), "decodeOptions");
        parser.addOption(NOMERGE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(WRITE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ErrorAll", OptionInfo.optionalFlag(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (this.packages.isEmpty() && this.purePackages.isEmpty()) {
            this.packages.addPackage("");
        }
        if (parser.isOptionSpecified("-FileName")) {
            this.readMode = 1;
        }
        if (parser.isOptionSpecified("-Static") && !parser.isOptionSpecified("-Classpath")) {
            return this.error(i18n.getString("SignatureTest.error.static.missing_option", (Object)"-Classpath"));
        }
        if (!parser.isOptionSpecified("-FileName") && !parser.isOptionSpecified(FILES_OPTION)) {
            Object[] invargs = new String[]{"-FileName", FILES_OPTION};
            return this.error(i18n.getString("SignatureTest.error.options.filename_options", invargs));
        }
        if (parser.isOptionSpecified("-FileName") && parser.isOptionSpecified(FILES_OPTION)) {
            Object[] invargs = new String[]{"-FileName", FILES_OPTION};
            return this.error(i18n.getString("Setup.error.options.cant_be_used_together", invargs));
        }
        this.logFile = false;
        if (this.logName != null) {
            try {
                this.setLog(new PrintWriter((Writer)new FileWriter(this.logName), true));
                this.logFile = true;
            }
            catch (IOException x) {
                if (SigTest.debug) {
                    x.printStackTrace();
                }
                return this.error(i18n.getString("SignatureTest.error.out.invfile", (Object)"-Out"));
            }
        }
        try {
            this.classpath = new ClasspathImpl(this.release, this.classpathStr);
        }
        catch (SecurityException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            this.getLog().println(i18n.getString("SignatureTest.error.sec.newclasses"));
        }
        if (this.isStatic && this.classpath.isEmpty() && this.release == null) {
            return this.error(i18n.getString("SignatureTest.error.classpath.unspec"));
        }
        return this.passed();
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase("-FileName")) {
            this.sigFileName = args[0];
        } else if (optionName.equalsIgnoreCase(FILES_OPTION)) {
            this.sigFileNameList = args[0];
        } else if (optionName.equalsIgnoreCase("-FormatPlain")) {
            this.outFormat = FORMAT_PLAIN;
        } else if (optionName.equalsIgnoreCase("-H")) {
            this.outFormat = FORMAT_HUMAN;
        } else if (optionName.equalsIgnoreCase("-FormatHuman")) {
            this.outFormat = FORMAT_HUMAN;
        } else if (optionName.equalsIgnoreCase("-Backward")) {
            this.outFormat = FORMAT_BACKWARD;
        } else if (optionName.equalsIgnoreCase("-ExtensibleInterfaces")) {
            this.extensibleInterfaces = true;
        } else if (optionName.equalsIgnoreCase("-B")) {
            this.outFormat = FORMAT_BACKWARD;
        } else if (optionName.equalsIgnoreCase("-Verbose")) {
            this.isVerbose = true;
        } else if (optionName.equalsIgnoreCase(CHECKVALUE_OPTION)) {
            this.isValueTracked = Boolean.TRUE;
        } else if (optionName.equalsIgnoreCase(NOCHECKVALUE_OPTION)) {
            this.isValueTracked = Boolean.FALSE;
        } else if (optionName.equalsIgnoreCase(WRITE_OPTION)) {
            this.writeFileName = args[0];
        } else if (optionName.equalsIgnoreCase(UPDATE_FILE_OPTION)) {
            this.updateFileName = args[0];
        } else if (optionName.equalsIgnoreCase(MODE_OPTION)) {
            if (!SOURCE_MODE.equalsIgnoreCase(args[0]) && !BINARY_MODE.equalsIgnoreCase(args[0])) {
                throw new CommandLineParserException(i18n.getString("SignatureTest.error.arg.invalid", (Object)MODE_OPTION));
            }
            this.mode = args[0];
        } else if (optionName.equalsIgnoreCase("-Out")) {
            this.logName = args[0];
        } else if (optionName.equalsIgnoreCase(ENABLESUPERSET_OPTION)) {
            this.isSupersettingEnabled = true;
        } else if (optionName.equalsIgnoreCase(NOMERGE_OPTION)) {
            this.readMode = 1;
        } else if (optionName.equalsIgnoreCase(EXCLUDE_JDK_CLASS_OPTION)) {
            excludedJdkClasses.addPackages(CommandLineParser.parseListOption(args));
        } else {
            super.decodeCommonOptions(optionName, args);
        }
    }

    @Override
    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getComponentName() + " - " + i18n.getString("SignatureTest.usage.version", (Object)"2.2"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.start"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.static", (Object)"-Static"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.mode", (Object)MODE_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.backward", "-Backward", "-B"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.classpath", (Object)"-Classpath"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.filename", (Object)"-FileName"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.or"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.files", FILES_OPTION, File.pathSeparator));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.package", (Object)"-Package"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.human", "-FormatHuman", "-H"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.out", (Object)"-Out"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.testurl", (Object)"-TestURL"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.packagewithoutsubpackages", (Object)"-PackageWithoutSubpackages"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.exclude", (Object)"-Exclude"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.nomerge", (Object)NOMERGE_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.update", (Object)UPDATE_FILE_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.excludejdkclass", (Object)EXCLUDE_JDK_CLASS_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.apiversion", (Object)"-ApiVersion"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.checkvalue", (Object)CHECKVALUE_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.formatplain", (Object)"-FormatPlain"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.extinterfaces", (Object)"-ExtensibleInterfaces"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.classcachesize", "-ClassCacheSize", new Integer(1024)));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.verbose", (Object)"-Verbose"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.debug", (Object)"-Debug"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.error_all", (Object)"-ErrorAll"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SignatureTest.helpusage.version", (Object)"-Version"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.help", (Object)"-Help"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.end"));
        System.err.println(sb.toString());
    }

    @Override
    protected String getComponentName() {
        return "Test";
    }

    @Override
    public boolean useErasurator() {
        return !isTigerFeaturesTracked || BINARY_MODE.equals(this.mode);
    }

    private boolean check() {
        if (this.pluginClass != null) {
            this.pluginClass.init(this);
        }
        if (this.readMode == 2 && this.sigFileNameList != null && this.sigFileNameList.indexOf(File.pathSeparator) >= 0) {
            try {
                if (this.writeFileName == null) {
                    File tmpF = File.createTempFile("sigtest", "sig");
                    this.writeFileName = tmpF.getAbsolutePath();
                    tmpF.deleteOnExit();
                }
                Merge m = Merge.getInstance();
                String[] args = new String[]{FILES_OPTION, this.sigFileNameList, WRITE_OPTION, this.writeFileName};
                if (BINARY_MODE.equals(this.mode)) {
                    args = new String[]{FILES_OPTION, this.sigFileNameList, WRITE_OPTION, this.writeFileName, "-Binary"};
                }
                m.testURL = this.testURL;
                m.run(args, this.getLog(), null);
                if (!m.isPassed()) {
                    this.error(m.getReason());
                    return false;
                }
                this.readMode = 1;
                this.sigFileName = this.writeFileName;
                this.sigFileNameList = null;
                this.testURL = "";
            }
            catch (IOException ex) {
                ex.printStackTrace(this.getLog());
                String msg = i18n.getString("SignatureTest.error.tmpsigfile");
                return this.error(msg);
            }
        } else {
            this.readMode = 1;
        }
        if (this.updateFileName != null) {
            try {
                Updater up = new Updater();
                File res = File.createTempFile("sigtest", "sig");
                String resFileName = res.getAbsolutePath();
                res.deleteOnExit();
                up.perform(this.updateFileName, this.sigFileName, resFileName, this.getLog());
                this.sigFileName = resFileName;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MultipleFileReader in = new MultipleFileReader(this.getLog(), this.readMode, this.getFileManager());
        String linesep = System.getProperty("line.separator");
        boolean result = this.sigFileNameList != null ? in.readSignatureFiles(this.testURL, this.sigFileNameList) : in.readSignatureFile(this.testURL, this.sigFileName);
        if (!result) {
            if (in != null) {
                in.close();
            }
            String msg = i18n.getString("SignatureTest.error.sigfile.invalid", (Object)(this.sigFileNameList == null ? this.sigFileName : this.sigFileNameList));
            this.getLog().println(msg);
            return this.error(msg);
        }
        if (this.isValueTracked == null) {
            this.isValueTracked = Boolean.TRUE;
        }
        if (this.mode == null) {
            this.mode = SOURCE_MODE;
        }
        MemberType.setMode(BINARY_MODE.equals(this.mode));
        this.isOneWayConstantChecking = this.isValueTracked != false && BINARY_MODE.equals(this.mode) || !this.isStatic;
        Object msg = "";
        if (SOURCE_MODE.equals(this.mode)) {
            this.isThrowsRemoved = false;
        }
        if (BINARY_MODE.equals(this.mode)) {
            this.isThrowsRemoved = true;
        }
        MemberType.setMode(BINARY_MODE.equals(this.mode));
        if (this.isValueTracked.booleanValue() && !in.isFeatureSupported(FeaturesHolder.ConstInfo)) {
            String errmsg = i18n.getString("SignatureTest.mesg.sigfile.noconst");
            this.getLog().println(errmsg);
            return this.failed(errmsg);
        }
        if (!in.isFeatureSupported(FeaturesHolder.ConstInfo)) {
            this.isValueTracked = Boolean.FALSE;
        }
        FieldDescr.isConstantValuesTracked = SigTest.isConstantValuesTracked = this.isValueTracked.booleanValue();
        if (((String)msg).length() != 0) {
            in.close();
            this.getLog().println((String)msg);
            return this.error((String)msg);
        }
        this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.report"));
        this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.basevers", (Object)in.getApiVersion()));
        this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.testvers", (Object)this.apiVersion));
        if (!this.isThrowsRemoved) {
            this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.checkmode.norm", (Object)this.mode));
        } else {
            this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.checkmode.removed", (Object)this.mode));
        }
        if (this.isValueTracked.booleanValue()) {
            this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.constcheck", (Object)i18n.getString("SignatureTest.mesg.sigtest.constcheck.on")));
        } else {
            this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.constcheck", (Object)i18n.getString("SignatureTest.mesg.sigtest.constcheck.off")));
        }
        if (!isTigerFeaturesTracked) {
            this.getLog().println(i18n.getString("SignatureTest.mesg.sigtest.tigercheck"));
        }
        this.getLog().println();
        this.classpath.printErrors(this.getLog());
        this.trackedClassNames = new HashSet();
        ClassDescriptionLoader loader = this.getClassDescrLoader();
        if (!this.isValueTracked.booleanValue() && loader instanceof LoadingHints) {
            ((LoadingHints)((Object)loader)).addLoadingHint(LoadingHints.DONT_READ_VALUES);
        }
        this.testableHierarchy = new ClassHierarchyImpl(loader, this.trackMode);
        this.testableMCBuilder = new MemberCollectionBuilder(this, this.jdkExclude);
        this.signatureClassesHierarchy = new ClassHierarchyImpl(in, this.trackMode);
        errorManager = this.outFormat != null && FORMAT_PLAIN.equals(this.outFormat) ? new ErrorFormatter(this.getLog()) : (this.outFormat != null && FORMAT_HUMAN.equals(this.outFormat) ? new HumanErrorFormatter(this.getLog(), this.isVerbose, this.reportWarningAsError ? Level.WARNING : Level.SEVERE) : (this.outFormat != null && FORMAT_BACKWARD.equals(this.outFormat) ? new BCProcessor(this.getLog(), this.isVerbose, BINARY_MODE.equals(this.mode), this.testableHierarchy, this.signatureClassesHierarchy, this.reportWarningAsError ? Level.WARNING : Level.SEVERE, this.extensibleInterfaces) : new SortedErrorFormatter(this.getLog(), this.isVerbose)));
        boolean buildMembers = in.isFeatureSupported(FeaturesHolder.BuildMembers);
        MemberCollectionBuilder sigfileMCBuilder = null;
        if (buildMembers) {
            sigfileMCBuilder = new MemberCollectionBuilder(this, this.jdkExclude);
        }
        msg = null;
        Erasurator localErasurator = new Erasurator();
        try {
            ClassDescription currentClass;
            ClassSet closedSet = new ClassSet(this.signatureClassesHierarchy, true);
            in.rewind();
            while ((currentClass = in.nextClass()) != null) {
                closedSet.addClass(currentClass.getQualifiedName());
            }
            Set missingClasses = closedSet.getMissingClasses();
            if (!missingClasses.isEmpty() && !this.isAPICheckMode()) {
                this.getLog().print(i18n.getString("SignatureTest.error.required_classes_missing"));
                int count = 0;
                Iterator it = missingClasses.iterator();
                while (it.hasNext()) {
                    if (count != 0) {
                        this.getLog().print(", ");
                    }
                    this.getLog().print(it.next());
                    ++count;
                }
                this.getLog().println();
                msg = i18n.getString("SignatureTest.error.non_transitively_closed_set");
                return this.error((String)msg);
            }
            in.rewind();
            boolean supportNSC = in.isFeatureSupported(FeaturesHolder.NonStaticConstants);
            while ((currentClass = in.nextClass()) != null) {
                block60: {
                    Transformer t;
                    block59: {
                        if (Xverbose) {
                            this.getLog().println(i18n.getString("SignatureTest.mesg.verbose.check", (Object)currentClass.getQualifiedName()));
                        }
                        if (buildMembers) {
                            try {
                                if (this.isAPICheckMode()) {
                                    sigfileMCBuilder.setBuildMode(MemberCollectionBuilder.BuildMode.SIGFILE);
                                }
                                sigfileMCBuilder.createMembers(currentClass, this.addInherited(), false, true);
                            }
                            catch (ClassNotFoundException e) {
                                if (!SigTest.debug) break block59;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (this.useErasurator()) {
                        currentClass = localErasurator.erasure(currentClass);
                    }
                    if ((t = PluginAPI.BEFORE_TEST.getTransformer()) != null) {
                        try {
                            t.transform(currentClass);
                        }
                        catch (ClassNotFoundException e) {
                            if (!SigTest.debug) break block60;
                            e.printStackTrace();
                        }
                    }
                }
                if (currentClass.isPackageInfo() && isTigerFeaturesTracked) {
                    this.verifyPackageInfo(currentClass);
                } else {
                    this.verifyClass(currentClass, supportNSC);
                }
                currentClass.setMembers(null);
            }
        }
        catch (OutOfMemoryError e) {
            msg = i18n.getString("SignatureTest.error.sigfile.oome");
        }
        catch (StackOverflowError e) {
            msg = i18n.getString("SignatureTest.error.sigfile.soe");
        }
        catch (VirtualMachineError e) {
            msg = i18n.getString("SignatureTest.error.sigfile.vme", (Object)e.getMessage());
        }
        catch (IOException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("SignatureTest.error.sigfile.prob") + linesep + e;
        }
        catch (SecurityException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("SignatureTest.error.sigfile.sec") + linesep + e;
        }
        catch (Error e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("SignatureTest.error.unknownerror") + e;
        }
        if (msg != null) {
            in.close();
            this.getLog().println((String)msg);
            return this.error((String)msg);
        }
        if (!this.isSupersettingEnabled) {
            this.checkAddedClasses();
        }
        if (isTigerFeaturesTracked) {
            this.checkAddedPackages();
        }
        int auxErrorCount = 0;
        errorManager.printErrors();
        if (this.reportWarningAsError) {
            auxErrorCount = this.errorMessages.size();
            this.printErrors();
        }
        this.getLog().println("");
        String repmsg = this.exclude.report();
        if (this.isVerbose) {
            System.out.println(repmsg);
        }
        int numErrors = errorManager.getNumErrors() + auxErrorCount;
        in.close();
        if (numErrors == 0) {
            return this.passed();
        }
        return this.failed(i18n.getString("SignatureTest.mesg.failed", (Object)Integer.toString(numErrors)));
    }

    protected boolean isAPICheckMode() {
        return false;
    }

    private void checkAddedClasses() {
        if (this.classpath == null) {
            return;
        }
        try {
            while (this.classpath.hasNext()) {
                String name = ExoticCharTools.encodeExotic(this.classpath.nextClassName());
                this.checkAddedClass(name);
            }
        }
        catch (SecurityException ex) {
            if (SigTest.debug) {
                ex.printStackTrace();
            }
            this.getLog().println(i18n.getString("SignatureTest.mesg.classpath.sec"));
            this.getLog().println(ex);
        }
    }

    private void checkAddedClass(String name) {
        block11: {
            if (!this.trackedClassNames.contains(name) && this.isPackageMember(name)) {
                try {
                    ClassDescription c = this.testableHierarchy.load(name);
                    if (c.isPackageInfo()) {
                        if (isTigerFeaturesTracked) {
                            this.checkAnnotations(null, c);
                        }
                    } else if (this.testableHierarchy.isAccessible(c)) {
                        this.exclude.check(c, c);
                        this.checkSupers(c);
                        errorManager.addError(MessageType.getAddedMessageType(c.getMemberType()), c.getQualifiedName(), c.getMemberType(), null, c);
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (SigTest.debug) {
                        ex.printStackTrace();
                    }
                }
                catch (LinkageError ex1) {
                    if (SigTest.debug) {
                        ex1.printStackTrace();
                    }
                }
                catch (ExcludeException e) {
                    if (!this.isVerbose) break block11;
                    this.getLog().println(i18n.getString("SignatureTest.mesg.verbose.checkAddedClass", name, e.getMessage()));
                }
            }
        }
    }

    private void checkAddedPackages() {
        ArrayList<String> wrk = new ArrayList<String>();
        Iterator it = this.trackedClassNames.iterator();
        while (it.hasNext()) {
            String pkg = ClassDescription.getPackageName((String)it.next());
            if (wrk.contains(pkg)) continue;
            wrk.add(pkg);
        }
        Collections.sort(wrk);
        it = wrk.iterator();
        while (it.hasNext()) {
            String fqn = ClassDescription.getPackageInfo((String)it.next());
            if (this.trackedClassNames.contains(fqn)) continue;
            try {
                ClassDescription c = this.testableHierarchy.load(fqn);
                this.checkAnnotations(null, c);
            }
            catch (Throwable throwable) {}
        }
    }

    private void transformPair(ClassDescription parentReq, MemberDescription required, ClassDescription parentFou, MemberDescription found) {
        if (required.isConstructor() && found.isConstructor() && parentReq.isAbstract() && parentFou.isAbstract() && (required.isProtected() && found.isPublic() || required.isPublic() && found.isProtected())) {
            required.setModifiers(required.getModifiers() & ~Modifier.PUBLIC.getValue());
            required.setModifiers(required.getModifiers() | Modifier.PROTECTED.getValue());
            found.setModifiers(found.getModifiers() & ~Modifier.PUBLIC.getValue());
            found.setModifiers(found.getModifiers() | Modifier.PROTECTED.getValue());
        }
    }

    private boolean verifyClass(ClassDescription required, boolean supportNSC) {
        block20: {
            String name = required.getQualifiedName();
            if (!this.isPackageMember(name)) {
                return this.passed();
            }
            try {
                this.exclude.check(required, required);
                ClassDescription found = this.testableHierarchy.load(name);
                this.checkSupers(found);
                if (this.testableHierarchy.isAccessible(found)) {
                    if (this.isAPICheckMode()) {
                        this.testableMCBuilder.setBuildMode(MemberCollectionBuilder.BuildMode.TESTABLE);
                        this.testableMCBuilder.setSecondClassHierarchy(this.signatureClassesHierarchy);
                    }
                    this.testableMCBuilder.createMembers(found, this.addInherited(), true, false);
                    Transformer t = PluginAPI.BEFORE_TEST.getTransformer();
                    if (t != null) {
                        t.transform(found);
                    }
                    if (this.isThrowsRemoved) {
                        required.removeThrows();
                        found.removeThrows();
                    } else {
                        this.normalizer.normThrows(found, true);
                    }
                    if (this.useErasurator()) {
                        found = this.erasurator.erasure(found);
                    } else if (FORMAT_BACKWARD.equals(this.outFormat) && !this.hasClassParameter(required) && this.hasClassParameter(found)) {
                        found = this.erasurator.erasure(found);
                        required = this.erasurator.erasure(required);
                    }
                    if (!supportNSC) {
                        this.correctConstants(found);
                    }
                    this.verifyClass(required, found);
                } else {
                    errorManager.addError(MessageType.MISS_CLASSES, name, MemberType.CLASS, null, required);
                }
            }
            catch (SuperClassesNotFoundException ex) {
                if (SigTest.debug) {
                    ex.printStackTrace();
                }
                String[] names = ex.getMissedClasses();
                for (int i = 0; i < names.length; ++i) {
                    errorManager.addError(MessageType.MISS_SUPERCLASSES, names[i], MemberType.CLASS, ex.getClassName(), required);
                }
            }
            catch (ClassNotFoundException ex) {
                if (SigTest.debug) {
                    ex.printStackTrace();
                }
                errorManager.addError(MessageType.MISS_CLASSES, name, MemberType.CLASS, null, required);
            }
            catch (LinkageError er) {
                if (SigTest.debug) {
                    er.printStackTrace();
                }
                errorManager.addError(MessageType.ERROR_LINKERR, name, MemberType.CLASS, i18n.getString("SignatureTest.mesg.linkerr.thrown", (Object)er), i18n.getString("SignatureTest.mesg.linkerr.notlink", (Object)name), required);
                this.trackedClassNames.add(name);
            }
            catch (ExcludeException e) {
                this.trackedClassNames.add(name);
                if (!this.isVerbose) break block20;
                this.getLog().println(i18n.getString("SignatureTest.mesg.verbose.verifyClass", name, e.getMessage()));
            }
        }
        return this.passed();
    }

    private void checkSupers(ClassDescription cl) throws SuperClassesNotFoundException {
        String[] fProblems;
        SuperInterface[] sif;
        ArrayList<String> fNotFound = new ArrayList<String>();
        SuperClass sc = cl.getSuperClass();
        ClassHierarchy hi = cl.getClassHierarchy();
        if (sc != null) {
            try {
                hi.load(sc.getQualifiedName());
            }
            catch (ClassNotFoundException ex) {
                fNotFound.add(ex.getMessage());
            }
        }
        if ((sif = cl.getInterfaces()) != null) {
            for (int i = 0; i < sif.length; ++i) {
                try {
                    hi.load(sif[i].getQualifiedName());
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    fNotFound.add(ex.getMessage());
                }
            }
        }
        if ((fProblems = fNotFound.toArray(new String[0])).length > 0) {
            throw new SuperClassesNotFoundException(fProblems, cl.getQualifiedName());
        }
    }

    private boolean hasClassParameter(ClassDescription cl) {
        boolean result;
        String tp = cl.getTypeParameters();
        boolean bl = result = tp != null && !"".equals(tp);
        if (!result) {
            Iterator e = cl.getMembersIterator();
            while (e.hasNext()) {
                MemberDescription mr = (MemberDescription)e.next();
                String tpM = mr.getTypeParameters();
                if (tpM == null || "".equals(tpM)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void verifyPackageInfo(ClassDescription required) {
        assert (isTigerFeaturesTracked);
        String name = required.getQualifiedName();
        if (!this.isPackageMember(name)) {
            return;
        }
        this.trackedClassNames.add(name);
        ClassDescription found = null;
        try {
            found = this.testableHierarchy.load(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkAnnotations(required, found);
    }

    private void excluded(ClassDescription testedClass, MemberDescription md) throws ExcludeException {
        if (md != null && (md.isField() || md.isMethod() || md.isConstructor() || md.isInner())) {
            this.exclude.check(testedClass, md);
        }
    }

    private void verifyClass(ClassDescription required, ClassDescription found) {
        this.trackedClassNames.add(found.getQualifiedName());
        if (errorManager instanceof SortedErrorFormatter) {
            ((SortedErrorFormatter)errorManager).tested(found);
        }
        this.checkClassDescription(required, found);
        Iterator e = required.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription requiredMember = (MemberDescription)e.next();
            try {
                this.excluded(required, requiredMember);
                this.trackMember(required, found, requiredMember, found.findMember(requiredMember));
            }
            catch (ExcludeException e1) {
                if (!this.isVerbose) continue;
                this.getLog().println(i18n.getString("SignatureTest.mesg.verbose.verifyMember", required.getQualifiedName(), requiredMember.toString(), e1.getMessage()));
            }
        }
        if (!this.isSupersettingEnabled) {
            e = found.getMembersIterator();
            while (e.hasNext()) {
                MemberDescription foundMember = (MemberDescription)e.next();
                if (required.containsMember(foundMember)) continue;
                boolean inheritedFromObject = false;
                if (required.isInterface()) {
                    try {
                        ClassDescription obj = required.getClassHierarchy().load("java.lang.Object");
                        for (MethodDescr m : obj.getDeclaredMethods()) {
                            if (!m.getName().equals(foundMember.getName()) || !m.getType().equals(foundMember.getType())) continue;
                            inheritedFromObject = true;
                        }
                    }
                    catch (ClassNotFoundException obj) {
                        // empty catch block
                    }
                }
                if (inheritedFromObject) continue;
                try {
                    this.excluded(found, foundMember);
                    this.trackMember(required, found, null, foundMember);
                }
                catch (ExcludeException e1) {
                    if (!this.isVerbose) continue;
                    this.getLog().println(i18n.getString("SignatureTest.mesg.verbose.verifyMember2", found.getQualifiedName(), foundMember.toString(), e1.getMessage()));
                }
            }
        }
    }

    private void checkClassDescription(ClassDescription required, ClassDescription found) {
        this.checkAnnotations(required, found);
        if (!required.isSubclassable()) {
            return;
        }
        if (!required.isCompatible(found)) {
            errorManager.addError(MessageType.MISS_CLASSES, required.getQualifiedName(), MemberType.CLASS, required.toString(), required);
            errorManager.addError(MessageType.ADD_CLASSES, found.getQualifiedName(), MemberType.CLASS, found.toString(), found);
        }
    }

    private MemberDescription transformMember(ClassDescription parent, MemberDescription member) {
        MemberDescription clonedMember = member;
        if (parent.hasModifier(Modifier.FINAL) && member.isMethod() && member.getDeclaringClassName().equals(parent.getQualifiedName())) {
            MethodDescr md = (MethodDescr)member;
            try {
                if (!member.hasModifier(Modifier.FINAL)) {
                    if (!this.testableHierarchy.isMethodOverriden(md)) {
                        clonedMember = (MemberDescription)member.clone();
                        clonedMember.addModifier(Modifier.FINAL);
                    }
                } else if (this.testableHierarchy.isMethodOverriden(md)) {
                    clonedMember = (MemberDescription)member.clone();
                    clonedMember.removeModifier(Modifier.FINAL);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (BINARY_MODE.equals(this.mode) && member.isMethod() && member.hasModifier(Modifier.STATIC) && member.hasModifier(Modifier.FINAL)) {
            clonedMember = (MemberDescription)member.clone();
            clonedMember.removeModifier(Modifier.FINAL);
        }
        return clonedMember;
    }

    private void trackMember(ClassDescription parentReq, ClassDescription parentFou, MemberDescription required, MemberDescription found) {
        String name = parentReq.getQualifiedName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("trackMember \n r:" + required + " \n f:" + found);
        }
        if (required != null) {
            required = this.transformMember(parentReq, required);
        }
        if (found != null) {
            found = this.transformMember(parentFou, found);
        }
        if (required != null && found != null) {
            this.transformPair(parentReq, required, parentFou, found);
            this.checkAnnotations(required, found);
            if (required.isCompatible(found)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("compatible! :-)");
                }
                return;
            }
            if (this.isOneWayConstantChecking && required.isField()) {
                assert (found.isField());
                String rConstValue = ((FieldDescr)required).getConstantValue();
                String fConstValue = ((FieldDescr)found).getConstantValue();
                if (rConstValue == null && fConstValue != null && ((FieldDescr)required).isCompatible(found, true)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("compatible! :-)");
                    }
                    return;
                }
                if (fConstValue == null && rConstValue != null && !found.isStatic() && ((FieldDescr)required).isCompatible(found, true)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("compatible! :-)");
                    }
                    return;
                }
            }
        }
        if (required != null) {
            errorManager.addError(MessageType.getMissingMessageType(required.getMemberType()), name, required.getMemberType(), required.toString(), required);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("missing :-( " + required);
            }
        }
        if (!this.isSupersettingEnabled && found != null && !this.jdkExclude.isJdkClass(found.getDeclaringClassName())) {
            errorManager.addError(MessageType.getAddedMessageType(found.getMemberType()), name, found.getMemberType(), found.toString(), found);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("added :-( " + found);
            }
        }
    }

    private void checkAnnotations(MemberDescription base, MemberDescription test) {
        AnnotationItem[] testAnnotList;
        if (!isTigerFeaturesTracked) {
            return;
        }
        AnnotationItem[] baseAnnotList = base == null ? AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY : this.removeUndocumentedAnnotations(base.getAnnoList(), this.signatureClassesHierarchy);
        AnnotationItem[] annotationItemArray = testAnnotList = test == null ? AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY : this.removeUndocumentedAnnotations(test.getAnnoList(), this.testableHierarchy);
        if (!this.isStatic) {
            baseAnnotList = this.removeExtendedAnnotations(baseAnnotList);
        }
        if (baseAnnotList.length == 0 && testAnnotList.length == 0) {
            return;
        }
        int bl = baseAnnotList.length;
        int tl = testAnnotList.length;
        int bPos = 0;
        int tPos = 0;
        if (base != null && this.jdkExclude.isJdkClass(base.getDeclaringClassName())) {
            return;
        }
        if (test != null && this.jdkExclude.isJdkClass(test.getDeclaringClassName())) {
            return;
        }
        while (bPos < bl && tPos < tl) {
            int comp = 0;
            comp = this.jdkExclude.isJdkClass(baseAnnotList[bPos].getName()) || this.jdkExclude.isJdkClass(testAnnotList[tPos].getName()) ? baseAnnotList[bPos].getName().compareTo(testAnnotList[tPos].getName()) : baseAnnotList[bPos].compareTo(testAnnotList[tPos]);
            if (comp < 0) {
                this.reportError(base, baseAnnotList[bPos].toString(), false);
                ++bPos;
                continue;
            }
            if (comp > 0) {
                this.reportError(test, testAnnotList[tPos].toString(), true);
                ++tPos;
                continue;
            }
            ++tPos;
            ++bPos;
        }
        while (bPos < bl) {
            this.reportError(base, baseAnnotList[bPos].toString(), false);
            ++bPos;
        }
        while (tPos < tl) {
            this.reportError(test, testAnnotList[tPos].toString(), true);
            ++tPos;
        }
    }

    private AnnotationItem[] removeExtendedAnnotations(AnnotationItem[] baseAnnotList) {
        if (baseAnnotList == null) {
            return AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        }
        ArrayList<AnnotationItem> list = new ArrayList<AnnotationItem>(Arrays.asList(baseAnnotList));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof AnnotationItemEx)) continue;
            it.remove();
        }
        return list.toArray(new AnnotationItem[0]);
    }

    private void reportError(MemberDescription fid, String anno, boolean added) {
        if (fid != null) {
            errorManager.addError(added ? MessageType.ADD_ANNO : MessageType.MISS_ANNO, fid.getQualifiedName(), fid.getMemberType(), anno, fid);
        }
    }

    static class DefaultJDKExclude
    implements JDKExclude {
        DefaultJDKExclude() {
        }

        @Override
        public boolean isJdkClass(String name) {
            return name != null && excludedJdkClasses.checkName(name);
        }
    }

    static class DefaultExcludeList
    implements Exclude {
        @Override
        public void check(ClassDescription testedClassName, MemberDescription signature) throws ExcludeException {
        }

        @Override
        public String[] parseParameters(String[] args) {
            return args;
        }

        @Override
        public String report() {
            return null;
        }
    }

    static class SuperClassesNotFoundException
    extends ClassNotFoundException {
        private String[] scNames;
        private String clName;

        private SuperClassesNotFoundException(String[] scNames, String clName) {
            if (scNames == null || scNames.length == 0) {
                throw new IllegalArgumentException("Superclass list can not be empty");
            }
            this.clName = clName;
            this.scNames = scNames;
        }

        @Override
        public String getMessage() {
            if (this.scNames.length == 1) {
                return "Superclass " + this.scNames[0] + " of class " + this.clName + " not found";
            }
            StringBuffer sb = new StringBuffer("[");
            for (int i = 0; i < this.scNames.length; ++i) {
                sb.append(this.scNames[i]);
                if (i == this.scNames.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return "Superclasses " + sb.toString() + " of class " + this.clName + " not found";
        }

        private String getClassName() {
            return this.clName;
        }

        private String[] getMissedClasses() {
            return this.scNames;
        }
    }
}

