/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.classpath.ClasspathEntry;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;

class DirectoryEntry
extends ClasspathEntry {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(DirectoryEntry.class);
    private String directoryName = "";

    public DirectoryEntry(ClasspathEntry previous, String name) throws IOException {
        super(previous);
        this.init(name);
    }

    @Override
    public void init(String directoryName) throws IOException {
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            throw new IOException(i18n.getString("DirectoryEntry.error.invdir", (Object)directoryName));
        }
        this.directoryName = directoryName;
        this.classes = new LinkedHashSet();
        this.scanDirectory(directory, "");
        this.currentPosition = this.classes.iterator();
    }

    @Override
    public void close() {
    }

    private void scanDirectory(File directory, String packageName) {
        block7: {
            int pos;
            int startPos = 0;
            int depth = 0;
            do {
                if ((pos = packageName.indexOf(46, startPos)) != -1) {
                    ++depth;
                    startPos = pos + 1;
                }
                if (depth <= 512) continue;
                return;
            } while (pos != -1);
            try {
                String[] files = directory.list();
                if (files == null) {
                    return;
                }
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < files.length; ++i) {
                    Object namePrefix;
                    File current = new File(directory, files[i]);
                    Object object = namePrefix = packageName.equals("") ? "" : packageName + ".";
                    if (current.isDirectory()) {
                        this.scanDirectory(current, (String)namePrefix + files[i]);
                        continue;
                    }
                    if (!files[i].endsWith(".class")) continue;
                    buf.setLength(0);
                    buf.append((String)namePrefix);
                    buf.append(files[i].substring(0, files[i].length() - JAVA_CLASSFILE_EXTENSION_LEN));
                    String className = buf.toString();
                    if (this.contains(className)) continue;
                    this.classes.add(className.intern());
                }
            }
            catch (SecurityException e) {
                if (!SigTest.debug) break block7;
                e.printStackTrace();
            }
        }
    }

    @Override
    public InputStream findClass(String name) throws IOException, ClassNotFoundException {
        if (!this.classes.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        name = ExoticCharTools.decodeExotic(name);
        return new FileInputStream(new File(this.constructFileName(name)));
    }

    private String constructFileName(String name) {
        StringBuffer buf = new StringBuffer(256);
        buf.append(this.directoryName);
        buf.append(File.separator);
        buf.append(name.replace('.', File.separatorChar));
        buf.append(".class");
        return buf.toString();
    }
}

