/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.loaders;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.loaders.LoadingHints;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TigerRefgClassDescrLoader
implements ClassDescriptionLoader,
LoadingHints {
    public static boolean debug = false;
    private static final String object = "java.lang.Object";
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TigerRefgClassDescrLoader.class);
    private ClassLoader ldr;
    private HashSet hints = new HashSet();

    public TigerRefgClassDescrLoader() {
        this(null);
    }

    public TigerRefgClassDescrLoader(ClassLoader l) {
        this.ldr = l == null ? this.getClass().getClassLoader() : l;
    }

    @Override
    public ClassDescription load(String name) throws ClassNotFoundException {
        ClassDescription cd = new ClassDescription();
        name = ExoticCharTools.decodeExotic(name);
        try {
            this.readClass(cd, Class.forName(name, false, this.ldr));
        }
        catch (GenericSignatureFormatError e) {
            e.printStackTrace();
            throw e;
        }
        return cd;
    }

    private void readClass(ClassDescription c, Class classObject) {
        int x = classObject.getModifiers();
        c.setModifiers(x);
        Class<?> dclObject = classObject.getDeclaringClass();
        c.setupClassName(classObject.getName(), dclObject == null ? "" : dclObject.getName());
        c.setTiger(true);
        ClassDescription.TypeParameterList enc = null;
        if (dclObject != null) {
            ClassDescription dclCD = new ClassDescription();
            this.readClass(dclCD, dclObject);
            enc = dclCD.getTypeparamList();
        }
        c.setTypeparamList(new ClassDescription.TypeParameterList(enc));
        c.setTypeParameters(this.scanFormalTypeParameters(c.getTypeparamList(), classObject.getTypeParameters(), c.getQualifiedName()));
        Type spr = classObject.getGenericSuperclass();
        if (spr != null) {
            SuperClass superClass = new SuperClass();
            superClass.setupGenericClassName(this.decodeType(c.getTypeparamList(), spr));
            c.setSuperClass(superClass);
        }
        Type[] ifs = classObject.getGenericInterfaces();
        c.createInterfaces(ifs.length);
        for (int i = 0; i < ifs.length; ++i) {
            SuperInterface fid = new SuperInterface();
            fid.setupGenericClassName(this.decodeType(c.getTypeparamList(), ifs[i]));
            c.setInterface(i, fid);
        }
        c.setAnnoList(AnnotationItem.toArray(this.parse(c, 0, classObject.getDeclaredAnnotations())));
        this.readFields(c, classObject);
        this.readCtors(c, classObject);
        this.readMethods(c, classObject);
        this.readNested(c, classObject);
    }

    private void readFields(ClassDescription c, Class classObject) {
        Field[] tmp = classObject.getDeclaredFields();
        c.createFields(tmp.length - this.getSyntheticFieldCount(tmp));
        String fqname = c.getQualifiedName();
        int j = -1;
        for (int i = 0; i < tmp.length; ++i) {
            FieldDescr fid;
            Field fld;
            block6: {
                fld = tmp[i];
                if (fld.isSynthetic()) {
                    if (!SigTest.debug) continue;
                    System.out.println(i18n.getString("TigerRefgClassDescrLoader.message.synthetic_field_skipped", (Object)fld));
                    continue;
                }
                fid = new FieldDescr(fld.getName(), fqname, fld.getModifiers());
                c.setField(++j, fid);
                fid.setType(this.decodeType(c.getTypeparamList(), fld.getGenericType()));
                if (fid.isFinal() && (PrimitiveTypes.isPrimitive(fid.getType()) || "java.lang.String".equals(fid.getType())) && !this.hasHint(LoadingHints.DONT_READ_VALUES)) {
                    try {
                        fld.setAccessible(true);
                        Object v = fld.get(null);
                        fid.setConstantValue(MemberDescription.valueToString(v));
                    }
                    catch (UnsupportedClassVersionError e) {
                        System.err.printf("Constant value for field %s in type %s cannot be resolved.%n", fld, fqname);
                        e.printStackTrace(System.err);
                    }
                    catch (Throwable e) {
                        if (!debug) break block6;
                        System.err.println("Error during reading field value " + fld.toString());
                        e.printStackTrace(System.err);
                    }
                }
            }
            fid.setAnnoList(AnnotationItem.toArray(this.parse(c, 0, fld.getDeclaredAnnotations())));
        }
    }

    private void readCtors(ClassDescription c, Class classObject) {
        Constructor[] tmp = classObject.getDeclaredConstructors();
        c.createConstructors(tmp.length - this.getSyntheticConstructorCount(tmp));
        String fqname = c.getQualifiedName();
        int j = -1;
        for (int i = 0; i < tmp.length; ++i) {
            Constructor ctor = tmp[i];
            if (ctor.isSynthetic()) {
                if (!SigTest.debug) continue;
                System.out.println(i18n.getString("TigerRefgClassDescrLoader.message.synthetic_constr_skipped", (Object)ctor));
                continue;
            }
            ConstructorDescr fid = new ConstructorDescr(c, ctor.getModifiers());
            c.setConstructor(++j, fid);
            if (ctor.isVarArgs()) {
                fid.addModifier(Modifier.VARARGS);
            }
            fid.setTypeParameters(this.scanFormalTypeParameters(c.getTypeparamList(), ctor.getTypeParameters(), "%"));
            fid.setArgs(this.getArgs(c.getTypeparamList(), ctor.getGenericParameterTypes()));
            fid.setThrowables(this.getThrows(c.getTypeparamList(), ctor.getGenericExceptionTypes()));
            c.getTypeparamList().clear("%");
            List alist = this.parse(c, 0, ctor.getDeclaredAnnotations());
            Annotation[][] aas = ctor.getParameterAnnotations();
            if (aas != null && aas.length != 0) {
                for (int k = 0; k < aas.length; ++k) {
                    alist.addAll(this.parse(c, k + 1, aas[k]));
                }
            }
            fid.setAnnoList(AnnotationItem.toArray(alist));
        }
    }

    private int getSyntheticMethodCount(Method[] methods) {
        int count = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isSynthetic()) continue;
            ++count;
        }
        return count;
    }

    private int getSyntheticConstructorCount(Constructor[] ctors) {
        int count = 0;
        for (int i = 0; i < ctors.length; ++i) {
            if (!ctors[i].isSynthetic()) continue;
            ++count;
        }
        return count;
    }

    private int getSyntheticFieldCount(Field[] flds) {
        int count = 0;
        for (int i = 0; i < flds.length; ++i) {
            if (!flds[i].isSynthetic()) continue;
            ++count;
        }
        return count;
    }

    private void readMethods(ClassDescription c, Class classObject) {
        Method[] tmp = classObject.getDeclaredMethods();
        c.createMethods(tmp.length - this.getSyntheticMethodCount(tmp));
        String fqname = c.getQualifiedName();
        ClassDescription.TypeParameterList tp = c.getTypeparamList();
        int j = -1;
        for (int i = 0; i < tmp.length; ++i) {
            Method mtd = tmp[i];
            if (mtd.isSynthetic()) {
                if (!SigTest.debug) continue;
                System.out.println(i18n.getString("TigerRefgClassDescrLoader.message.synthetic_method_skipped", (Object)mtd));
                continue;
            }
            int mod = mtd.getModifiers();
            MethodDescr fid = new MethodDescr(mtd.getName(), fqname, mod);
            c.setMethod(++j, fid);
            if (mtd.getDefaultValue() != null) {
                fid.addModifier(Modifier.HASDEFAULT);
            }
            if (mtd.isVarArgs()) {
                fid.addModifier(Modifier.VARARGS);
            }
            fid.setTypeParameters(this.scanFormalTypeParameters(c.getTypeparamList(), mtd.getTypeParameters(), "%"));
            fid.setType(this.decodeType(tp, mtd.getGenericReturnType()));
            fid.setArgs(this.getArgs(tp, mtd.getGenericParameterTypes()));
            fid.setThrowables(this.getThrows(tp, mtd.getGenericExceptionTypes()));
            c.getTypeparamList().clear("%");
            List alist = this.parse(c, 0, mtd.getDeclaredAnnotations());
            Annotation[][] aas = mtd.getParameterAnnotations();
            if (aas != null && aas.length != 0) {
                for (int k = 0; k < aas.length; ++k) {
                    alist.addAll(this.parse(c, k + 1, aas[k]));
                }
            }
            fid.setAnnoList(AnnotationItem.toArray(alist));
        }
    }

    private int getSyntheticNestedCount(Class[] clss) {
        int count = 0;
        for (int i = 0; i < clss.length; ++i) {
            if (!clss[i].isSynthetic()) continue;
            ++count;
        }
        return count;
    }

    private void readNested(ClassDescription c, Class classObject) {
        Class[] nestedClasses = classObject.getDeclaredClasses();
        if (nestedClasses.length != 0) {
            c.createNested(nestedClasses.length - this.getSyntheticNestedCount(nestedClasses));
            int j = -1;
            for (int i = 0; i < nestedClasses.length; ++i) {
                Class nc = nestedClasses[i];
                if (nc.isSynthetic()) continue;
                c.setNested(++j, new InnerDescr(nc.getName(), classObject.getName(), nc.getModifiers()));
            }
        }
    }

    private String scanFormalTypeParameters(ClassDescription.TypeParameterList typeparamList, TypeVariable[] params, String declared) {
        if (params == null || params.length == 0) {
            return null;
        }
        typeparamList.reset_count();
        for (int i = 0; i < params.length; ++i) {
            typeparamList.add(params[i].getName(), declared);
        }
        StringBuffer sb = new StringBuffer("<");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append('%').append(String.valueOf(i));
            Type[] bounds = params[i].getBounds();
            ArrayList<String> tmp = new ArrayList<String>();
            for (int k = 0; k < bounds.length; ++k) {
                tmp.add(this.decodeType(typeparamList, bounds[k]));
            }
            String first = (String)tmp.remove(0);
            sb.append(" extends ").append(first);
            if (tmp.size() == 0) continue;
            Collections.sort(tmp);
            for (int k = 0; k < tmp.size(); ++k) {
                sb.append(" & ").append((String)tmp.get(k));
            }
        }
        sb.append(">");
        return sb.toString();
    }

    private String getArgs(ClassDescription.TypeParameterList typeparamList, Type[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.decodeType(typeparamList, args[i]));
        }
        return sb.toString();
    }

    private String getThrows(ClassDescription.TypeParameterList typeparamList, Type[] xthrows) {
        String[] tmp = new String[xthrows.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.decodeType(typeparamList, xthrows[i]);
        }
        return MemberDescription.getThrows(tmp);
    }

    private String decodeType(ClassDescription.TypeParameterList typeparamList, Type t) {
        if (t instanceof Class) {
            Class x = (Class)t;
            return MemberDescription.getTypeName(x);
        }
        if (t instanceof TypeVariable) {
            TypeVariable x = (TypeVariable)t;
            return typeparamList.replace(x.getName());
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType x = (GenericArrayType)t;
            return this.decodeType(typeparamList, x.getGenericComponentType()) + "[]";
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType x = (ParameterizedType)t;
            return this.decodeType(typeparamList, x.getRawType()) + this.decodeArguments(typeparamList, x);
        }
        if (t instanceof WildcardType) {
            WildcardType x = (WildcardType)t;
            StringBuffer sb = new StringBuffer("?");
            Type[] bounds = x.getLowerBounds();
            if (bounds != null && bounds.length != 0 && (bounds[0] != null || bounds.length > 1)) {
                sb.append(" super ").append(this.decodeBounds(typeparamList, bounds));
            }
            if ((bounds = x.getUpperBounds()) != null) {
                String s = this.decodeBounds(typeparamList, bounds);
                if (s.startsWith(object)) {
                    s = s.substring(object.length()).trim();
                }
                if (s.length() > 0) {
                    sb.append(" extends ").append(s);
                }
            }
            return sb.toString();
        }
        assert (false);
        return "???" + (t == null ? "notype" : t.getClass().getName());
    }

    private String decodeBounds(ClassDescription.TypeParameterList tp, Type[] bounds) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bounds.length; ++i) {
            if (i != 0) {
                sb.append(" & ");
            }
            sb.append(bounds[i] == null ? object : this.decodeType(tp, bounds[i]));
        }
        return sb.toString();
    }

    private String decodeArguments(ClassDescription.TypeParameterList tp, ParameterizedType d) {
        StringBuffer sb = new StringBuffer();
        Type[] vv = d.getActualTypeArguments();
        if (vv != null) {
            for (int i = 0; i < vv.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                if (vv[i] == null) continue;
                sb.append(this.decodeType(tp, vv[i]));
            }
        }
        return sb.length() == 0 ? "" : "<" + sb.toString() + ">";
    }

    List parse(ClassDescription c, int target, Annotation[] xx) {
        ArrayList<AnnotationItem> annolist = new ArrayList<AnnotationItem>();
        if (xx != null) {
            for (int i = 0; i < xx.length; ++i) {
                annolist.add(this.parse(c, target, xx[i]));
            }
        }
        return annolist;
    }

    AnnotationItem parse(ClassDescription c, int target, Annotation a) {
        Class<? extends Annotation> intf = a.annotationType();
        AnnotationItem anno = new AnnotationItem(target, intf.getName());
        if (intf.isAnnotationPresent(Inherited.class)) {
            anno.setInheritable(true);
        }
        AccessibleObject[] mm = intf.getDeclaredMethods();
        AccessibleObject.setAccessible(mm, true);
        ClassDescription.TypeParameterList tp = c.getTypeparamList();
        if (mm != null && mm.length != 0) {
            for (int k = 0; k < mm.length; ++k) {
                try {
                    AccessibleObject m = mm[k];
                    AnnotationItem.Member member = new AnnotationItem.Member(this.decodeType(tp, ((Method)m).getGenericReturnType()), ((Method)m).getName(), null);
                    Object value = ((Method)m).invoke(a, null);
                    if (value instanceof Annotation) {
                        member.setValue(this.parse(c, 0, (Annotation)value));
                    } else if (value instanceof Annotation[]) {
                        Annotation[] tmp_value = (Annotation[])value;
                        AnnotationItem[] items = new AnnotationItem[tmp_value.length];
                        for (int i = 0; i < tmp_value.length; ++i) {
                            items[i] = this.parse(c, 0, tmp_value[i]);
                        }
                        member.setValue(items);
                    } else {
                        member.setValue(value);
                    }
                    anno.addMember(member);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Error(i18n.getString("TigerRefgClassDescrLoader.error.invalidannot", (Object)a));
                }
            }
        }
        return anno;
    }

    @Override
    public void addLoadingHint(LoadingHints.Hint hint) {
        this.hints.add(hint);
    }

    private boolean hasHint(LoadingHints.Hint hint) {
        return this.hints.contains(hint);
    }
}

