/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.netbeans.apitest.ListCtSym;
import org.netbeans.apitest.SigtestHandler;

@Mojo(name="check", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.TEST)
public final class SigtestCheck
extends AbstractMojo {
    @Component
    private MavenProject prj;
    @Component
    private MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File classes;
    @Parameter
    private File sigfile;
    @Parameter(property="maven.compiler.release")
    private String release;
    @Parameter(property="sigtest.releaseVersion")
    private String releaseVersion;
    @Parameter(defaultValue="check", property="sigtest.check")
    private String action;
    @Parameter(defaultValue="")
    private String packages;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/sigtest/TEST-${project.build.finalName}.xml")
    private File report;
    @Parameter(defaultValue="true", property="sigtest.fail")
    private boolean failOnError;
    @Parameter
    private String[] ignoreJDKClasses;

    public SigtestCheck() {
    }

    SigtestCheck(MavenProject prj, File classes, File sigfile, String action, String packages, File report, boolean failOnError) {
        this.prj = prj;
        this.classes = classes;
        this.sigfile = sigfile;
        this.action = action;
        this.packages = packages;
        this.report = report;
        this.failOnError = failOnError;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packages == null) {
            this.getLog().info((CharSequence)("No packages specified, skipping sigtest:check " + this.action));
            return;
        }
        if (this.sigfile == null && this.releaseVersion == null) {
            throw new MojoExecutionException("Specify <sigfile>path-to-file-generated-before</sigfile> in plugin config section!\nOr specify <releaseVersion>version-to-compare to</releaseVersion> to download sigfile generated and attached by 'generate' target previously");
        }
        if (this.classes == null || !this.classes.exists()) {
            throw new MojoExecutionException("Point <classes>to-directory-with-classfiles-to-test</classes> in plugin config section!");
        }
        SigtestHandler handler = new SigtestHandler(){

            @Override
            protected String getPackages() {
                return SigtestCheck.this.packages;
            }

            @Override
            protected File getFileName() {
                return SigtestCheck.this.sigfile;
            }

            @Override
            protected String getAction() {
                return SigtestCheck.this.action;
            }

            @Override
            protected String getVersion() {
                return SigtestCheck.this.prj.getVersion();
            }

            @Override
            protected String[] getClasspath() {
                return SigtestCheck.projectClassPath(SigtestCheck.this.prj, SigtestCheck.this.classes);
            }

            @Override
            protected File getReport() {
                return SigtestCheck.this.report;
            }

            @Override
            protected String getMail() {
                return null;
            }

            @Override
            protected Boolean isFailOnError() {
                return SigtestCheck.this.failOnError;
            }

            @Override
            protected void logInfo(String message) {
                SigtestCheck.this.getLog().info((CharSequence)message);
            }

            @Override
            protected void logError(String message) {
                SigtestCheck.this.getLog().error((CharSequence)message);
            }

            @Override
            protected Integer getRelease() {
                return ListCtSym.parseReleaseInteger(SigtestCheck.this.release);
            }

            @Override
            protected String[] getIgnoreJDKClassEntries() {
                return SigtestCheck.this.ignoreJDKClasses;
            }
        };
        try {
            int returnCode;
            if (this.sigfile == null) {
                DefaultArtifact artifact = new DefaultArtifact(this.prj.getGroupId(), this.prj.getArtifactId(), this.releaseVersion, null, "sigfile", "", (ArtifactHandler)new DefaultArtifactHandler("sigfile"));
                try {
                    this.artifactResolver.resolve((Artifact)artifact, this.session.getProjectBuildingRequest().getRemoteRepositories(), this.session.getLocalRepository());
                    this.sigfile = artifact.getFile();
                }
                catch (AbstractArtifactResolutionException ex) {
                    throw new MojoExecutionException("Cannot download " + (Artifact)artifact, (Exception)((Object)ex));
                }
            }
            if ((returnCode = handler.execute()) != 0) {
                throw new MojoFailureException("Signature check for " + this.sigfile + " failed with " + returnCode);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    static String[] projectClassPath(MavenProject project, File classes) {
        LinkedHashSet<String> path = new LinkedHashSet<String>();
        path.add(classes.getAbsolutePath());
        path.add(project.getBuild().getOutputDirectory());
        for (Artifact a : project.getArtifacts()) {
            if (a.getFile() == null || !a.getFile().exists()) continue;
            path.add(a.getFile().getAbsolutePath());
        }
        return path.toArray(new String[0]);
    }
}

