/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.apicover.RefCounter;
import com.sun.tdk.apicover.ReportGenerator;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.PackageDescr;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;

class ReportPlain
extends ReportGenerator {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ReportPlain.class);
    final int p0 = 0;
    final int p1 = 4;
    final int p2 = 8;
    final int p3 = 40;
    final int p4 = 50;
    final int p5 = 58;
    final int p6 = 66;
    final int p7 = 74;
    int packnb = 0;
    Erasurator erasurator = new Erasurator();
    StringBuffer line = new StringBuffer(120);

    public ReportPlain(RefCounter reporter) {
        super(reporter);
    }

    @Override
    public void print() {
        this.tab(0).append(i18n.getString("ReportPlain.report.Coverage"));
        this.println();
        this.println();
        this.tab(74, '=');
        this.println();
        this.tab(0).append(i18n.getString("ReportPlain.report.Package"));
        this.tab(40).append(i18n.getString("ReportPlain.report.classes"));
        this.println();
        this.tab(4).append(i18n.getString("ReportPlain.report.Class"));
        this.tab(50).append(i18n.getString("ReportPlain.report.members"));
        this.tab(58).append(i18n.getString("ReportPlain.report.tested"));
        this.tab(66).append("%%");
        this.println();
        if (this.detail > 1) {
            this.tab(8).append(i18n.getString("ReportPlain.report.Member"));
            this.println();
        }
        this.tab(74, '=');
        this.println();
        this.visit(this.api);
        this.tab(74, '=');
        this.println();
        this.tab(0).append(i18n.getString("ReportPlain.report.Overall"));
        int members = 0;
        int tested = 0;
        int classes = 0;
        for (ClassDescription cd : this.api) {
            members += ((ReportGenerator.Field)this.results.get((Object)cd.toString())).members;
            tested += ((ReportGenerator.Field)this.results.get((Object)cd.toString())).tested;
            ++classes;
        }
        ReportGenerator.Field all = new ReportGenerator.Field(classes, members, tested);
        this.tab(40).append(all.classes);
        this.tab(50).append(all.members);
        this.tab(58).append(all.tested);
        if (all.members != 0) {
            this.tab(66).append(all.getPercent());
        }
        this.println();
        this.tab(74, '=');
        this.println();
        this.println();
        if (this.detail == 4) {
            this.tab(0).append(i18n.getString("ReportPlain.report.Legend"));
            this.println();
            this.tab(0).append("+ ").append(i18n.getString("ReportPlain.report.covered"));
            this.println();
            this.tab(0).append("- ").append(i18n.getString("ReportPlain.report.uncovered"));
            this.println();
            this.println();
        }
        this.tab(0).append(i18n.getString("ReportPlain.report.Configuration"));
        String[] keys = new String[]{"-ts", "-excludeList", "-api", "-excludeInterfaces", "-excludeAbstractClasses", "-excludeAbstractMethods", "-excludeFields", "-includeConstantFields", "-mode"};
        int t = 0;
        for (String key : keys) {
            int l;
            if (this.config.get(key) == null || (l = key.length() - 1) <= t) continue;
            t = l;
        }
        ++t;
        for (String key : keys) {
            if (this.config.get(key) == null) continue;
            this.println();
            this.tab(0).append(key.substring(1));
            this.tab(t).append(((String[])this.config.get(key))[0]);
        }
        this.println();
        this.pw.close();
    }

    @Override
    protected void visit(PackageDescr pd) {
        if (pd.equals(this.top)) {
            super.visit(pd);
            return;
        }
        if (this.packnb++ > 0 && this.detail > 1) {
            this.tab(74, '-');
            this.println();
        }
        int members = ((ReportGenerator.Field)this.results.get((Object)pd.toString())).members;
        int tested = ((ReportGenerator.Field)this.results.get((Object)pd.toString())).tested;
        String percent = ((ReportGenerator.Field)this.results.get(pd.toString())).getPercent();
        this.tab(0).append(pd.getQualifiedName());
        this.tab(40).append(((ReportGenerator.Field)this.results.get((Object)pd.toString())).classes);
        this.tab(50).append(members);
        this.tab(58).append(tested);
        if (members != 0) {
            this.tab(66).append(percent);
        }
        this.println();
        super.visit(pd);
    }

    @Override
    protected void visit(ClassDescription cd) {
        if (this.detail == 0) {
            return;
        }
        if (this.detail > 1) {
            this.println();
        }
        this.tab(4).append(ReportPlain.classRepr(cd));
        int members = ((ReportGenerator.Field)this.results.get((Object)cd.toString())).members;
        int tested = ((ReportGenerator.Field)this.results.get((Object)cd.toString())).tested;
        String percent = ((ReportGenerator.Field)this.results.get(cd.toString())).getPercent();
        this.tab(50).append(members);
        this.tab(58).append(tested);
        if (members != 0) {
            this.tab(66).append(percent);
        }
        this.println();
        this.erasurator.parseTypeParameters(cd);
        super.visit(cd);
    }

    @Override
    protected void visit(MemberDescription x) {
        this.printMember(x, this.refCounter.isCovered(x));
    }

    void printMember(MemberDescription md, boolean isCovered) {
        if (this.detail < 2) {
            return;
        }
        if (this.detail == 2 && isCovered) {
            return;
        }
        if (this.detail == 3 && !isCovered) {
            return;
        }
        md = this.erasurator.processMember(md);
        this.tab(6).append(isCovered ? (char)'+' : '-');
        this.tab(8).append(md.getName() + (String)(md.isField() ? "" : "(" + md.getArgs() + ")"));
        this.println();
    }

    StringBuffer tab(int p) {
        return this.tab(p, ' ');
    }

    StringBuffer tab(int p, char c) {
        for (int n = p - this.line.length(); n > 0; --n) {
            this.line.append(c);
        }
        return this.line;
    }

    void println() {
        this.pw.println(this.line.toString());
        this.line.setLength(0);
    }
}

