/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.classpath.Release;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.JDKExclude;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.core.ThrowsNormalizer;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.plugin.Context;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.Plugin;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SigTest
extends Result
implements PluginAPI,
Log {
    public static final String ALLPUBLIC_OPTION = "-AllPublic";
    public static final String CLASSPATH_OPTION = "-Classpath";
    public static final String USE_BOOT_CP = "-BootCp";
    public static final String PACKAGE_OPTION = "-Package";
    public static final String WITHOUTSUBPACKAGES_OPTION = "-PackageWithoutSubpackages";
    public static final String EXCLUDE_OPTION = "-Exclude";
    public static final String STATIC_OPTION = "-Static";
    public static final String APIVERSION_OPTION = "-ApiVersion";
    public static final String VERSION_OPTION = "-Version";
    public static final String DEBUG_OPTION = "-Debug";
    public static final String HELP_OPTION = "-Help";
    public static final String QUESTIONMARK = "-?";
    public static final String CLASSCACHESIZE_OPTION = "-ClassCacheSize";
    public static final String VERBOSE_OPTION = "-Verbose";
    public static final String XVERBOSE_OPTION = "-Xverbose";
    public static final String XNOTIGER_OPTION = "-XnoTiger";
    public static final String OUT_OPTION = "-Out";
    public static final String FORMATPLAIN_OPTION = "-FormatPlain";
    public static final String FORMATHUMAN_OPTION = "-FormatHuman";
    public static final String FORMATHUMAN_ALT_OPTION = "-H";
    public static final String BACKWARD_OPTION = "-Backward";
    public static final String BACKWARD_ALT_OPTION = "-B";
    public static final String EXTENSIBLE_INTERFACES_OPTION = "-ExtensibleInterfaces";
    public static final String FILENAME_OPTION = "-FileName";
    public static final String TESTURL_OPTION = "-TestURL";
    public static final String PLUGIN_OPTION = "-Plugin";
    public static final String ERRORALL_OPTION = "-ErrorAll";
    public static final String EXCLUDE_JDK_CLASS_OPTION = "-IgnoreJDKClass";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SigTest.class);
    protected String testURL = "";
    protected String sigFileNameList = null;
    protected String sigFileName = null;
    private FileManager fm = new FileManager();
    protected int trackMode;
    protected PackageGroup packages = new PackageGroup(true);
    protected PackageGroup purePackages = new PackageGroup(false);
    protected PackageGroup excludedPackages = new PackageGroup(true);
    protected String classpathStr = null;
    protected Release release;
    protected static ErrorFormatter errorManager;
    protected String apiVersion = "";
    protected MemberCollectionBuilder testableMCBuilder;
    protected ThrowsNormalizer normalizer = new ThrowsNormalizer();
    protected boolean isStatic = false;
    public static boolean isConstantValuesTracked;
    public static final int DefaultCacheSize = 1024;
    protected int cacheSize = 1024;
    private PrintWriter log;
    public static boolean debug;
    protected ClasspathImpl classpath;
    public static boolean isTigerFeaturesTracked;
    protected Plugin pluginClass = null;
    static boolean Xverbose;
    protected ClassHierarchy testableHierarchy;
    protected Set errorMessages = new HashSet();
    private ClassDescriptionLoader loader;
    protected boolean reportWarningAsError = false;
    protected int errors;

    public void initErrors() {
        this.errorMessages.clear();
    }

    @Override
    public void storeError(String s, Logger utilLogger) {
        if (utilLogger != null && utilLogger.isLoggable(Level.SEVERE)) {
            utilLogger.severe(s);
        }
        this.errorMessages.add(s);
    }

    @Override
    public void storeWarning(String s, Logger utilLogger) {
        if (this.reportWarningAsError) {
            this.storeError(s, utilLogger);
            return;
        }
        if (utilLogger != null && utilLogger.isLoggable(Level.WARNING)) {
            utilLogger.warning(s);
        }
        this.log.println(i18n.getString("SigTest.warning", (Object)s));
    }

    public void printErrors() {
        Iterator it = this.errorMessages.iterator();
        while (it.hasNext()) {
            this.setupProblem((String)it.next());
        }
        this.initErrors();
    }

    protected void setupProblem(String msg) {
        this.log.println(msg);
        ++this.errors;
    }

    protected void setLog(PrintWriter w) {
        this.log = w;
    }

    public PrintWriter getLog() {
        return this.log;
    }

    protected void decodeCommonOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(TESTURL_OPTION)) {
            this.testURL = args[0];
        } else if (optionName.equalsIgnoreCase(FILENAME_OPTION)) {
            this.sigFileName = args[0];
        } else if (optionName.equalsIgnoreCase(PACKAGE_OPTION)) {
            this.packages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(WITHOUTSUBPACKAGES_OPTION)) {
            this.purePackages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(EXCLUDE_OPTION)) {
            this.excludedPackages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(CLASSPATH_OPTION)) {
            this.classpathStr = args[0];
        } else if (optionName.equalsIgnoreCase(EXCLUDE_JDK_CLASS_OPTION)) {
            JDKExclude.enable();
        } else if (optionName.equalsIgnoreCase(USE_BOOT_CP)) {
            if (args.length == 0) {
                this.release = Release.BOOT_CLASS_PATH;
            } else {
                try {
                    this.release = Release.find(Integer.parseInt(args[0]));
                }
                catch (NumberFormatException ex) {
                    throw new CommandLineParserException(i18n.getString("SigTest.error.arg.invalid2", optionName, args[0]));
                }
            }
        } else if (optionName.equalsIgnoreCase(APIVERSION_OPTION)) {
            this.apiVersion = args[0];
        } else if (optionName.equalsIgnoreCase(STATIC_OPTION)) {
            this.isStatic = true;
        } else if (optionName.equalsIgnoreCase(CLASSCACHESIZE_OPTION)) {
            this.cacheSize = 0;
            try {
                this.cacheSize = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                if (debug) {
                    ex.printStackTrace();
                }
                this.cacheSize = 0;
            }
            if (this.cacheSize <= 0) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.arg.invalid", (Object)optionName));
            }
        } else if (optionName.equalsIgnoreCase(ALLPUBLIC_OPTION)) {
            this.trackMode = 2;
        } else if (optionName.equalsIgnoreCase(DEBUG_OPTION)) {
            debug = true;
        } else if (optionName.equalsIgnoreCase(ERRORALL_OPTION)) {
            this.reportWarningAsError = true;
        } else if (optionName.equalsIgnoreCase(XNOTIGER_OPTION)) {
            isTigerFeaturesTracked = false;
        } else if (optionName.equalsIgnoreCase(XVERBOSE_OPTION)) {
            Xverbose = true;
        } else if (optionName.equalsIgnoreCase(PLUGIN_OPTION)) {
            this.pluginClass = this.loadPlugin(args[0]);
            if (this.pluginClass == null) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.cant_load.plugin", (Object)args[0]));
            }
        } else if (optionName.equalsIgnoreCase(HELP_OPTION) || optionName.equalsIgnoreCase(QUESTIONMARK)) {
            this.usage();
        } else if (optionName.equalsIgnoreCase(VERSION_OPTION)) {
            System.err.println(Version.getVersionInfo());
        }
    }

    public int getNumErrors() {
        return errorManager.getNumErrors();
    }

    public int getNumWarnings() {
        return errorManager.getNumWarnings();
    }

    protected boolean isPackageMember(String name) {
        return !this.excludedPackages.checkName(name) && (this.packages.checkName(name) || this.purePackages.checkName(name));
    }

    @Override
    public void setClassDescrLoader(ClassDescriptionLoader loader) {
        this.loader = loader;
    }

    protected ClassDescriptionLoader getClassDescrLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.isStatic) {
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.BinaryClassDescrLoader", new Class[]{Classpath.class, Integer.class}, new Object[]{this.classpath, new Integer(this.cacheSize)}, this.getLog());
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadstatic"));
            }
        } else {
            if (isTigerFeaturesTracked) {
                this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.TigerRefgClassDescrLoader", new Class[0], new Object[0], this.getLog());
                if (this.loader != null) {
                    return this.loader;
                }
                isTigerFeaturesTracked = false;
            }
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.ReflClassDescrLoader", new Class[0], new Object[0], this.getLog());
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadreflect"));
            }
        }
        return this.loader;
    }

    protected ClassDescription load(String name) {
        try {
            return this.testableHierarchy.load(name);
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                e.printStackTrace();
            }
            this.storeError(i18n.getString("SigTest.error.class.missing", (Object)name), null);
        }
        catch (LinkageError e) {
            if (debug) {
                e.printStackTrace();
            }
            this.storeError(i18n.getString("SigTest.error.class.notlinked", (Object)e.getMessage()), null);
        }
        return null;
    }

    private static ClassDescriptionLoader getLoader(String name, Class[] pars, Object[] args, PrintWriter log) {
        try {
            Constructor<?> ctor = Class.forName(name).getConstructor(pars);
            ClassDescriptionLoader cl = (ClassDescriptionLoader)ctor.newInstance(args);
            try {
                Method setLog = cl.getClass().getDeclaredMethod("setLog", PrintWriter.class);
                setLog.invoke((Object)cl, log);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return cl;
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
    }

    public boolean useErasurator() {
        return !isTigerFeaturesTracked;
    }

    protected abstract void usage();

    protected abstract String getComponentName();

    protected Plugin loadPlugin(String pluginClassName) {
        try {
            Constructor<?> ctor = Class.forName(pluginClassName).getConstructor(new Class[0]);
            return (Plugin)ctor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public Filter getFilter(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getFilter();
    }

    @Override
    public void setFilter(PluginAPI.InjectionPoint injectionPoint, Filter filter) {
        injectionPoint.setFilter(filter);
    }

    @Override
    public Transformer getTransformer(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getTransformer();
    }

    @Override
    public void setTransformer(PluginAPI.InjectionPoint injectionPoint, Transformer transformer) {
        injectionPoint.setTransformer(transformer);
    }

    protected boolean addInherited() {
        return true;
    }

    @Override
    public Context getContext() {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public void addFormat(Format format, boolean useByDefault) {
        this.getFileManager().addFormat(format, useByDefault);
    }

    @Override
    public void setFormat(Format format) {
        this.getFileManager().setFormat(format);
    }

    protected AnnotationItem[] removeUndocumentedAnnotations(AnnotationItem[] annotations, ClassHierarchy h) {
        if (annotations == null) {
            return AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int len = annotations.length;
        AnnotationItem[] tempStorage = new AnnotationItem[len];
        if (len == 0) {
            return annotations;
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            boolean documented = true;
            try {
                documented = h.isDocumentedAnnotation(annotations[i].getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!documented) continue;
            tempStorage[count++] = annotations[i];
        }
        if (count == len) {
            return annotations;
        }
        AnnotationItem[] documentedAnnotations = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        if (count != 0) {
            documentedAnnotations = new AnnotationItem[count];
            System.arraycopy(tempStorage, 0, documentedAnnotations, 0, count);
        }
        return documentedAnnotations;
    }

    protected FileManager getFileManager() {
        return this.fm;
    }

    static {
        isConstantValuesTracked = true;
        debug = false;
        isTigerFeaturesTracked = false;
        try {
            String specVersion = System.getProperty("java.specification.version");
            if ("1.5".compareTo(specVersion) <= 0) {
                isTigerFeaturesTracked = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Xverbose = false;
    }
}

