/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassCorrector;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MethodOverridingChecker;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemberCollectionBuilder {
    private ClassCorrector cc;
    private Erasurator erasurator = new Erasurator();
    private Transformer defaultTransformer = new DefaultAfterBuildMembersTransformer();
    private Log log;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(MemberCollectionBuilder.class);
    private BuildMode mode = BuildMode.NORMAL;
    private ClassHierarchy secondCH;
    static Logger logger = Logger.getLogger(MemberCollectionBuilder.class.getName());

    public MemberCollectionBuilder(Log log) {
        this.cc = new ClassCorrector(log);
        this.log = log;
        if (logger.getLevel() == null) {
            logger.setLevel(Level.OFF);
        }
    }

    public void createMembers(ClassDescription cl, boolean addInherited, boolean fixClass, boolean checkHidding) throws ClassNotFoundException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("**** createMembers for " + cl.getName() + "\n** addInherited=" + addInherited + "\n** fixClass=" + fixClass + "\n** checkHidding=" + checkHidding + "\n** BuildMode=" + this.mode);
        }
        MemberCollection members = this.getMembers(cl, addInherited, checkHidding);
        SuperClass spr = cl.getSuperClass();
        if (spr != null) {
            members.addMember(spr);
        }
        ConstructorDescr[] constr = cl.getDeclaredConstructors();
        for (int i = 0; i < constr.length; ++i) {
            members.addMember(constr[i]);
        }
        cl.setMembers(members);
        Transformer t = PluginAPI.AFTER_BUILD_MEMBERS.getTransformer();
        if (t == null) {
            t = this.defaultTransformer;
        }
        t.transform(cl);
        if (fixClass) {
            t = PluginAPI.CLASS_CORRECTOR.getTransformer();
            if (t == null) {
                t = this.cc;
            }
            t.transform(cl);
        }
        if (this.mode == BuildMode.TESTABLE) {
            MemberCollection cleaned = new MemberCollection();
            int memcount = 0;
            Iterator e = cl.getMembersIterator();
            while (e.hasNext()) {
                ++memcount;
                MemberDescription mr = (MemberDescription)e.next();
                MemberType mt = mr.getMemberType();
                if (mt != MemberType.SUPERCLASS) {
                    String dcn;
                    String cn;
                    if (!this.isAccessible(mr.getDeclaringClassName())) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("BuildMode.TESTABLE - removing " + mr);
                        continue;
                    }
                    if (!mr.getDeclaringClassName().equals(cl.getQualifiedName()) && !this.isAncestor(cn = cl.getQualifiedName(), dcn = mr.getDeclaringClassName())) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("BuildMode.TESTABLE - removing " + mr);
                        continue;
                    }
                }
                cleaned.addMember(mr);
            }
            if (cleaned.getAllMembers().size() != memcount) {
                cl.setMembers(cleaned);
            }
        }
        if ((t = PluginAPI.AFTER_CLASS_CORRECTOR.getTransformer()) != null) {
            t.transform(cl);
        }
    }

    private boolean isAncestor(String clName, String superClName) {
        try {
            int i;
            ClassDescription c = this.secondCH.load(clName);
            SuperClass superCl = c.getSuperClass();
            if (superCl != null && superClName.equals(superCl.getQualifiedName())) {
                return true;
            }
            SuperInterface[] sis = c.getInterfaces();
            for (i = 0; i < sis.length; ++i) {
                if (!superClName.equals(sis[i].getQualifiedName())) continue;
                return true;
            }
            if (superCl != null && this.isAncestor(superCl.getQualifiedName(), superClName)) {
                return true;
            }
            for (i = 0; i < sis.length; ++i) {
                if (!this.isAncestor(sis[i].getQualifiedName(), superClName)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    private MemberCollection getMembers(ClassDescription cl, boolean addInherited, boolean checkHidding) throws ClassNotFoundException {
        return this.getMembers(cl, null, true, false, addInherited, checkHidding);
    }

    private MemberCollection getMembers(ClassDescription cl, String actualTypeParams, boolean skipRawTypes, boolean callErasurator, boolean addInherited, boolean checkHidding) throws ClassNotFoundException {
        assert (cl != null);
        logger.finer("Getting members for " + cl.getQualifiedName());
        this.erasurator.parseTypeParameters(cl);
        ArrayList paramList = null;
        MemberCollection retVal = new MemberCollection();
        MemberDescription[] methods = cl.getDeclaredMethods();
        MemberDescription[] fields = cl.getDeclaredFields();
        MemberDescription[] classes = cl.getDeclaredClasses();
        MemberDescription[] intrfs = cl.getInterfaces();
        String clsName = cl.getQualifiedName();
        ClassHierarchy hierarchy = cl.getClassHierarchy();
        if (actualTypeParams != null) {
            paramList = Erasurator.splitParameters(actualTypeParams);
            methods = Erasurator.replaceFormalParameters(clsName, methods, (List)paramList, skipRawTypes);
            fields = Erasurator.replaceFormalParameters(clsName, fields, (List)paramList, skipRawTypes);
            classes = Erasurator.replaceFormalParameters(clsName, classes, (List)paramList, skipRawTypes);
        } else if (callErasurator && cl.getTypeParameters() != null) {
            ArrayList boundsList = cl.getTypeBounds();
            methods = Erasurator.replaceFormalParameters(clsName, methods, (List)boundsList, false);
            fields = Erasurator.replaceFormalParameters(clsName, fields, (List)boundsList, false);
            classes = Erasurator.replaceFormalParameters(clsName, classes, (List)boundsList, false);
        }
        if (paramList != null) {
            intrfs = Erasurator.replaceFormalParameters(clsName, intrfs, (List)paramList, skipRawTypes);
        }
        MethodOverridingChecker overridingChecker = new MethodOverridingChecker(this.erasurator);
        overridingChecker.addMethods(methods);
        retVal = this.addSuperMembers(methods, retVal);
        retVal = this.addSuperMembers(fields, retVal);
        retVal = this.addSuperMembers(classes, retVal);
        logger.finer(" direct interfaces");
        for (int i = 0; i < intrfs.length; ++i) {
            SuperInterface s = (SuperInterface)intrfs[i];
            s.setDirect(true);
            s.setDeclaringClass(cl.getQualifiedName());
        }
        retVal = this.addSuperMembers(intrfs, retVal);
        if (addInherited) {
            this.addInherited(checkHidding, cl, hierarchy, paramList, skipRawTypes, overridingChecker, retVal);
        } else {
            this.fixAnnotations(cl, hierarchy);
        }
        return retVal;
    }

    private void addInherited(boolean checkHidding, ClassDescription cl, ClassHierarchy hierarchy, List paramList, boolean skipRawTypes, MethodOverridingChecker overridingChecker, MemberCollection retVal) throws ClassNotFoundException {
        HashMap<String, MemberDescription> inheritedFields;
        Set internalClasses;
        block11: {
            String clsName = cl.getQualifiedName();
            logger.finer(" adding inherited members - superclasses");
            internalClasses = Collections.EMPTY_SET;
            if (checkHidding) {
                internalClasses = cl.getInternalClasses();
            }
            inheritedFields = new HashMap<String, MemberDescription>();
            SuperClass superClassDescr = cl.getSuperClass();
            if (superClassDescr != null) {
                try {
                    ClassDescription superClass = hierarchy.load(superClassDescr.getQualifiedName());
                    MemberCollection superMembers = this.getMembers(superClass, superClassDescr.getTypeParameters(), false, true, true, checkHidding);
                    this.findInheritableAnnotations(cl, superClass);
                    superMembers = this.getAccessibleMembers(superMembers, cl, superClass);
                    Collection coll = superMembers.getAllMembers();
                    if (paramList != null) {
                        coll = Erasurator.replaceFormalParameters(clsName, coll, paramList, skipRawTypes);
                    }
                    for (MemberDescription supMD : coll) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" ? " + supMD);
                        }
                        if (supMD.isMethod()) {
                            if (!this.addInheritedMethod(supMD, overridingChecker, retVal, hierarchy, superClass, cl)) continue;
                            continue;
                        }
                        if (supMD.isField()) {
                            supMD.unmark();
                            inheritedFields.put(supMD.getName(), supMD);
                            if (!logger.isLoggable(Level.FINER)) continue;
                            logger.finer(" store inherited field for further processing " + supMD);
                            continue;
                        }
                        if (supMD.isSuperInterface()) {
                            SuperInterface si = (SuperInterface)supMD.clone();
                            si.setDirect(false);
                            retVal.addMember(si);
                            if (!logger.isLoggable(Level.FINER)) continue;
                            logger.finer(" added inherited superinterface " + si);
                            continue;
                        }
                        if (supMD.isInner()) {
                            if (internalClasses.contains(supMD.getName())) continue;
                            retVal.addMember(supMD);
                            if (!logger.isLoggable(Level.FINER)) continue;
                            logger.finer(" added inherited inner class " + supMD);
                            continue;
                        }
                        retVal.addMember(supMD);
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.finer(" added inherited member " + supMD);
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (this.mode == BuildMode.SIGFILE || this.mode == BuildMode.APICOV_REAL) break block11;
                    logger.log(Level.FINER, "Class not found", ex);
                    throw ex;
                }
            }
        }
        this.addInheritedFromInterfaces(cl, hierarchy, checkHidding, paramList, skipRawTypes, overridingChecker, retVal, inheritedFields, internalClasses);
    }

    private void addInheritedFromInterfaces(ClassDescription cl, ClassHierarchy hierarchy, boolean checkHidding, List paramList, boolean skipRawTypes, MethodOverridingChecker overridingChecker, MemberCollection retVal, Map inheritedFields, Set internalClasses) throws ClassNotFoundException {
        String clsName = cl.getQualifiedName();
        logger.finer(" adding inherited members - superinterfaces");
        SuperInterface[] interfaces = cl.getInterfaces();
        HashSet<String> xfCan = new HashSet<String>();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                ClassDescription intf = hierarchy.load(interfaces[i].getQualifiedName());
                MemberCollection h = this.getMembers(intf, interfaces[i].getTypeParameters(), false, true, true, checkHidding);
                Collection coll = h.getAllMembers();
                if (paramList != null) {
                    coll = Erasurator.replaceFormalParameters(clsName, coll, paramList, skipRawTypes);
                }
                for (MemberDescription memb : coll) {
                    if (memb.isMethod()) {
                        MethodDescr m = (MethodDescr)memb;
                        MethodDescr overriden = overridingChecker.getOverridingMethod(m, true);
                        MemberDescription erased = this.erasurator.processMember(memb);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" ? consider interface method " + m);
                        }
                        if (overriden != null && this.mode == BuildMode.TESTABLE && !this.isAccessible(overriden.getDeclaringClassName())) {
                            boolean doFix = false;
                            int mods = 0;
                            try {
                                mods = hierarchy.getClassModifiers(overriden.getDeclaringClassName());
                            }
                            catch (ClassNotFoundException ex) {
                                doFix = true;
                            }
                            if (doFix && Modifier.hasModifier(mods, Modifier.PUBLIC) || Modifier.hasModifier(mods, Modifier.PROTECTED)) {
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.finer(" ? change interface method from " + overriden + " to " + memb);
                                }
                                retVal.changeMember(overriden, memb);
                                overriden = null;
                            }
                        }
                        if (overriden == null) {
                            retVal.addMember(m);
                            if (!logger.isLoggable(Level.FINER)) continue;
                            logger.finer(" added " + m);
                            continue;
                        }
                        if (!PrimitiveTypes.isPrimitive(m.getType()) && !m.getType().endsWith("]")) {
                            try {
                                String newReturnType;
                                String existReturnType = overriden.getType();
                                if (existReturnType.equals(newReturnType = erased.getType()) || !cl.getClassHierarchy().getSuperClasses(newReturnType).contains(existReturnType) && !cl.getClassHierarchy().getAllImplementedInterfaces(newReturnType).contains(existReturnType)) continue;
                                retVal.updateMember(memb);
                                if (!logger.isLoggable(Level.FINER)) continue;
                                logger.finer(" updated " + memb);
                            }
                            catch (ClassNotFoundException e) {
                                logger.log(Level.FINER, " returntype not found " + m.getType(), e);
                                this.log.storeWarning(i18n.getString("MemberCollectionBuilder.warn.returntype.notresolved", (Object)m.getType()), null);
                            }
                            continue;
                        }
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.finer(" didn't added because of overriding " + m + " conflicts with " + overriden);
                        continue;
                    }
                    if (memb.isField()) {
                        MemberDescription storedFid;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" ? consider interface field " + memb);
                        }
                        if ((storedFid = (MemberDescription)inheritedFields.get(memb.getName())) != null) {
                            if (storedFid.getQualifiedName().equals(memb.getQualifiedName())) continue;
                            storedFid.mark();
                            if (hierarchy.isClassVisibleOutside(memb.getDeclaringClassName())) continue;
                            xfCan.add(memb.getName());
                            continue;
                        }
                        memb.unmark();
                        inheritedFields.put(memb.getName(), memb);
                        continue;
                    }
                    if (memb.isSuperInterface()) {
                        SuperInterface si = (SuperInterface)memb.clone();
                        si.setDirect(false);
                        retVal.addMember(si);
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.finer(" added superinterface " + si);
                        continue;
                    }
                    if (memb.isInner()) {
                        if (!internalClasses.contains(memb.getName()) && retVal.findSimilar(memb) == null) {
                            if (!logger.isLoggable(Level.FINER)) continue;
                            logger.finer(" added inner class " + memb);
                            continue;
                        }
                        if (hierarchy.isClassVisibleOutside(memb.getDeclaringClassName())) continue;
                        cl.addXClasses(memb.getName());
                        continue;
                    }
                    retVal.addMember(memb);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.finer(" added " + memb);
                }
                continue;
            }
            catch (ClassNotFoundException ex) {
                if (this.mode == BuildMode.SIGFILE || this.mode == BuildMode.APICOV_REAL) continue;
                logger.log(Level.FINER, " not found class", ex);
                throw ex;
            }
        }
        Set internalFields = Collections.EMPTY_SET;
        Set xFields = Collections.EMPTY_SET;
        if (checkHidding) {
            internalFields = cl.getInternalFields();
            xFields = cl.getXFields();
        }
        for (MemberDescription field : inheritedFields.values()) {
            String fiName = field.getName();
            if (!(field.isMarked() || internalFields.contains(fiName) || xFields.contains(fiName))) {
                retVal.addMember(field);
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer(" added interface field " + field);
                continue;
            }
            if (!xfCan.contains(field.getName())) continue;
            System.err.println("Phantom field found " + field.getQualifiedName());
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("added x-hider for " + cl.getQualifiedName() + " is " + fiName);
            }
            cl.addXFields(fiName);
        }
        if (!cl.getXClasses().isEmpty()) {
            for (String xClass : cl.getXClasses()) {
                Iterator rvi = retVal.iterator();
                while (rvi.hasNext()) {
                    MemberDescription rm = (MemberDescription)rvi.next();
                    if (!rm.isInner() || !rm.getName().equals(xClass)) continue;
                    System.err.println("Phantom class found " + rm.getQualifiedName());
                    rvi.remove();
                }
            }
        }
    }

    private boolean addInheritedMethod(MemberDescription supMD, MethodOverridingChecker overridingChecker, MemberCollection retVal, ClassHierarchy hierarchy, ClassDescription superClass, ClassDescription cl) {
        block10: {
            MethodDescr m = (MethodDescr)supMD;
            MethodDescr overriden = overridingChecker.getOverridingMethod(m, true);
            MemberDescription erased = this.erasurator.processMember(supMD);
            if (overriden == null) {
                retVal.addMember(m);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" added inherited method " + m);
                }
            } else {
                if (!PrimitiveTypes.isPrimitive(m.getType()) && !m.getType().endsWith("]")) {
                    try {
                        String newReturnType;
                        if (!hierarchy.isAccessible(superClass)) {
                            return true;
                        }
                        String existReturnType = overriden.getType();
                        if (existReturnType.equals(newReturnType = erased.getType()) || !cl.getClassHierarchy().getSuperClasses(newReturnType).contains(existReturnType) && !cl.getClassHierarchy().getAllImplementedInterfaces(newReturnType).contains(existReturnType)) break block10;
                        retVal.updateMember(supMD);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" added inherited method " + supMD);
                        }
                        break block10;
                    }
                    catch (ClassNotFoundException e) {
                        if (this.mode != BuildMode.SIGFILE && this.mode != BuildMode.APICOV_REAL) {
                            this.log.storeWarning(i18n.getString("MemberCollectionBuilder.warn.returntype.notresolved", (Object)m.getType()), null);
                            logger.log(Level.FINER, " " + i18n.getString("MemberCollectionBuilder.warn.returntype.notresolved", (Object)m.getType()), e);
                        }
                        break block10;
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" didn't added because of overriding " + m + " conflicts with " + overriden);
                }
            }
        }
        return false;
    }

    private void fixAnnotations(ClassDescription cl, ClassHierarchy hierarchy) throws ClassNotFoundException {
        block3: {
            SuperClass superClassDescr = cl.getSuperClass();
            if (superClassDescr != null) {
                try {
                    ClassDescription superClass = hierarchy.load(superClassDescr.getQualifiedName());
                    this.findInheritableAnnotations(cl, superClass);
                }
                catch (ClassNotFoundException ex) {
                    if (this.mode == BuildMode.SIGFILE || this.mode == BuildMode.APICOV_REAL) break block3;
                    logger.log(Level.FINER, " not found class", ex);
                    throw ex;
                }
            }
        }
    }

    private MemberCollection addSuperMembers(MemberDescription[] from, MemberCollection to) {
        logger.finer(" adding members");
        for (int i = 0; i < from.length; ++i) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  +" + from[i]);
            }
            to.addMember(from[i]);
        }
        return to;
    }

    private boolean isAccessible(String qualifiedName) {
        try {
            this.secondCH.load(qualifiedName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private MemberCollection getAccessibleMembers(MemberCollection members, ClassDescription subclass, ClassDescription superClass) {
        String pkg = subclass.getPackageName();
        boolean isSamePackage = pkg.equals(superClass.getPackageName());
        MemberCollection retVal = new MemberCollection();
        Iterator e = members.iterator();
        while (e.hasNext()) {
            MemberDescription mbr = (MemberDescription)e.next();
            if (!mbr.isPublic() && !mbr.isProtected() && !isSamePackage && !mbr.isSuperInterface() || mbr.isPrivate()) continue;
            retVal.addMember(mbr);
        }
        return retVal;
    }

    private void findInheritableAnnotations(ClassDescription subclass, ClassDescription superClass) {
        AnnotationItem[] superClassAnnoList = superClass.getAnnoList();
        if (superClassAnnoList.length != 0) {
            int i;
            TreeSet<AnnotationItem> tmp = new TreeSet<AnnotationItem>();
            AnnotationItem[] subClassAnnoList = subclass.getAnnoList();
            for (i = 0; i < superClassAnnoList.length; ++i) {
                if (!superClassAnnoList[i].isInheritable()) continue;
                tmp.add(superClassAnnoList[i]);
            }
            for (i = 0; i < subClassAnnoList.length; ++i) {
                tmp.add(subClassAnnoList[i]);
            }
            if (tmp.size() != subClassAnnoList.length) {
                AnnotationItem[] newAnnoList = new AnnotationItem[tmp.size()];
                tmp.toArray(newAnnoList);
                subclass.setAnnoList(newAnnoList);
            }
        }
    }

    public void setBuildMode(BuildMode bm) {
        this.mode = bm;
    }

    public void setSecondClassHierarchy(ClassHierarchy signatureClassesHierarchy) {
        this.secondCH = signatureClassesHierarchy;
    }

    class DefaultAfterBuildMembersTransformer
    implements Transformer {
        DefaultAfterBuildMembersTransformer() {
        }

        @Override
        public ClassDescription transform(ClassDescription cls) {
            Iterator it = cls.getMembersIterator();
            while (it.hasNext()) {
                MemberDescription mr = (MemberDescription)it.next();
                boolean isBridgeMethod = mr.hasModifier(Modifier.BRIDGE);
                boolean isSynthetic = mr.hasModifier(Modifier.ACC_SYNTHETIC);
                if (isSynthetic) {
                    if (logger.isLoggable(Level.INFO)) {
                        if (mr.isConstructor()) {
                            logger.info(i18n.getString("MemberCollectionBuilder.message.synthetic_constr_skipped", (Object)(mr.getQualifiedName() + "(" + mr.getArgs() + ")")));
                        } else if (mr.isMethod()) {
                            String signature = mr.getType() + " " + mr.getQualifiedName() + "(" + mr.getArgs() + ")";
                            if (isBridgeMethod) {
                                logger.info(i18n.getString("MemberCollectionBuilder.message.bridge", (Object)signature));
                            } else {
                                logger.info(i18n.getString("MemberCollectionBuilder.message.synthetic_method_skipped", (Object)signature));
                            }
                        }
                    }
                    it.remove();
                    continue;
                }
                if (mr.isPublic() || mr.isProtected() || mr.isSuperInterface() || mr.isSuperClass()) continue;
                it.remove();
            }
            return cls;
        }
    }

    public static class BuildMode {
        public static final BuildMode NORMAL = new BuildMode("NORMAL");
        public static final BuildMode SIGFILE = new BuildMode("SIGFILE");
        public static final BuildMode TESTABLE = new BuildMode("TESTABLE");
        public static final BuildMode APICOV_REAL = new BuildMode("APICOV_REAL");
        private String name;

        private BuildMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

