/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.JDKExclude;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ThrowsNormalizer {
    private List xthrows = new ArrayList();
    private StringBuffer sb = new StringBuffer();

    public void normThrows(ClassDescription c, boolean removeJLE, boolean onlyRemoveJavaSEThrows) throws ClassNotFoundException {
        ClassHierarchy h = c.getClassHierarchy();
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isMethod() && !mr.isConstructor()) continue;
            this.normThrows(h, mr, removeJLE, onlyRemoveJavaSEThrows);
        }
    }

    private boolean checkException(ClassHierarchy h, String candidate, String matchedException) throws ClassNotFoundException {
        return candidate.equals(matchedException) || h.isSubclass(candidate, matchedException);
    }

    private void normThrows(ClassHierarchy h, MemberDescription mr, boolean removeJLE, boolean onlyRemoveJavaSEThrows) throws ClassNotFoundException {
        assert (mr.isMethod() || mr.isConstructor());
        String throwables = mr.getThrowables();
        if (throwables.length() != 0) {
            int pos;
            this.xthrows.clear();
            int startPos = 0;
            do {
                if ((pos = throwables.indexOf(",", startPos)) != -1) {
                    this.xthrows.add(throwables.substring(startPos, pos));
                    startPos = pos + 1;
                    continue;
                }
                this.xthrows.add(throwables.substring(startPos));
            } while (pos != -1);
            int superfluousExceptionCount = 0;
            block1: for (int i = 0; i < this.xthrows.size(); ++i) {
                String s = (String)this.xthrows.get(i);
                if (s == null) continue;
                if (JDKExclude.isJdkClass(s)) {
                    this.xthrows.set(i, null);
                    ++superfluousExceptionCount;
                    continue;
                }
                if (onlyRemoveJavaSEThrows || s.charAt(0) == '{') continue;
                if (this.checkException(h, s, "java.lang.RuntimeException") || removeJLE && this.checkException(h, s, "java.lang.Error")) {
                    this.xthrows.set(i, null);
                    ++superfluousExceptionCount;
                    continue;
                }
                for (int k = i + 1; k < this.xthrows.size(); ++k) {
                    String anotherThrowable = (String)this.xthrows.get(k);
                    if (anotherThrowable == null) continue;
                    if (this.checkException(h, s, anotherThrowable)) {
                        this.xthrows.set(i, null);
                        ++superfluousExceptionCount;
                        continue block1;
                    }
                    if (!this.checkException(h, anotherThrowable, s)) continue;
                    this.xthrows.set(k, null);
                    ++superfluousExceptionCount;
                }
            }
            if (superfluousExceptionCount != 0) {
                int count = 0;
                this.sb.setLength(0);
                for (int i = 0; i < this.xthrows.size(); ++i) {
                    String s = (String)this.xthrows.get(i);
                    if (s == null) continue;
                    if (count++ != 0) {
                        this.sb.append(",");
                    }
                    this.sb.append(s);
                }
                if (count == 0) {
                    mr.setThrowables("");
                } else {
                    mr.setThrowables(this.sb.toString());
                }
            }
        }
    }
}

