/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import com.sun.tdk.signaturetest.Setup;
import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.SignatureTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class SigtestHandler {
    static String[] ACTIONS = new String[]{"generate", "check", "strictcheck", "versioncheck", "binarycheck"};

    SigtestHandler() {
    }

    public final int execute() throws IOException {
        boolean fail;
        int returnCode;
        SigTest t;
        if (this.getPackages().equals("-")) {
            this.logInfo("No public packages, skipping");
            return 0;
        }
        boolean generate = false;
        boolean addBootCP = false;
        boolean onlySameVersion = false;
        ArrayList<Object> arg = new ArrayList<Object>();
        arg.add("-FileName");
        arg.add(this.getFileName().getAbsolutePath());
        if (this.getAction().equals("generate")) {
            generate = true;
            addBootCP = true;
            arg.add("-static");
            arg.add("-ErrorAll");
            arg.add("-KeepFile");
        } else if (this.getAction().equals("check") || this.getAction().equals("binarycheck")) {
            arg.add("-static");
            arg.add("-b");
            arg.add("-Mode");
            arg.add("bin");
            addBootCP = true;
            if (this.getAction().equals("binarycheck")) {
                arg.add("-extensibleinterfaces");
            }
        } else if (this.getAction().equals("strictcheck")) {
            addBootCP = true;
            arg.add("-static");
        } else if (this.getAction().equals("versioncheck")) {
            addBootCP = true;
            arg.add("-static");
            onlySameVersion = true;
        } else {
            throw new IOException("Unknown action: " + this.getAction() + " available actions are " + Arrays.toString(ACTIONS));
        }
        if (this.getVersion() != null) {
            arg.add("-ApiVersion");
            arg.add(this.getVersion());
        }
        if (this.isJDKExcludeEnabled()) {
            arg.add("-IgnoreJDKClass");
        }
        this.logInfo("Packages: " + this.getPackages());
        StringTokenizer packagesTokenizer = new StringTokenizer(this.getPackages(), ",:;");
        while (packagesTokenizer.hasMoreTokens()) {
            String p = packagesTokenizer.nextToken().trim();
            String prefix = "-PackageWithoutSubpackages ";
            int idx = p.lastIndexOf(".**");
            if (idx > 0) {
                p = p.substring(0, idx);
                prefix = "-Package ";
            } else {
                idx = p.lastIndexOf(".*");
                if (idx > 0) {
                    p = p.substring(0, idx);
                }
            }
            arg.add(prefix.trim());
            arg.add(p);
        }
        if (this.getClasspath() != null) {
            StringBuffer sb = new StringBuffer();
            String pref = "";
            for (String e : this.getClasspath()) {
                sb.append(pref);
                sb.append(e);
                pref = File.pathSeparator;
            }
            if (addBootCP) {
                Integer release = this.getRelease();
                arg.add("-BootCP");
                if (release != null) {
                    arg.add("" + release);
                }
            }
            arg.add("-Classpath");
            arg.add(sb.toString());
        }
        String[] args = arg.toArray(new String[0]);
        StringWriter output = new StringWriter();
        PrintWriter w = new PrintWriter((Writer)output, true);
        if (generate) {
            t = new Setup();
            ((Setup)t).run(args, w, null);
            returnCode = t.isPassed() ? 0 : 1;
        } else {
            t = new SignatureTest();
            ((SignatureTest)t).run(args, w, null);
            int n = returnCode = t.isPassed() ? 0 : 1;
            if (onlySameVersion && !t.isPassed()) {
                String prefix = "Base version: ";
                int index = output.toString().indexOf("Base version: ");
                if (index < 0) {
                    throw new IOException("Missing Base version:  in:\n" + output.toString());
                }
                int end = output.toString().indexOf(10, index);
                String base = output.toString().substring(index + "Base version: ".length(), end);
                this.logInfo("versioncheck.TestedVersion: " + this.getVersion());
                this.logInfo("versioncheck.BaseVersion: " + base);
                if (!this.getVersion().equals(base)) {
                    this.logInfo("versioncheck. clearing the return status.");
                    returnCode = 0;
                }
            }
        }
        Object out = this.getMail() != null ? "\nemail: " + this.getMail() + "\n" + output : output.toString();
        if (returnCode == 0) {
            this.logInfo((String)out);
        } else {
            this.logError((String)out);
        }
        if (this.getReport() != null) {
            this.writeReport(this.getReport(), (String)out, returnCode == 0);
            fail = Boolean.TRUE.equals(this.isFailOnError());
        } else {
            fail = !Boolean.FALSE.equals(this.isFailOnError());
        }
        return fail ? returnCode : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeReport(File reportFile, String msg, boolean success) throws IOException {
        assert (reportFile != null);
        try {
            String apiName = this.getFileName().getName().replace(".sig", "").replace("-", ".");
            StringBuilder name = new StringBuilder();
            name.append(apiName).append('.').append(this.getAction());
            if (this.getVersion() != null) {
                name.append("_Version_").append(this.getVersion().replace('.', '_'));
            }
            Document reportDoc = SigtestHandler.createDocument("testsuite");
            Element testsuite = reportDoc.getDocumentElement();
            int failures = 0;
            testsuite.setAttribute("errors", "0");
            testsuite.setAttribute("time", "0.0");
            testsuite.setAttribute("name", name.toString());
            Element testcase = reportDoc.createElement("testcase");
            testsuite.appendChild(testcase);
            testcase.setAttribute("classname", name.toString());
            testcase.setAttribute("name", this.getAction());
            testcase.setAttribute("time", "0.0");
            if (!success) {
                ++failures;
                Element failure = reportDoc.createElement("failure");
                testcase.appendChild(failure);
                failure.setAttribute("type", "junit.framework.AssertionFailedError");
                failure.setAttribute("message", "Failed " + this.getAction() + " for " + apiName + " in version " + this.getVersion());
            }
            testsuite.setAttribute("failures", Integer.toString(failures));
            testsuite.setAttribute("tests", Integer.toString(1));
            Element systemerr = reportDoc.createElement("system-err");
            systemerr.appendChild(reportDoc.createCDATASection(msg));
            testsuite.appendChild(systemerr);
            reportFile.getParentFile().mkdirs();
            try (FileOutputStream os = new FileOutputStream(reportFile);){
                DOMSource dom = new DOMSource(reportDoc);
                StreamResult res = new StreamResult(os);
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.transform(dom, res);
            }
            this.logInfo(reportFile + ": " + failures + " failures in " + this.getFileName());
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
        catch (IOException x) {
            throw new IOException("Could not write " + reportFile + ": " + x, x);
        }
    }

    private static Document createDocument(String rootQName) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation().createDocument(null, rootQName, null);
        }
        catch (ParserConfigurationException ex) {
            throw (IOException)new IOException("Cannot create parser").initCause(ex);
        }
    }

    protected abstract Integer getRelease();

    protected abstract String getPackages();

    protected abstract File getFileName();

    protected abstract String getAction();

    protected abstract String getVersion();

    protected abstract String[] getClasspath();

    protected abstract File getReport();

    protected abstract String getMail();

    protected abstract Boolean isFailOnError();

    protected abstract boolean isJDKExcludeEnabled();

    protected abstract void logInfo(String var1);

    protected abstract void logError(String var1);
}

