/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.apicover.RefCounter;
import com.sun.tdk.apicover.ReportGenerator;
import com.sun.tdk.apicover.markup.Adapter;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.classpath.Release;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.loaders.BinaryClassDescrLoader;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.util.BatchFileParser;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Main
implements Log {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    public static final String API_OPTION = "-api";
    public static final String TS_OPTION = "-ts";
    public static final String MODE_OPTION = "-mode";
    public static final String MODE_VALUE_WORST = "w";
    public static final String MODE_VALUE_REAL = "r";
    public static final String DETAIL_OPTION = "-detail";
    public static final String FORMAT_OPTION = "-format";
    public static final String FORMAT_VALUE_XML = "xml";
    public static final String FORMAT_VALUE_PLAIN = "plain";
    public static final String REPORT_OPTION = "-report";
    public static final String TSICNLUDE_OPTION = "-tsInclude";
    public static final String TSICNLUDEW_OPTION = "-tsIncludeW";
    public static final String TSEXCLUDE_OPTION = "-tsExclude";
    public static final String APIINCLUDE_OPTION = "-apiInclude";
    public static final String APIINCLUDEW_OPTION = "-apiIncludeW";
    public static final String APIEXCLUDE_OPTION = "-apiExclude";
    public static final String EXCLUDELIST_OPTION = "-excludeList";
    public static final String EXCLUDEINTERFACES_OPTION = "-excludeInterfaces";
    public static final String EXCLUDEABSTRACTCLASSES_OPTION = "-excludeAbstractClasses";
    public static final String EXCLUDEABSTRACTMETHODS_OPTION = "-excludeAbstractMethods";
    public static final String EXCLUDEFIELD_OPTION = "-excludeFields";
    public static final String INCLUDECONSTANTFIELDS_OPTION = "-includeConstantFields";
    public static final String DEBUG_OPTION = "-debug";
    public static final String VERSION_OPTION = "-version";
    public static final String HELP_OPTION = "-help";
    public static final String QUESTIONMARK = "-?";
    public static final String OUT_OPTION = "-out";
    public static final String VALIDATE_OPTION = "-validate";
    static final String MAIN_URI = "file:";
    private PrintWriter log;
    protected static boolean debug = false;
    public static final int DefaultCacheSize = 4096;
    private boolean isWorstCaseMode = true;
    protected ClasspathImpl classpath;
    protected String signatureFile;
    RefCounter refCounter = new RefCounter();
    ReportGenerator reporter;
    String ts;
    private PackageGroup packagesTS = new PackageGroup(true);
    private PackageGroup excludedPackagesTS = new PackageGroup(true);
    private PackageGroup purePackagesTS = new PackageGroup(false);
    private PackageGroup packages = new PackageGroup(true);
    private PackageGroup purePackages = new PackageGroup(false);
    private PackageGroup excludedPackages = new PackageGroup(true);

    public static void main(String[] args) {
        Main main = new Main();
        main.run(args, new PrintWriter(System.err, true), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args, PrintWriter log, PrintWriter ref) {
        this.log = log;
        this.reporter = ReportGenerator.createReportGenerator(this.refCounter, log);
        try {
            this.parseParameters(args);
            this.check();
        }
        catch (Exception e) {
            this.debug(e);
            this.error(e.getMessage());
        }
        finally {
            if (this.classpath != null) {
                this.classpath.close();
            }
        }
    }

    protected void parseParameters(String[] args) throws Exception {
        try {
            args = BatchFileParser.processParameters(args);
        }
        catch (CommandLineParserException ex) {
            ex.printStackTrace();
        }
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args != null && args.length == 1 && parser.isOptionSpecified(args[0], VERSION_OPTION)) {
            System.err.println(Version.getVersionInfo());
            this.passed();
        } else if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], HELP_OPTION) || parser.isOptionSpecified(args[0], QUESTIONMARK))) {
            Main.version();
            this.usage();
            this.passed();
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption(API_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(TS_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(TSICNLUDE_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(TSICNLUDEW_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(TSEXCLUDE_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(APIINCLUDE_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(APIINCLUDEW_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(APIEXCLUDE_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(REPORT_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(MODE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(DETAIL_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(FORMAT_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(EXCLUDEINTERFACES_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(EXCLUDEABSTRACTCLASSES_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(EXCLUDEABSTRACTMETHODS_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(EXCLUDEFIELD_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(INCLUDECONSTANTFIELDS_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(EXCLUDELIST_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(DEBUG_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(VERSION_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(HELP_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(QUESTIONMARK, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(OUT_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(VALIDATE_OPTION, OptionInfo.option(1), "decodeOptions");
        try {
            this.reporter.addConfig(MODE_OPTION, MODE_VALUE_WORST);
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            this.error(e.getMessage());
        }
        if (parser.isOptionSpecified(INCLUDECONSTANTFIELDS_OPTION) && parser.isOptionSpecified(EXCLUDEFIELD_OPTION)) {
            this.error(i18n.getString("Main.error.arg.conflict", EXCLUDEFIELD_OPTION, INCLUDECONSTANTFIELDS_OPTION));
        }
        if (this.packages.isEmpty() && this.purePackages.isEmpty()) {
            this.packages.addPackage("");
        }
        if (this.packagesTS.isEmpty() && this.purePackagesTS.isEmpty()) {
            this.packagesTS.addPackage("");
        }
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(API_OPTION)) {
            this.signatureFile = args[0];
            this.reporter.addConfig(API_OPTION, args[0]);
        } else if (optionName.equalsIgnoreCase(TS_OPTION)) {
            try {
                this.classpath = new ClasspathImpl(Release.BOOT_CLASS_PATH, args[0]);
            }
            catch (SecurityException e) {
                this.debug(e);
                this.log.println(i18n.getString("Main.error.sec.newclasses"));
            }
            this.reporter.addConfig(TS_OPTION, args[0]);
            this.ts = args[0];
        } else if (optionName.equalsIgnoreCase(MODE_OPTION)) {
            if (!MODE_VALUE_WORST.equalsIgnoreCase(args[0]) && !MODE_VALUE_REAL.equalsIgnoreCase(args[0])) {
                this.error(i18n.getString("Main.error.arg.invalid", (Object)MODE_OPTION));
            }
            this.isWorstCaseMode = MODE_VALUE_WORST.equalsIgnoreCase(args[0]);
            this.refCounter.setMode(args[0]);
            this.reporter.addConfig(MODE_OPTION, args[0].toLowerCase());
        } else if (optionName.equalsIgnoreCase(APIINCLUDE_OPTION)) {
            this.packages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(APIEXCLUDE_OPTION)) {
            this.excludedPackages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(APIINCLUDEW_OPTION)) {
            this.purePackages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(TSICNLUDE_OPTION)) {
            this.packagesTS.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(TSEXCLUDE_OPTION)) {
            this.excludedPackagesTS.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(TSICNLUDEW_OPTION)) {
            this.purePackagesTS.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(FORMAT_OPTION)) {
            if (!FORMAT_VALUE_PLAIN.equalsIgnoreCase(args[0]) && !FORMAT_VALUE_XML.equalsIgnoreCase(args[0])) {
                this.error(i18n.getString("Main.error.arg.invalid", (Object)FORMAT_OPTION));
            }
            this.reporter = this.reporter.createReportGenerator(args[0], this.log);
        } else if (optionName.equalsIgnoreCase(DETAIL_OPTION)) {
            try {
                int detail = Integer.parseInt(args[0]);
                if (detail < 0 || detail > 4) {
                    throw new NumberFormatException();
                }
                this.reporter.setDetail(detail);
            }
            catch (NumberFormatException e) {
                this.error(i18n.getString("Main.error.arg.invalid", (Object)DETAIL_OPTION));
            }
        } else if (optionName.equalsIgnoreCase(REPORT_OPTION)) {
            this.reporter.setReportfile(args[0]);
        } else if (optionName.equalsIgnoreCase(INCLUDECONSTANTFIELDS_OPTION)) {
            this.reporter.setConstatnChecking(true);
            this.reporter.addConfig(INCLUDECONSTANTFIELDS_OPTION, "yes");
        } else if (optionName.equalsIgnoreCase(EXCLUDEABSTRACTCLASSES_OPTION)) {
            this.reporter.excludeAbstractClasses();
            this.reporter.addConfig(EXCLUDEABSTRACTCLASSES_OPTION, "yes");
        } else if (optionName.equalsIgnoreCase(EXCLUDEABSTRACTMETHODS_OPTION)) {
            this.reporter.excludeAbstractMethods();
            this.reporter.addConfig(EXCLUDEABSTRACTMETHODS_OPTION, "yes");
        } else if (optionName.equalsIgnoreCase(EXCLUDEINTERFACES_OPTION)) {
            this.reporter.excludeInterfaces();
            this.reporter.addConfig(EXCLUDEINTERFACES_OPTION, "yes");
        } else if (optionName.equalsIgnoreCase(EXCLUDEFIELD_OPTION)) {
            this.reporter.excludeFields();
            this.reporter.addConfig(EXCLUDEFIELD_OPTION, "yes");
        } else if (optionName.equalsIgnoreCase(EXCLUDELIST_OPTION)) {
            this.reporter.addXList(args);
        } else if (optionName.equalsIgnoreCase(DEBUG_OPTION)) {
            debug = true;
        } else if (optionName.equalsIgnoreCase(HELP_OPTION) || optionName.equalsIgnoreCase(QUESTIONMARK)) {
            Main.version();
            this.usage();
            this.passed();
        } else if (optionName.equalsIgnoreCase(VERSION_OPTION)) {
            Main.version();
            this.passed();
        } else if (optionName.equalsIgnoreCase(OUT_OPTION)) {
            throw new CommandLineParserException(i18n.getString("Main.error.arg.legacy", (Object)OUT_OPTION));
        }
        if (optionName.equalsIgnoreCase(VALIDATE_OPTION)) {
            throw new CommandLineParserException(i18n.getString("Main.error.arg.legacy", (Object)VALIDATE_OPTION));
        }
    }

    private boolean isPackageMember(String name) {
        return !this.excludedPackages.checkName(name) && (this.packages.checkName(name) || this.purePackages.checkName(name));
    }

    private boolean isTSMember(String name) {
        return !this.excludedPackagesTS.checkName(name) && (this.packagesTS.checkName(name) || this.purePackagesTS.checkName(name));
    }

    private static void version() {
        System.err.println("API Cover Tool -  SignatureTest version " + Version.Number);
    }

    public void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(i18n.getString("Main.usage.start"));
        sb.append(nl).append(i18n.getString("Main.usage.ts", (Object)TS_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.tsInclude", (Object)TSICNLUDE_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.tsIncludeW", (Object)TSICNLUDEW_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.tsExclude", (Object)TSEXCLUDE_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.api", (Object)API_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.apiInclude", (Object)APIINCLUDE_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.apiIncludeW", (Object)APIINCLUDEW_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.apiExclude", (Object)APIEXCLUDE_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.excludeList", (Object)EXCLUDELIST_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.excludeInterfaces", (Object)EXCLUDEINTERFACES_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.excludeAbstractClasses", (Object)EXCLUDEABSTRACTCLASSES_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.excludeAbstractMethods", (Object)EXCLUDEABSTRACTMETHODS_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.excludeFields", (Object)EXCLUDEFIELD_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.includeConstantFields", (Object)INCLUDECONSTANTFIELDS_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.mode", (Object)MODE_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.detail", (Object)DETAIL_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.format", (Object)FORMAT_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.report", (Object)REPORT_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.debug", (Object)DEBUG_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.help", (Object)HELP_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.version", (Object)VERSION_OPTION));
        sb.append(nl).append(i18n.getString("Main.usage.end"));
        System.err.println(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check() {
        FileManager f = new FileManager();
        MultipleFileReader in = new MultipleFileReader(this.log, 1, f);
        ClassHierarchyImpl apiHierarchy = new ClassHierarchyImpl(in, 2);
        new Adapter(f);
        try {
            ClassDescription cd;
            if (!in.readSignatureFiles(MAIN_URI, this.signatureFile)) {
                this.error(i18n.getString("Main.error.sigfile.invalid", (Object)this.signatureFile));
            }
            boolean is4 = in.isFeatureSupported(Format.BuildMembers);
            MemberCollectionBuilder b = new MemberCollectionBuilder(this);
            while ((cd = in.nextClass()) != null) {
                try {
                    if (is4) {
                        cd.setHierarchy(apiHierarchy);
                        if (!this.isWorstCaseMode) {
                            b.setBuildMode(MemberCollectionBuilder.BuildMode.APICOV_REAL);
                        }
                        b.createMembers(cd, true, false, true);
                    }
                }
                catch (Exception e) {
                    this.debug(e);
                    this.error(i18n.getString("Main.error.check", (Object)e.getMessage()));
                }
                if (this.isPackageMember(cd.getQualifiedName())) {
                    this.refCounter.addClass(cd);
                }
                this.refCounter.addTSClass(cd, true);
            }
            BinaryClassDescrLoader tsLoader = new BinaryClassDescrLoader(this.classpath, 4096);
            tsLoader.setLog(this.log);
            tsLoader.setIgnoreAnnotations(true);
            ClassHierarchyImpl tsHierarchy = new ClassHierarchyImpl(tsLoader, 2);
            int size = 0;
            ArrayList calls = new ArrayList();
            while (this.classpath.hasNext()) {
                String name = this.classpath.nextClassName();
                if (!this.isTSMember(name)) continue;
                try {
                    ClassDescription tsClass = tsHierarchy.load(name);
                    this.refCounter.addTSClass(tsClass, false);
                    calls.addAll(tsLoader.loadCalls(name));
                }
                catch (ClassNotFoundException e) {
                    if (debug) {
                        this.log.println(i18n.getString("Main.warning.class.invalid", (Object)name));
                    }
                    this.debug(e);
                }
                catch (ClassFormatError e) {
                    if (debug) {
                        this.log.println(i18n.getString("Main.warning.class.invalid", (Object)name));
                    }
                    this.debug(e);
                }
                catch (Throwable t) {
                    this.debug(t);
                    this.error(i18n.getString("Main.error.check", (Object)t.getMessage()));
                }
            }
            for (MemberDescription md : calls) {
                ++size;
                this.refCounter.addRef(md);
            }
            if (size == 0) {
                System.err.println(i18n.getString("Main.warning.ts.empty", (Object)this.ts));
            }
            this.reporter.out();
        }
        catch (Throwable e) {
            this.debug(e);
            this.error(i18n.getString("Main.error.check", (Object)e.getMessage()));
        }
        finally {
            in.close();
        }
    }

    private void error(String s) {
        this.log.println(s);
        System.exit(1);
    }

    private void passed() {
        System.exit(0);
    }

    private void debug(Throwable t) {
        if (debug) {
            t.printStackTrace(this.log);
        }
    }

    @Override
    public void storeError(String s, Logger utilLog) {
        this.log.append(s);
    }

    @Override
    public void storeWarning(String s, Logger utilLog) {
        this.log.append(s);
    }
}

