/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.apitest.ListCtSym;
import org.netbeans.apitest.SigtestHandler;

public final class Sigtest
extends Task {
    File fileName;
    Path classpath;
    String version;
    String packages;
    ActionType action;
    Boolean failOnError;
    File report;
    String failureProperty;
    String release;

    public void setFileName(File f) {
        this.fileName = f;
    }

    public void setPackages(String s) {
        this.packages = s;
    }

    public void setAction(ActionType s) {
        this.action = s;
    }

    public void setClasspath(Path p) {
        if (this.classpath == null) {
            this.classpath = p;
        } else {
            this.classpath.append(p);
        }
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setFailureProperty(String p) {
        this.failureProperty = p;
    }

    public void setReport(File report) {
        this.report = report;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void execute() throws BuildException {
        boolean fail;
        int returnCode;
        if (this.fileName == null) {
            throw new BuildException("FileName has to filed", this.getLocation());
        }
        if (this.packages == null) {
            throw new BuildException("Packages has to filed", this.getLocation());
        }
        if (this.action == null) {
            throw new BuildException("Action has to filed", this.getLocation());
        }
        if (this.classpath == null) {
            throw new BuildException("Classpath has to filed", this.getLocation());
        }
        SigtestHandler handler = new SigtestHandler(){

            @Override
            protected String getPackages() {
                return Sigtest.this.packages;
            }

            @Override
            protected File getFileName() {
                return Sigtest.this.fileName;
            }

            @Override
            protected String getAction() {
                return Sigtest.this.action.getValue();
            }

            @Override
            protected String getVersion() {
                return Sigtest.this.version;
            }

            @Override
            protected String[] getClasspath() {
                if (Sigtest.this.classpath == null) {
                    return null;
                }
                return Sigtest.this.classpath.list();
            }

            @Override
            protected File getReport() {
                return Sigtest.this.report;
            }

            @Override
            protected String getMail() {
                return Sigtest.this.getProject().getProperty("sigtest.mail");
            }

            @Override
            protected Boolean isFailOnError() {
                return Sigtest.this.failOnError;
            }

            @Override
            protected void logInfo(String msg) {
                Sigtest.this.getProject().log(msg, 3);
            }

            @Override
            protected void logError(String msg) {
                Sigtest.this.getProject().log(msg, 0);
            }

            @Override
            protected Integer getRelease() {
                return ListCtSym.parseReleaseInteger(Sigtest.this.release);
            }

            @Override
            protected boolean isJDKExcludeEnabled() {
                return false;
            }

            @Override
            protected String[] getIgnoreJDKClassEntries() {
                return null;
            }
        };
        try {
            returnCode = handler.execute();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        if (this.report != null) {
            fail = Boolean.TRUE.equals(this.failOnError);
        } else {
            boolean bl = fail = !Boolean.FALSE.equals(this.failOnError);
        }
        if (returnCode != 0) {
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, "true");
            } else if (fail) {
                throw new BuildException("Signature tests return code is wrong (" + returnCode + "), check the messages above", this.getLocation());
            }
            this.log("Signature tests return code is wrong (" + returnCode + "), check the messages above");
        }
    }

    public static final class ActionType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return SigtestHandler.ACTIONS;
        }
    }
}

