/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Release {
    public static final Release BOOT_CLASS_PATH;
    private final char version;
    private final FileSystem zipFs;
    private final String[] prefixes;
    private static final Map<Character, Release> RELEASES;

    private Release(char version, FileSystem zipFs, String ... prefixes) {
        this.version = version;
        this.zipFs = zipFs;
        this.prefixes = prefixes;
    }

    public static Release find(int version) {
        char ch = (char)(version < 10 ? 48 + version : 65 + (version - 10));
        return RELEASES.get(Character.valueOf(ch));
    }

    /*
     * Unable to fully structure code
     */
    InputStream findClass(String name) {
        if (this.prefixes == null) {
            resourceName = name.replace('.', '/') + ".class";
            return ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
        }
        for (String p : this.prefixes) {
            is = null;
            if (this.zipFs != null) {
                if (p.endsWith("system-modules")) {
                    resourceName = name.replace('.', '/') + ".class";
                    return ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
                }
                try {
                    sigFile = this.zipFs.getPath(p + "/" + name.replace('.', '/') + ".sig", new String[0]);
                    if (!Files.exists(sigFile, new LinkOption[0])) ** GOTO lbl19
                    is = Files.newInputStream(sigFile, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else {
                resourceName = "/META-INF/sigtest/" + p + "/" + name.replace('.', '/') + ".sig";
                is = Release.class.getResourceAsStream(resourceName);
            }
lbl19:
            // 3 sources

            if (is == null) continue;
            return is;
        }
        return null;
    }

    private static FileSystem zipFs(Path path) throws IOException {
        URI uri = URI.create("jar:" + String.valueOf(path.toUri()));
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            return FileSystems.newFileSystem(uri, Map.of());
        }
    }

    static {
        FileSystem zipFs;
        BOOT_CLASS_PATH = new Release('0', null, null);
        final ArrayList<String> lines = new ArrayList<String>();
        Path ctSym = Paths.get(System.getProperty("java.home"), "lib", "ct.sym");
        if (Files.exists(ctSym, new LinkOption[0])) {
            try {
                zipFs = Release.zipFs(ctSym);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        zipFs.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }));
                Files.walkFileTree(zipFs.getPath("/", new String[0]), Set.of(), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                    private String prefix;

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        this.prefix = dir.getFileName() == null ? null : dir.getFileName().toString();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String newPrefix;
                        String fileName = file.getFileName().toString();
                        String string = newPrefix = this.prefix == null ? fileName : this.prefix + "/" + fileName;
                        if (this.prefix != null) {
                            lines.add(newPrefix);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        this.prefix = null;
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
        zipFs = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(Release.class.getResourceAsStream("/META-INF/sigtest.ls")));){
            Object l;
            while ((l = r.readLine()) != null) {
                lines.add((String)l);
            }
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        HashMap<Character, ArrayList<String>> prefixes = new HashMap<Character, ArrayList<String>>();
        for (String l : lines) {
            String[] versionsDir = l.split("/");
            String versions = versionsDir[0];
            for (int i = 0; i < versions.length(); ++i) {
                Character ch = Character.valueOf(versions.charAt(i));
                ArrayList<String> arr = (ArrayList<String>)prefixes.get(ch);
                if (arr == null) {
                    arr = new ArrayList<String>();
                    prefixes.put(ch, arr);
                }
                arr.add(l);
            }
        }
        HashMap<Character, Release> releases = new HashMap<Character, Release>();
        for (Map.Entry entry : prefixes.entrySet()) {
            Character key = (Character)entry.getKey();
            List value = (List)entry.getValue();
            releases.put(key, new Release(key.charValue(), zipFs, value.toArray(new String[0])));
        }
        RELEASES = releases;
    }
}

