/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.sigfile.F21Format;
import com.sun.tdk.signaturetest.sigfile.F31Format;
import com.sun.tdk.signaturetest.sigfile.F40Format;
import com.sun.tdk.signaturetest.sigfile.F41Format;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Reader;
import com.sun.tdk.signaturetest.sigfile.Writer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FileManager {
    private static final String DEFAULT_PROTOCOL = "file:";
    private Format defaultFormat = new F41Format();
    private List formats = new ArrayList();

    public static URL getURL(String testURL, String fileName) throws MalformedURLException {
        URL result;
        File f = new File(fileName);
        if (f.isAbsolute()) {
            result = f.toURL();
        } else {
            if (((String)testURL).indexOf(58) == -1) {
                testURL = DEFAULT_PROTOCOL + (String)testURL;
            }
            result = new URL(new URL((String)testURL), fileName);
        }
        return result;
    }

    private String getFormat(URL fileURL) {
        String currentLine;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream(), "UTF8"));
            currentLine = in.readLine();
            if (currentLine == null) {
                return null;
            }
            currentLine = currentLine.trim();
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return currentLine;
    }

    public Writer getWriter(Set features) {
        ArrayList<Format> applicableFormats = new ArrayList<Format>(this.formats.size());
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = (Format)this.formats.get(i);
            Set formatFeatures = format.getSupportedFeatures();
            if (!features.equals(formatFeatures)) continue;
            applicableFormats.add(format);
        }
        double latestVersion = 0.0;
        Writer latestWriter = null;
        for (int i = 0; i < applicableFormats.size(); ++i) {
            Format f = (Format)applicableFormats.get(i);
            String[] sv = f.getVersion().split(" ");
            double v = Double.parseDouble(sv[sv.length - 1].substring(1));
            if (!(v > latestVersion)) continue;
            latestVersion = v;
            latestWriter = f.getWriter();
        }
        return latestWriter;
    }

    public Reader getReader(URL fileURL) {
        String format = this.getFormat(fileURL);
        if (format != null) {
            for (Format f : this.formats) {
                if (!f.isApplicable(format)) continue;
                return f.getReader();
            }
        }
        return null;
    }

    public Format getDefaultFormat() {
        return this.defaultFormat;
    }

    public void addFormat(Format frm, boolean useByDefault) {
        this.formats.add(frm);
        if (useByDefault) {
            this.defaultFormat = frm;
        }
    }

    public void setFormat(Format frm) {
        this.formats.clear();
        this.formats.add(frm);
        this.defaultFormat = frm;
    }

    public FileManager() {
        this.formats.add(this.defaultFormat);
        this.formats.add(new F21Format());
        this.formats.add(new F31Format());
        this.formats.add(new F40Format());
    }
}

