/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Reader;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;

public class MultipleFileReader
extends VirtualClassDescriptionLoader {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(MultipleFileReader.class);
    public static final int CLASSPATH_MODE = 1;
    public static final int MERGE_MODE = 2;
    private Iterator classIterator = null;
    private PrintWriter log;
    private int mode;
    private String apiVersion;
    private FileManager fileMan;

    public MultipleFileReader(PrintWriter log, int mode, FileManager f) {
        assert (mode == 1);
        this.log = log;
        this.mode = mode;
        this.fileMan = f;
    }

    public boolean readSignatureFiles(String testURL, String sigFileList) {
        assert (testURL != null);
        assert (sigFileList != null);
        boolean result = true;
        StringTokenizer st = new StringTokenizer(sigFileList, File.pathSeparator);
        while (st.hasMoreElements() && result) {
            String fileName = st.nextToken();
            result = this.readSignatureFile(testURL, fileName);
        }
        return result;
    }

    public boolean readSignatureFile(String testURL, String sigFileName) {
        boolean result;
        assert (testURL != null);
        assert (sigFileName != null);
        try {
            URL fileURL = FileManager.getURL(testURL, sigFileName);
            result = this.readFile(fileURL);
        }
        catch (MalformedURLException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            Object[] invargs = new String[]{testURL, e.getMessage()};
            this.log.println(i18n.getString("MultipleFileReader.error.url.threwerror", invargs));
            return false;
        }
        catch (IOException er) {
            if (SigTest.debug) {
                er.printStackTrace();
            }
            this.log.println(er);
            return false;
        }
        this.rewind();
        return result;
    }

    private boolean readFile(URL fileURL) {
        Object msg = null;
        Reader in = this.fileMan.getReader(fileURL);
        if (in == null) {
            return false;
        }
        try {
            ClassDescription cl;
            if (!in.readSignatureFile(fileURL)) {
                msg = i18n.getString("MultipleFileReader.error.sigfile.invalid", (Object)fileURL);
            }
            if (this.mode == 2 && !in.hasFeature(FeaturesHolder.MergeModeSupported)) {
                throw new IOException(i18n.getString("MultipleFileReader.error.cannt_merge_old_files") + String.valueOf(fileURL));
            }
            if (!this.isInitialized()) {
                this.setFeatures(in.getAllSupportedFeatures());
            } else {
                this.retainFeatures(in.getAllSupportedFeatures());
            }
            this.apiVersion = in.getApiVersion();
            while ((cl = in.readNextClass()) != null) {
                String name = cl.getQualifiedName();
                if (this.mode == 1) {
                    try {
                        this.load(name);
                    }
                    catch (ClassNotFoundException ex) {
                        this.add(cl);
                    }
                    continue;
                }
                assert (this.mode == 2);
            }
        }
        catch (IOException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("MultipleFileReader.error.sigfile.prob") + "\n" + String.valueOf(e);
        }
        catch (SecurityException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("MultipleFileReader.error.sigfile.sec") + "\n" + String.valueOf(e);
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (msg != null) {
            this.log.println((String)msg);
            return false;
        }
        return true;
    }

    public void close() {
        this.classIterator = null;
        this.cleanUp();
    }

    public void rewind() {
        this.classIterator = this.getClassIterator();
    }

    public ClassDescription nextClass() throws IOException {
        ClassDescription cl = null;
        if (this.classIterator != null && this.classIterator.hasNext()) {
            cl = (ClassDescription)this.classIterator.next();
        }
        return cl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

