/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.netbeans.apitest.SigtestCheck;
import org.netbeans.apitest.SigtestGenerate;

@Mojo(name="compare", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public final class SigtestCompare
extends AbstractMojo {
    @Component
    private MavenProject prj;
    @Component
    private MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classes;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.sigfile")
    private File sigfile;
    @Parameter(defaultValue="")
    private String packages;
    @Parameter(defaultValue="")
    String excludes;
    @Parameter(property="maven.compiler.release")
    private String release;
    @Parameter(property="sigtest.releaseVersion")
    private String releaseVersion;
    @Parameter(defaultValue="check", property="sigtest.check")
    private String action;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/sigtest/TEST-${project.build.finalName}.xml")
    private File report;
    @Parameter(defaultValue="true", property="sigtest.fail")
    private boolean failOnError;
    @Parameter(defaultValue="false", property="IgnoreJDKClasses")
    private String[] ignoreJDKClasses;
    @Parameter(defaultValue="false", property="IgnoreAllJDKClasses")
    private boolean ignoreAllJDKClasses;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packages == null) {
            this.getLog().info((CharSequence)("No packages specified, skipping sigtest:compare " + this.action));
            return;
        }
        if (this.releaseVersion == null) {
            throw new MojoExecutionException("Specify <releaseVersion in plugin config section or use -Dsigtest.releaseVersion!");
        }
        if (this.classes == null || !this.classes.exists()) {
            throw new MojoExecutionException("Point <classes>to-directory-with-classfiles-to-test</classes> in plugin config section!");
        }
        DefaultArtifact artifact = new DefaultArtifact(this.prj.getGroupId(), this.prj.getArtifactId(), this.releaseVersion, null, "jar", "", (ArtifactHandler)new DefaultArtifactHandler("jar"));
        try {
            this.artifactResolver.resolve((Artifact)artifact, this.session.getProjectBuildingRequest().getRemoteRepositories(), this.session.getLocalRepository());
        }
        catch (AbstractArtifactResolutionException ex) {
            throw new MojoExecutionException("Cannot resolve " + String.valueOf(artifact), (Exception)((Object)ex));
        }
        SigtestGenerate generate = new SigtestGenerate(this.prj, artifact.getFile(), this.sigfile, this.packages, this.releaseVersion, this.release, this.ignoreJDKClasses, this.ignoreAllJDKClasses, this.excludes);
        generate.execute();
        SigtestCheck check = new SigtestCheck(this.prj, this.classes, this.sigfile, this.action, this.packages, this.report, this.failOnError, this.ignoreJDKClasses, this.ignoreAllJDKClasses);
        check.execute();
    }
}

