/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.api.jakarta.websocket.server.serverendpointconfig;

import com.sun.ts.tests.websocket.api.jakarta.websocket.server.serverendpointconfig.TCKConfigurator;
import com.sun.ts.tests.websocket.api.jakarta.websocket.server.serverendpointconfig.TCKEndpoint;
import com.sun.ts.tests.websocket.common.TCKExtension;
import com.sun.ts.tests.websocket.common.util.BooleanDecoder;
import com.sun.ts.tests.websocket.common.util.BooleanEncoder;
import com.sun.ts.tests.websocket.common.util.ByteDecoder;
import com.sun.ts.tests.websocket.common.util.ErrorEncoder;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="websocket"), @Tag(value="platform"), @Tag(value="web")})
public class WSClientIT {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"websocket_serverendpointconfig.war");
        archive.addClasses(new Class[]{TCKEndpoint.class});
        return archive;
    }

    @Test
    public void constructortest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").build();
            List tmp = sec.getDecoders();
            if (tmp != null) {
                logger.log(System.Logger.Level.TRACE, "getDecoders() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getDecoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = sec.getEncoders()) != null) {
                logger.log(System.Logger.Level.TRACE, "getEncoders() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getEncoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = sec.getExtensions()) != null) {
                logger.log(System.Logger.Level.TRACE, "getExtensions() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = sec.getSubprotocols()) != null) {
                logger.log(System.Logger.Level.TRACE, "getSubprotocols() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getSubprotocols() return non-empty List with size " + tmp.size() + "|");
                    passed = false;
                }
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed");
        }
    }

    @Test
    public void subprotocolsTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").subprotocols(expected_subprotocols).build();
            List tmp = sec.getSubprotocols();
            if (tmp != null) {
                log.append("getSubprotocols() return non-null List|");
                if (!tmp.isEmpty()) {
                    log.append("getSubprotocols() return non-empty List with size " + tmp.size() + "|");
                    int size_actual = tmp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getSubprotocols() return null list");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void extensionsTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").extensions(extensions).build();
            List tmp = sec.getExtensions();
            if (tmp != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmp.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmp.size() + "|");
                    int size_actual = tmp.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmp) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest1() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").subprotocols(expected_subprotocols).extensions(extensions).build();
            List tmpe = sec.getExtensions();
            List tmpp = sec.getSubprotocols();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getSubprotocols() return null list");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void encodersTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").encoders(expected_encoders).build();
            List tmp = sec.getEncoders();
            if (tmp != null) {
                log.append("getEncoders() return non-null List");
                if (!tmp.isEmpty()) {
                    int size = tmp.size();
                    log.append("getEncoders() return non-empty List  with size " + size + "|");
                    if (size == 2) {
                        for (Class encoder : tmp) {
                            log.append("Encoder " + encoder + " found ");
                            if (expected_encoders.contains(encoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getEncoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getEncoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getEncoders() return null list");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void decodersTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").decoders(expected_decoders).build();
            List tmp = sec.getDecoders();
            if (tmp != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmp.isEmpty()) {
                    int size = tmp.size();
                    log.append("getDecoders() return non-empty List  with size " + tmp.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmp) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest2() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").subprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).build();
            List tmpe = sec.getExtensions();
            List tmpp = sec.getSubprotocols();
            List tmpd = sec.getDecoders();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getSubprotocols() return null list");
            }
            if (tmpd != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmpd.isEmpty()) {
                    int size = tmpd.size();
                    log.append("getDecoders() return non-empty List  with size " + tmpd.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmpd) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest3() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("MBWS", "MBLWS", "soap", "WAMP", "v10.stomp", "v11.stomp", "v12.stomp");
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").subprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).encoders(expected_encoders).build();
            List tmpe = sec.getExtensions();
            List tmpp = sec.getSubprotocols();
            List tmpd = sec.getDecoders();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getSubprotocols() return null list");
            }
            if (tmpd != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmpd.isEmpty()) {
                    int size = tmpd.size();
                    log.append("getDecoders() return non-empty List  with size " + tmpd.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmpd) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
            List tmpen = sec.getEncoders();
            if (tmpen != null) {
                log.append("getEncoders() return non-null List");
                if (!tmpen.isEmpty()) {
                    int size = tmpen.size();
                    log.append("getEncoders() return non-empty List  with size " + size + "|");
                    if (size == 2) {
                        for (Class encoder : tmpen) {
                            log.append("Encoder " + encoder + " found ");
                            if (expected_encoders.contains(encoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getEncoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getEncoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getEncoders() return null list");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void configuratorTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        TCKConfigurator config = new TCKConfigurator();
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").configurator((ServerEndpointConfig.Configurator)config).build();
            ServerEndpointConfig.Configurator tmpc = sec.getConfigurator();
            if (!tmpc.getClass().equals(TCKConfigurator.class)) {
                log.append("getConfigurator() returned a different Configurator: " + tmpc.getClass().getName());
                passed = false;
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest4() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        TCKConfigurator config = new TCKConfigurator();
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").configurator((ServerEndpointConfig.Configurator)config).build();
            List tmp = sec.getDecoders();
            if (tmp != null) {
                logger.log(System.Logger.Level.TRACE, "getDecoders() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getDecoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = sec.getEncoders()) != null) {
                logger.log(System.Logger.Level.TRACE, "getEncoders() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getEncoders() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = sec.getExtensions()) != null) {
                logger.log(System.Logger.Level.TRACE, "getExtensions() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmp.size() + "|");
                    passed = false;
                }
            }
            if ((tmp = sec.getSubprotocols()) != null) {
                logger.log(System.Logger.Level.TRACE, "getSubprotocols() return non-null List");
                if (!tmp.isEmpty()) {
                    log.append("getSubprotocols() return non-empty List with size " + tmp.size() + "|");
                    passed = false;
                }
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void getEndpointClassTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").build();
            Class tmp = sec.getEndpointClass();
            if (!tmp.equals(TCKEndpoint.class)) {
                log.append("getEndpointClass() returned a different Class: " + tmp.getName());
                passed = false;
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void getPathTest() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        String path = "/TCKTestServer";
        try {
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)path).build();
            String tmp = sec.getPath();
            if (!path.equals(tmp)) {
                log.append("getPath() returned a different path: " + tmp);
                passed = false;
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    @Test
    public void constructorTest5() throws Exception {
        boolean passed = true;
        StringBuffer log = new StringBuffer();
        List<String> expected_subprotocols = Arrays.asList("JSON", "XML", "XMPP", "Hessian", "Quake", "PUB/SUB", "Query");
        ArrayList<Class> expected_encoders = new ArrayList<Class>();
        expected_encoders.add(ErrorEncoder.class);
        expected_encoders.add(BooleanEncoder.class);
        ArrayList<Class> expected_decoders = new ArrayList<Class>();
        expected_decoders.add(ByteDecoder.class);
        expected_decoders.add(BooleanDecoder.class);
        TCKConfigurator config = new TCKConfigurator();
        ArrayList<Extension.Parameter> extension1 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("permessage-compress", "foo"));
                this.add(new TCKExtension.TCKParameter("prop", "val"));
            }
        };
        ArrayList<Extension.Parameter> extension2 = new ArrayList<Extension.Parameter>(){
            {
                this.add(new TCKExtension.TCKParameter("permessage-compress", "deflate"));
                this.add(new TCKExtension.TCKParameter("prop1", "val1"));
                this.add(new TCKExtension.TCKParameter("prop2", "val2"));
            }
        };
        ArrayList<TCKExtension> extensions = new ArrayList<TCKExtension>();
        extensions.add(new TCKExtension("ext1", (List<Extension.Parameter>)extension1));
        extensions.add(new TCKExtension("ext2", (List<Extension.Parameter>)extension2));
        try {
            int size_actual;
            ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(TCKEndpoint.class, (String)"/TCKTestServer").subprotocols(expected_subprotocols).extensions(extensions).decoders(expected_decoders).encoders(expected_encoders).configurator((ServerEndpointConfig.Configurator)config).build();
            List tmpe = sec.getExtensions();
            List tmpp = sec.getSubprotocols();
            List tmpd = sec.getDecoders();
            if (tmpe != null) {
                log.append("getExtensions() return non-null List|");
                if (!tmpe.isEmpty()) {
                    log.append("getExtensions() return non-empty List  with size " + tmpe.size() + "|");
                    size_actual = tmpe.size();
                    if (size_actual == extensions.size()) {
                        for (Extension ext : tmpe) {
                            if (extensions.contains(ext)) {
                                log.append("extension " + ext + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("extension " + ext + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getExtensions() returned not exactly the same amount of extensions.");
                        log.append("Expecting two, returned " + size_actual);
                    }
                } else {
                    log.append("getExtensions() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getExtensions() return null list|");
            }
            if (tmpp != null) {
                log.append("getSubprotocols() return non-null List|");
                if (!tmpp.isEmpty()) {
                    log.append("getSubprotocols() return non-empty List with size " + tmpp.size() + "|");
                    size_actual = tmpp.size();
                    if (size_actual == expected_subprotocols.size()) {
                        for (String subpro : tmpp) {
                            if (expected_subprotocols.contains(subpro)) {
                                log.append("sub protocol " + subpro + " found is expected|");
                                continue;
                            }
                            passed = false;
                            log.append("sub protocol " + subpro + " found is not expected|");
                        }
                    } else {
                        passed = false;
                        log.append("getSubprotocols() returned not exactly the same size.");
                        log.append("Expecting seven, returned " + size_actual);
                    }
                } else {
                    log.append("getSubprotocols() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getSubprotocols() return null list");
            }
            if (tmpd != null) {
                log.append("getDecoders() return non-null List|");
                if (!tmpd.isEmpty()) {
                    int size = tmpd.size();
                    log.append("getDecoders() return non-empty List  with size " + tmpd.size() + "|");
                    if (size == 2) {
                        for (Class decoder : tmpd) {
                            log.append("Decoder " + decoder + " found ");
                            if (expected_decoders.contains(decoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getDecoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getDecoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getDecoders() return null list|");
            }
            List tmpen = sec.getEncoders();
            if (tmpen != null) {
                log.append("getEncoders() return non-null List");
                if (!tmpen.isEmpty()) {
                    int size = tmpen.size();
                    log.append("getEncoders() return non-empty List  with size " + size + "|");
                    if (size == 2) {
                        for (Class encoder : tmpen) {
                            log.append("Encoder " + encoder + " found ");
                            if (expected_encoders.contains(encoder)) {
                                log.append("is expected.|");
                                continue;
                            }
                            passed = false;
                            log.append("is not expected.|");
                        }
                    } else {
                        passed = false;
                        log.append("getEncoders() returned not exactly the same size.");
                        log.append("Expecting two, returned " + size);
                    }
                } else {
                    log.append("getEncoders() return empty List|");
                    passed = false;
                }
            } else {
                passed = false;
                log.append("getEncoders() return null list");
            }
        }
        catch (Exception e) {
            log.append(e.getMessage());
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, log.toString());
        if (!passed) {
            throw new Exception("Test failed: " + log.toString());
        }
    }

    public void cleanup() {
    }
}

