/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import java.io.Serializable;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;

public class MailAddress
implements Serializable {
    public static final long serialVersionUID = 2779163542539434916L;
    private static final char[] SPECIAL = new char[]{'<', '>', '(', ')', '[', ']', '\\', '.', ',', ';', ':', '@', '\"'};
    private String user = null;
    private String host = null;
    private int pos = 0;

    public MailAddress(String address) throws ParseException {
        address = address.trim();
        StringBuffer userSB = new StringBuffer();
        StringBuffer hostSB = new StringBuffer();
        try {
            if (address.charAt(this.pos) == '\"') {
                userSB.append(this.parseQuotedLocalPart(address));
            } else {
                userSB.append(this.parseUnquotedLocalPart(address));
            }
            if (userSB.toString().length() == 0) {
                throw new ParseException("No local-part (user account) found at position " + (this.pos + 1));
            }
            if (this.pos >= address.length() || address.charAt(this.pos) != '@') {
                throw new ParseException("Did not find @ between local-part and domain at position " + (this.pos + 1));
            }
            ++this.pos;
            while (true) {
                if (address.charAt(this.pos) == '#') {
                    hostSB.append(this.parseNumber(address));
                } else if (address.charAt(this.pos) == '[') {
                    hostSB.append(this.parseDotNum(address));
                } else {
                    hostSB.append(this.parseDomainName(address));
                }
                if (this.pos >= address.length() || address.charAt(this.pos) != '.') break;
                hostSB.append('.');
                ++this.pos;
            }
            if (hostSB.toString().length() == 0) {
                throw new ParseException("No domain found at position " + (this.pos + 1));
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new ParseException("Out of data at position " + (this.pos + 1));
        }
        this.user = userSB.toString();
        this.host = hostSB.toString();
    }

    public MailAddress(String newUser, String newHost) throws ParseException {
        this.user = newUser;
        this.host = newHost;
    }

    public MailAddress(InternetAddress address) throws ParseException {
        this(address.getAddress());
    }

    public String getHost() {
        if (!this.host.startsWith("[") || !this.host.endsWith("]")) {
            return this.host;
        }
        return this.host.substring(1, this.host.length() - 1);
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        StringBuffer addressBuffer = new StringBuffer(128).append(this.user).append("@").append(this.host);
        return addressBuffer.toString();
    }

    public InternetAddress toInternetAddress() {
        try {
            return new InternetAddress(this.toString());
        }
        catch (AddressException ae) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String theString = (String)obj;
            return this.toString().equalsIgnoreCase(theString);
        }
        if (obj instanceof MailAddress) {
            MailAddress addr = (MailAddress)obj;
            return this.getUser().equalsIgnoreCase(addr.getUser()) && this.getHost().equalsIgnoreCase(addr.getHost());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().toLowerCase(Locale.US).hashCode();
    }

    private String parseQuotedLocalPart(String address) throws ParseException {
        StringBuffer resultSB = new StringBuffer();
        resultSB.append('\"');
        ++this.pos;
        while (true) {
            if (address.charAt(this.pos) == '\"') {
                resultSB.append('\"');
                ++this.pos;
                break;
            }
            if (address.charAt(this.pos) == '\\') {
                resultSB.append('\\');
                ++this.pos;
                char x = address.charAt(this.pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new ParseException("Invalid \\ syntaxed character at position " + (this.pos + 1));
                }
                resultSB.append(x);
                ++this.pos;
                continue;
            }
            char q = address.charAt(this.pos);
            if (q <= '\u0000' || q == '\n' || q == '\r' || q == '\"' || q == '\\') {
                throw new ParseException("Unquoted local-part (user account) must be one of the 128 ASCI characters exception <CR>, <LF>, quote (\"), or backslash (\\) at position " + (this.pos + 1));
            }
            resultSB.append(q);
            ++this.pos;
        }
        return resultSB.toString();
    }

    private String parseUnquotedLocalPart(String address) throws ParseException {
        StringBuffer resultSB = new StringBuffer();
        boolean lastCharDot = false;
        while (true) {
            if (address.charAt(this.pos) == '\\') {
                resultSB.append('\\');
                ++this.pos;
                char x = address.charAt(this.pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new ParseException("Invalid \\ syntaxed character at position " + (this.pos + 1));
                }
                resultSB.append(x);
                ++this.pos;
                lastCharDot = false;
                continue;
            }
            if (address.charAt(this.pos) == '.') {
                resultSB.append('.');
                ++this.pos;
                lastCharDot = true;
                continue;
            }
            if (address.charAt(this.pos) == '@') break;
            char c = address.charAt(this.pos);
            if (c <= '\u001f' || c >= '\u007f' || c == ' ') {
                throw new ParseException("Invalid character in local-part (user account) at position " + (this.pos + 1));
            }
            int i = 0;
            while (i < SPECIAL.length) {
                if (c == SPECIAL[i]) {
                    throw new ParseException("Invalid character in local-part (user account) at position " + (this.pos + 1));
                }
                ++i;
            }
            resultSB.append(c);
            ++this.pos;
            lastCharDot = false;
        }
        if (lastCharDot) {
            throw new ParseException("local-part (user account) ended with a \".\", which is invalid.");
        }
        return resultSB.toString();
    }

    private String parseNumber(String address) throws ParseException {
        char d;
        StringBuffer resultSB = new StringBuffer();
        while (this.pos < address.length() && (d = address.charAt(this.pos)) != '.') {
            if (d < '0' || d > '9') {
                throw new ParseException("In domain, did not find a number in # address at position " + (this.pos + 1));
            }
            resultSB.append(d);
            ++this.pos;
        }
        return resultSB.toString();
    }

    private String parseDotNum(String address) throws ParseException {
        while (address.indexOf("\\") > -1) {
            address = address.substring(0, address.indexOf("\\")) + address.substring(address.indexOf("\\") + 1);
        }
        StringBuffer resultSB = new StringBuffer();
        resultSB.append(address.charAt(this.pos));
        ++this.pos;
        int octet = 0;
        while (octet < 4) {
            StringBuffer snumSB = new StringBuffer();
            int digits = 0;
            while (digits < 3) {
                char d = address.charAt(this.pos);
                if (d == '.' || d == ']') break;
                if (d < '0' || d > '9') {
                    throw new ParseException("Invalid number at position " + (this.pos + 1));
                }
                snumSB.append(d);
                ++this.pos;
                ++digits;
            }
            if (snumSB.toString().length() == 0) {
                throw new ParseException("Number not found at position " + (this.pos + 1));
            }
            try {
                int snum = Integer.parseInt(snumSB.toString());
                if (snum > 255) {
                    throw new ParseException("Invalid number at position " + (this.pos + 1));
                }
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Invalid number at position " + (this.pos + 1));
            }
            resultSB.append(snumSB.toString());
            if (address.charAt(this.pos) == ']') {
                if (octet >= 3) break;
                throw new ParseException("End of number reached too quickly at " + (this.pos + 1));
            }
            if (address.charAt(this.pos) == '.') {
                resultSB.append('.');
                ++this.pos;
            }
            ++octet;
        }
        if (address.charAt(this.pos) != ']') {
            throw new ParseException("Did not find closing bracket \"]\" in domain at position " + (this.pos + 1));
        }
        resultSB.append(']');
        ++this.pos;
        return resultSB.toString();
    }

    private String parseDomainName(String address) throws ParseException {
        String result;
        StringBuffer resultSB = new StringBuffer();
        while (this.pos < address.length()) {
            char ch = address.charAt(this.pos);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '-') {
                resultSB.append(ch);
                ++this.pos;
                continue;
            }
            if (ch == '.') break;
            throw new ParseException("Invalid character at " + this.pos);
        }
        if ((result = resultSB.toString()).startsWith("-") || result.endsWith("-")) {
            throw new ParseException("Domain name cannot begin or end with a hyphen \"-\" at position " + (this.pos + 1));
        }
        return result;
    }
}

