/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.EnvelopeHandler;
import com.sun.j3d.loaders.lw3d.J3dLwoParser;
import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.LwsMotion;
import com.sun.j3d.loaders.lw3d.LwsPrimitive;
import com.sun.j3d.loaders.lw3d.SequenceReader;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3f;

class LwsObject
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;
    Vector shapeList = null;
    boolean hasPivot = false;
    TransformGroup pivotTransGroup = null;
    URL urlName;
    String protocol;
    int fileType;

    LwsObject(StreamTokenizer streamTokenizer, boolean bl, int n, int n2, float f, Lw3dLoader lw3dLoader, int n3) throws FileNotFoundException, ParsingErrorException {
        this.debugPrinter.setValidOutput(n3);
        this.parent = -1;
        this.fileType = lw3dLoader.getFileType();
        try {
            Object object;
            if (bl) {
                this.fileName = this.getString(streamTokenizer);
                String string = null;
                switch (lw3dLoader.getFileType()) {
                    case 2: {
                        string = lw3dLoader.getBasePath();
                        if (string == null) {
                            string = lw3dLoader.getInternalBasePath();
                        }
                        if (string == null) break;
                        this.fileName = this.getQualifiedFilename(string, this.fileName);
                        break;
                    }
                    case 1: {
                        string = "";
                        object = lw3dLoader.getBaseUrl();
                        if (object != null) {
                            string = ((URL)object).toString();
                            this.protocol = ((URL)object).getProtocol();
                        } else {
                            string = lw3dLoader.getInternalBaseUrl();
                            this.protocol = new URL(string).getProtocol();
                        }
                        this.urlName = this.getQualifiedURL(string, this.fileName);
                    }
                }
            } else {
                this.objName = this.getString(streamTokenizer);
            }
            this.skip(streamTokenizer, "ShowObject", 2);
            this.debugOutputLn(8, "skipped showobject, about to get objectmotion");
            this.getAndCheckString(streamTokenizer, "ObjectMotion");
            this.debugOutputLn(8, "got string " + streamTokenizer.sval);
            this.motion = new LwsMotion(streamTokenizer, n, n2, f, n3);
            this.debugOutputLn(8, "got motion");
            boolean bl2 = false;
            while (!this.isCurrentToken(streamTokenizer, "ShadowOptions")) {
                if (!bl2 && this.isCurrentToken(streamTokenizer, "ParentObject")) {
                    this.parent = (int)this.getNumber(streamTokenizer);
                    bl2 = true;
                } else if (this.isCurrentToken(streamTokenizer, "PivotPoint")) {
                    this.hasPivot = true;
                    float f2 = (float)this.getNumber(streamTokenizer);
                    float f3 = (float)this.getNumber(streamTokenizer);
                    float f4 = (float)this.getNumber(streamTokenizer);
                    Vector3f vector3f = new Vector3f(-f2, -f3, f4);
                    Transform3D transform3D = new Transform3D();
                    transform3D.set(vector3f);
                    this.pivotTransGroup = new TransformGroup(transform3D);
                    this.pivotTransGroup.setCapability(18);
                } else if (this.isCurrentToken(streamTokenizer, "ObjDissolve")) {
                    object = new EnvelopeHandler(streamTokenizer, n2, f);
                }
                streamTokenizer.nextToken();
            }
            this.getNumber(streamTokenizer);
            this.debugOutputLn(8, "done with LwsObject constructor");
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParsingErrorException("Expected a number, got " + numberFormatException.getMessage());
        }
    }

    String getQualifiedFilename(String string, String string2) throws FileNotFoundException {
        String string3;
        String string4 = "";
        if (string2.indexOf(File.separator) == 0) {
            int n = string2.lastIndexOf(File.separator);
            if (n != -1) {
                string4 = string2.substring(0, n + 1);
                string2 = string2.substring(n + 1);
            } else {
                return null;
            }
        }
        try {
            if (new File(string4 + string2).exists()) {
                return string4 + string2;
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        if (new File(string4 + string2.toLowerCase()).exists()) {
            return string4 + string2.toLowerCase();
        }
        if (new File(string + string2).exists()) {
            return string + string2;
        }
        if (new File(string + string2.toLowerCase()).exists()) {
            return string + string2.toLowerCase();
        }
        if (new File(string2).exists()) {
            return string2;
        }
        if (new File(string2.toLowerCase()).exists()) {
            return string2.toLowerCase();
        }
        if (string.equals(File.separator) || string == null || string.equals("")) {
            throw new FileNotFoundException(string2);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        int n = stringTokenizer.countTokens() - 1;
        if (string.startsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        int n2 = 0;
        while (n2 < n) {
            string3 = stringTokenizer.nextToken();
            stringBuffer.append(string3);
            stringBuffer.append(File.separator);
            ++n2;
        }
        string3 = stringBuffer.toString();
        return this.getQualifiedFilename(string3, string2);
    }

    URL getQualifiedURL(String string, String string2) throws MalformedURLException {
        URL uRL = null;
        try {
            uRL = new URL(string + string2);
            uRL.getContent();
            return uRL;
        }
        catch (IOException iOException) {
            try {
                uRL = new URL(string2);
                uRL.getContent();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                uRL = new URL(this.protocol + ":" + string2);
                uRL.getContent();
                return uRL;
            }
            catch (IOException iOException3) {
                throw new MalformedURLException(string + string2);
            }
        }
    }

    int getParent() {
        return this.parent;
    }

    void addChild(LwsPrimitive lwsPrimitive) {
        this.debugOutputLn(1, "addChild()");
        if (this.objectTransform != null) {
            this.debugOutputLn(8, "objectTransform = " + this.objectTransform);
            if (lwsPrimitive.getObjectNode() != null) {
                this.debugOutputLn(8, "child has object node");
                if (this.hasPivot) {
                    this.pivotTransGroup.addChild((Node)lwsPrimitive.getObjectNode());
                } else {
                    this.objectTransform.addChild((Node)lwsPrimitive.getObjectNode());
                }
            }
        }
    }

    void createJava3dObject(LwsObject lwsObject, int n) throws IncorrectFormatException, ParsingErrorException, FileNotFoundException {
        Object object;
        String string = new String("_sequence_");
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        LwsFrame lwsFrame = this.motion.getFirstFrame();
        lwsFrame.setMatrix(matrix4d);
        Transform3D transform3D = new Transform3D();
        transform3D.set(matrix4d);
        this.objectTransform = new TransformGroup(transform3D);
        this.objectTransform.setCapability(18);
        if (this.fileName != null && this.fileName.indexOf(string) != -1) {
            int n2 = this.fileName.indexOf(string);
            object = this.fileName.substring(n2 += string.length());
            int n3 = ((String)object).indexOf(".lwo");
            if (n3 != -1) {
                object = ((String)object).substring(0, n3);
            }
            if (new File((String)object).exists()) {
                SequenceReader sequenceReader = new SequenceReader((String)object, this.motion.totalTime, this.motion.totalFrames);
                sequenceReader.printLines();
                sequenceReader.createJava3dObjects(this.debugPrinter.getValidOutput(), n);
                TransformGroup transformGroup = sequenceReader.getObjectNode();
                if (transformGroup != null) {
                    this.objectTransform.addChild((Node)transformGroup);
                }
                this.objectBehavior = sequenceReader.getObjectBehaviors();
                return;
            }
        }
        if (this.fileName != null || this.urlName != null) {
            if (lwsObject == null) {
                this.debugOutputLn(2, "About to load binary file for " + this.fileName);
                J3dLwoParser j3dLwoParser = null;
                switch (this.fileType) {
                    case 2: {
                        j3dLwoParser = new J3dLwoParser(this.fileName, this.debugPrinter.getValidOutput());
                        break;
                    }
                    case 1: {
                        j3dLwoParser = new J3dLwoParser(this.urlName, this.debugPrinter.getValidOutput());
                    }
                }
                j3dLwoParser.createJava3dGeometry();
                if (this.hasPivot) {
                    this.objectTransform.addChild((Node)this.pivotTransGroup);
                }
                if (j3dLwoParser.getJava3dShapeList() != null) {
                    this.shapeList = j3dLwoParser.getJava3dShapeList();
                    object = this.shapeList.elements();
                    while (object.hasMoreElements()) {
                        if (!this.hasPivot || this.pivotTransGroup == null) {
                            this.objectTransform.addChild((Node)((Shape3D)object.nextElement()));
                            continue;
                        }
                        this.pivotTransGroup.addChild((Node)((Shape3D)object.nextElement()));
                    }
                }
            } else {
                this.debugOutputLn(8, "Cloning shapes");
                Vector vector = lwsObject.getShapeList();
                object = vector.elements();
                while (object.hasMoreElements()) {
                    this.debugOutputLn(8, "   shape clone");
                    Shape3D shape3D = (Shape3D)object.nextElement();
                    Shape3D shape3D2 = (Shape3D)shape3D.cloneTree();
                    this.objectTransform.addChild((Node)shape3D2);
                }
            }
        }
        this.objectBehavior = new Vector();
        if (n != 0) {
            this.motion.createJava3dBehaviors(this.objectTransform);
            Behavior behavior = this.motion.getBehaviors();
            if (behavior != null) {
                this.objectBehavior.addElement(behavior);
            }
        }
    }

    Vector getShapeList() {
        return this.shapeList;
    }

    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    void printVals() {
        this.debugOutputLn(2, "  OBJECT vals: ");
        this.debugOutputLn(2, "   fileName = " + this.fileName);
        this.debugOutputLn(2, "   objName = " + this.objName);
        this.motion.printVals();
    }
}

