/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class KBCubicSplineSegment {
    static final double[] modRoot = new double[]{0.046910077, 0.230765345, 0.5, 0.769234655, 0.953089922};
    static final double[] modCoeff = new double[]{0.118463442, 0.239314335, 0.284444444, 0.239314335, 0.118463442};
    KBKeyFrame[] keyFrame = new KBKeyFrame[4];
    Point3f c0;
    Point3f c1;
    Point3f c2;
    Point3f c3;
    Point3f e0;
    Point3f e1;
    Point3f e2;
    Point3f e3;
    float h0;
    float h1;
    float h2;
    float h3;
    float p0;
    float p1;
    float p2;
    float p3;
    float b0;
    float b1;
    float b2;
    float b3;
    float one_minus_t_in;
    float one_minus_c_in;
    float one_minus_b_in;
    float one_plus_c_in;
    float one_plus_b_in;
    float ddb;
    float dda;
    float one_minus_t_out;
    float one_minus_c_out;
    float one_minus_b_out;
    float one_plus_c_out;
    float one_plus_b_out;
    float dsb;
    float dsa;
    float length;
    int linear;

    KBCubicSplineSegment() {
        this.length = 0.0f;
    }

    KBCubicSplineSegment(KBKeyFrame kBKeyFrame, KBKeyFrame kBKeyFrame2, KBKeyFrame kBKeyFrame3, KBKeyFrame kBKeyFrame4) {
        this.keyFrame[0] = new KBKeyFrame(kBKeyFrame);
        this.keyFrame[1] = new KBKeyFrame(kBKeyFrame2);
        this.keyFrame[2] = new KBKeyFrame(kBKeyFrame3);
        this.keyFrame[3] = new KBKeyFrame(kBKeyFrame4);
        if (kBKeyFrame3.linear == 1) {
            this.linear = 1;
        } else {
            this.linear = 0;
            this.computeCommonCoefficients(kBKeyFrame, kBKeyFrame2, kBKeyFrame3, kBKeyFrame4);
            this.computeHermiteCoefficients(kBKeyFrame, kBKeyFrame2, kBKeyFrame3, kBKeyFrame4);
        }
        this.length = this.computeLength(1.0f);
    }

    private void computeCommonCoefficients(KBKeyFrame kBKeyFrame, KBKeyFrame kBKeyFrame2, KBKeyFrame kBKeyFrame3, KBKeyFrame kBKeyFrame4) {
        float f = 1.0f - kBKeyFrame2.tension;
        float f2 = 1.0f - kBKeyFrame2.continuity;
        float f3 = 1.0f - kBKeyFrame2.bias;
        float f4 = 1.0f + kBKeyFrame2.continuity;
        float f5 = 1.0f + kBKeyFrame2.bias;
        this.ddb = f * f2 * f3;
        this.dda = f * f4 * f5;
        float f6 = 1.0f - kBKeyFrame3.tension;
        float f7 = 1.0f - kBKeyFrame3.continuity;
        float f8 = 1.0f - kBKeyFrame3.bias;
        float f9 = 1.0f + kBKeyFrame3.continuity;
        float f10 = 1.0f + kBKeyFrame3.bias;
        this.dsb = f * f4 * f3;
        this.dsa = f * f2 * f5;
    }

    private void computeHermiteCoefficients(KBKeyFrame kBKeyFrame, KBKeyFrame kBKeyFrame2, KBKeyFrame kBKeyFrame3, KBKeyFrame kBKeyFrame4) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        point3f.x = kBKeyFrame3.position.x - kBKeyFrame2.position.x;
        point3f.y = kBKeyFrame3.position.y - kBKeyFrame2.position.y;
        point3f.z = kBKeyFrame3.position.z - kBKeyFrame2.position.z;
        point3f2.x = kBKeyFrame3.scale.x - kBKeyFrame2.scale.x;
        point3f2.y = kBKeyFrame3.scale.y - kBKeyFrame2.scale.y;
        point3f2.z = kBKeyFrame3.scale.z - kBKeyFrame2.scale.z;
        float f8 = kBKeyFrame3.heading - kBKeyFrame2.heading;
        float f9 = kBKeyFrame3.pitch - kBKeyFrame2.pitch;
        float f10 = kBKeyFrame3.bank - kBKeyFrame2.bank;
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        if (kBKeyFrame.knot == kBKeyFrame2.knot) {
            f7 = 0.5f * (this.dda + this.ddb);
            point3f3.x = f7 * point3f.x;
            point3f3.y = f7 * point3f.y;
            point3f3.z = f7 * point3f.z;
            point3f4.x = f7 * point3f2.x;
            point3f4.y = f7 * point3f2.y;
            point3f4.z = f7 * point3f2.z;
            f6 = f7 * f8;
            f5 = f7 * f9;
            f4 = f7 * f10;
        } else {
            f7 = (kBKeyFrame2.knot - kBKeyFrame.knot) / (kBKeyFrame3.knot - kBKeyFrame.knot);
            point3f3.x = f7 * (this.ddb * point3f.x + this.dda * (kBKeyFrame2.position.x - kBKeyFrame.position.x));
            point3f3.y = f7 * (this.ddb * point3f.y + this.dda * (kBKeyFrame2.position.y - kBKeyFrame.position.y));
            point3f3.z = f7 * (this.ddb * point3f.z + this.dda * (kBKeyFrame2.position.z - kBKeyFrame.position.z));
            point3f4.x = f7 * (this.ddb * point3f2.x + this.dda * (kBKeyFrame2.scale.x - kBKeyFrame.scale.x));
            point3f4.y = f7 * (this.ddb * point3f2.y + this.dda * (kBKeyFrame2.scale.y - kBKeyFrame.scale.y));
            point3f4.z = f7 * (this.ddb * point3f2.z + this.dda * (kBKeyFrame2.scale.z - kBKeyFrame.scale.z));
            f6 = f7 * (this.ddb * f8 + this.dda * (kBKeyFrame2.heading - kBKeyFrame.heading));
            f5 = f7 * (this.ddb * f9 + this.dda * (kBKeyFrame2.pitch - kBKeyFrame.pitch));
            f4 = f7 * (this.ddb * f10 + this.dda * (kBKeyFrame2.bank - kBKeyFrame.bank));
        }
        Point3f point3f5 = new Point3f();
        Point3f point3f6 = new Point3f();
        if (kBKeyFrame3.knot == kBKeyFrame4.knot) {
            float f11 = 0.5f * (this.dsa + this.dsb);
            point3f5.x = f11 * point3f.x;
            point3f5.y = f11 * point3f.y;
            point3f5.z = f11 * point3f.z;
            point3f6.x = f11 * point3f2.x;
            point3f6.y = f11 * point3f2.y;
            point3f6.z = f11 * point3f2.z;
            f3 = f11 * f8;
            f2 = f11 * f9;
            f = f11 * f10;
        } else {
            float f12 = (kBKeyFrame3.knot - kBKeyFrame2.knot) / (kBKeyFrame4.knot - kBKeyFrame2.knot);
            point3f5.x = f12 * (this.dsb * (kBKeyFrame4.position.x - kBKeyFrame3.position.x) + this.dsa * point3f.x);
            point3f5.y = f12 * (this.dsb * (kBKeyFrame4.position.y - kBKeyFrame3.position.y) + this.dsa * point3f.y);
            point3f5.z = f12 * (this.dsb * (kBKeyFrame4.position.z - kBKeyFrame3.position.z) + this.dsa * point3f.z);
            point3f6.x = f12 * (this.dsb * (kBKeyFrame4.scale.x - kBKeyFrame3.scale.x) + this.dsa * point3f2.x);
            point3f6.y = f12 * (this.dsb * (kBKeyFrame4.scale.y - kBKeyFrame3.scale.y) + this.dsa * point3f2.y);
            point3f6.z = f12 * (this.dsb * (kBKeyFrame4.scale.z - kBKeyFrame3.scale.z) + this.dsa * point3f2.z);
            f3 = f12 * (this.dsb * (kBKeyFrame4.heading - kBKeyFrame3.heading) + this.dsa * f8);
            f2 = f12 * (this.dsb * (kBKeyFrame4.pitch - kBKeyFrame3.pitch) + this.dsa * f9);
            f = f12 * (this.dsb * (kBKeyFrame4.bank - kBKeyFrame3.bank) + this.dsa * f10);
        }
        this.c0 = new Point3f();
        this.c0.x = kBKeyFrame2.position.x;
        this.c0.y = kBKeyFrame2.position.y;
        this.c0.z = kBKeyFrame2.position.z;
        this.c1 = new Point3f();
        this.c1.x = point3f3.x;
        this.c1.y = point3f3.y;
        this.c1.z = point3f3.z;
        this.c2 = new Point3f();
        this.c2.x = 3.0f * point3f.x - 2.0f * point3f3.x - point3f5.x;
        this.c2.y = 3.0f * point3f.y - 2.0f * point3f3.y - point3f5.y;
        this.c2.z = 3.0f * point3f.z - 2.0f * point3f3.z - point3f5.z;
        this.c3 = new Point3f();
        this.c3.x = -2.0f * point3f.x + point3f3.x + point3f5.x;
        this.c3.y = -2.0f * point3f.y + point3f3.y + point3f5.y;
        this.c3.z = -2.0f * point3f.z + point3f3.z + point3f5.z;
        this.e0 = new Point3f();
        this.e0.x = kBKeyFrame2.scale.x;
        this.e0.y = kBKeyFrame2.scale.y;
        this.e0.z = kBKeyFrame2.scale.z;
        this.e1 = new Point3f();
        this.e1.x = point3f4.x;
        this.e1.y = point3f4.y;
        this.e1.z = point3f4.z;
        this.e2 = new Point3f();
        this.e2.x = 3.0f * point3f2.x - 2.0f * point3f4.x - point3f6.x;
        this.e2.y = 3.0f * point3f2.y - 2.0f * point3f4.y - point3f6.y;
        this.e2.z = 3.0f * point3f2.z - 2.0f * point3f4.z - point3f6.z;
        this.e3 = new Point3f();
        this.e3.x = -2.0f * point3f2.x + point3f4.x + point3f6.x;
        this.e3.y = -2.0f * point3f2.y + point3f4.y + point3f6.y;
        this.e3.z = -2.0f * point3f2.z + point3f4.z + point3f6.z;
        this.h0 = kBKeyFrame2.heading;
        this.p0 = kBKeyFrame2.pitch;
        this.b0 = kBKeyFrame2.bank;
        this.h1 = f6;
        this.p1 = f5;
        this.b1 = f4;
        this.h2 = 3.0f * f8 - 2.0f * f6 - f3;
        this.p2 = 3.0f * f9 - 2.0f * f5 - f2;
        this.b2 = 3.0f * f10 - 2.0f * f4 - f;
        this.h3 = -2.0f * f8 + f6 + f3;
        this.p3 = -2.0f * f9 + f5 + f2;
        this.b3 = -2.0f * f10 + f4 + f;
    }

    public float computeLength(float f) {
        float f2 = 0.0f;
        if (this.linear == 1) {
            f2 = f * this.keyFrame[2].position.distance(this.keyFrame[1].position);
        } else {
            int n = 5;
            int n2 = 0;
            while (n2 < n) {
                f2 += (float)modCoeff[n2] * this.computeSpeed(f * (float)modRoot[n2]);
                ++n2;
            }
            f2 *= f;
        }
        return f2;
    }

    private float computeSpeed(float f) {
        Point3f point3f = new Point3f();
        point3f.x = this.c1.x + f * (2.0f * this.c2.x + 3.0f * f * this.c3.x);
        point3f.y = this.c1.y + f * (2.0f * this.c2.y + 3.0f * f * this.c3.y);
        point3f.z = this.c1.z + f * (2.0f * this.c2.z + 3.0f * f * this.c3.z);
        return (float)Math.sqrt(point3f.x * point3f.x + point3f.y * point3f.y + point3f.z * point3f.z);
    }

    public void getInterpolatedScale(float f, Point3f point3f) {
        if (this.linear == 1) {
            point3f.x = this.keyFrame[1].scale.x + (this.keyFrame[2].scale.x - this.keyFrame[1].scale.x) * f;
            point3f.y = this.keyFrame[1].scale.y + (this.keyFrame[2].scale.y - this.keyFrame[1].scale.y) * f;
            point3f.z = this.keyFrame[1].scale.z + (this.keyFrame[2].scale.z - this.keyFrame[1].scale.z) * f;
        } else {
            point3f.x = this.e0.x + f * (this.e1.x + f * (this.e2.x + f * this.e3.x));
            point3f.y = this.e0.y + f * (this.e1.y + f * (this.e2.y + f * this.e3.y));
            point3f.z = this.e0.z + f * (this.e1.z + f * (this.e2.z + f * this.e3.z));
        }
    }

    public void getInterpolatedPosition(float f, Point3f point3f) {
        if (this.linear == 1) {
            point3f.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * f;
            point3f.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * f;
            point3f.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * f;
        } else {
            point3f.x = this.c0.x + f * (this.c1.x + f * (this.c2.x + f * this.c3.x));
            point3f.y = this.c0.y + f * (this.c1.y + f * (this.c2.y + f * this.c3.y));
            point3f.z = this.c0.z + f * (this.c1.z + f * (this.c2.z + f * this.c3.z));
        }
    }

    public void getInterpolatedPositionVector(float f, Vector3f vector3f) {
        if (this.linear == 1) {
            vector3f.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * f;
            vector3f.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * f;
            vector3f.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * f;
        } else {
            vector3f.x = this.c0.x + f * (this.c1.x + f * (this.c2.x + f * this.c3.x));
            vector3f.y = this.c0.y + f * (this.c1.y + f * (this.c2.y + f * this.c3.y));
            vector3f.z = this.c0.z + f * (this.c1.z + f * (this.c2.z + f * this.c3.z));
        }
    }

    public float getInterpolatedHeading(float f) {
        float f2 = this.linear == 1 ? this.keyFrame[1].heading + (this.keyFrame[2].heading - this.keyFrame[1].heading) * f : this.h0 + f * (this.h1 + f * (this.h2 + f * this.h3));
        return f2;
    }

    public float getInterpolatedPitch(float f) {
        float f2 = this.linear == 1 ? this.keyFrame[1].pitch + (this.keyFrame[2].pitch - this.keyFrame[1].pitch) * f : this.p0 + f * (this.p1 + f * (this.p2 + f * this.p3));
        return f2;
    }

    public float getInterpolatedBank(float f) {
        float f2 = this.linear == 1 ? this.keyFrame[1].bank + (this.keyFrame[2].bank - this.keyFrame[1].bank) * f : this.b0 + f * (this.b1 + f * (this.b2 + f * this.b3));
        return f2;
    }

    public float getInterpolatedValue(float f) {
        return this.computeLength(f) / this.length;
    }
}

