/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.DepthComponentFloat;
import javax.media.j3d.SceneGraphObject;

public class DepthComponentFloatState
extends NodeComponentState {
    private int height;
    private int width;

    public DepthComponentFloatState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        float[] fArray = new float[this.width * this.height];
        ((DepthComponentFloat)this.node).getDepthData(fArray);
        int n = 0;
        while (n < fArray.length) {
            dataOutput.writeFloat(fArray[n]);
            ++n;
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        float[] fArray = new float[this.width * this.height];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = dataInput.readFloat();
            ++n;
        }
        ((DepthComponentFloat)this.node).setDepthData(fArray);
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeInt(this.width);
        dataOutput.writeInt(this.height);
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.width = dataInput.readInt();
        this.height = dataInput.readInt();
    }

    public SceneGraphObject createNode(Class clazz) {
        return this.createNode(clazz, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.width), new Integer(this.height)});
    }

    protected SceneGraphObject createNode() {
        return new DepthComponentFloat(this.width, this.height);
    }
}

