/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Group;
import javax.media.j3d.ModelClip;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Vector4d;

public class ModelClipState
extends LeafState {
    private int[] scopes;
    private int influencingBoundingLeaf;

    public ModelClipState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.scopes = new int[((ModelClip)this.node).numScopes()];
            int n = 0;
            while (n < this.scopes.length) {
                this.scopes[n] = controller.getSymbolTable().addReference((SceneGraphObject)((ModelClip)this.node).getScope(n));
                ++n;
            }
            this.influencingBoundingLeaf = controller.getSymbolTable().addReference((SceneGraphObject)((ModelClip)this.node).getInfluencingBoundingLeaf());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        boolean[] blArray = new boolean[6];
        ((ModelClip)this.node).getEnables(blArray);
        dataOutput.writeInt(this.scopes.length);
        int n = 0;
        while (n < this.scopes.length) {
            dataOutput.writeInt(this.scopes[n]);
            ++n;
        }
        dataOutput.writeInt(this.influencingBoundingLeaf);
        this.control.writeBounds(dataOutput, ((ModelClip)this.node).getInfluencingBounds());
        Vector4d[] vector4dArray = new Vector4d[6];
        ((ModelClip)this.node).getPlanes(vector4dArray);
        int n2 = 0;
        while (n2 < 6) {
            dataOutput.writeBoolean(blArray[n2]);
            this.control.writeVector4d(dataOutput, vector4dArray[n2]);
            ++n2;
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.scopes = new int[dataInput.readInt()];
        int n = 0;
        while (n < this.scopes.length) {
            this.scopes[n] = dataInput.readInt();
            ++n;
        }
        this.influencingBoundingLeaf = dataInput.readInt();
        ((ModelClip)this.node).setInfluencingBounds(this.control.readBounds(dataInput));
        boolean[] blArray = new boolean[6];
        Vector4d[] vector4dArray = new Vector4d[6];
        int n2 = 0;
        while (n2 < 6) {
            blArray[n2] = dataInput.readBoolean();
            vector4dArray[n2] = this.control.readVector4d(dataInput);
            ++n2;
        }
        ((ModelClip)this.node).setEnables(blArray);
        ((ModelClip)this.node).setPlanes(vector4dArray);
    }

    public void buildGraph() {
        int n = 0;
        while (n < this.scopes.length) {
            ((ModelClip)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[n]));
            ++n;
        }
        ((ModelClip)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.influencingBoundingLeaf));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new ModelClip();
    }
}

