/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;

class TextFormControl
extends FormControl {
    private String[] _value = new String[1];
    private String[] _defaultValue;

    public TextFormControl(WebForm form, Node node, String defaultValue) {
        super(form, node);
        this._defaultValue = new String[]{defaultValue};
    }

    public String[] getValues() {
        return this._value[0] != null ? this._value : this._defaultValue;
    }

    public boolean isTextControl() {
        return true;
    }

    protected ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (!this.isDisabled() && this.getName().length() > 0) {
            processor.addParameter(this.getName(), this.getValues()[0], characterSet);
        }
    }

    void claimValue(List values) {
        if (this.isReadOnly()) {
            return;
        }
        String oldValue = this.getValues()[0];
        if (values.isEmpty()) {
            this._value[0] = "";
        } else {
            this._value[0] = (String)values.get(0);
            values.remove(0);
        }
        if (!oldValue.equals(this._value[0])) {
            this.sendOnChangeEvent();
        }
    }

    void reset() {
        this._value[0] = null;
    }

    void claimRequiredValues(List values) {
        if (this.isReadOnly()) {
            this.claimValueIsRequired(values);
        }
    }

    protected void claimValueIsRequired(List values) {
        this.claimValueIsRequired(values, this._defaultValue[0]);
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
            super(TextFormControl.this);
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("value")) {
                return TextFormControl.this.getValues()[0];
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("value")) {
                String string = value.toString();
                ((TextFormControl)TextFormControl.this)._defaultValue[0] = string;
                ((TextFormControl)TextFormControl.this)._value[0] = string;
            } else {
                super.set(propertyName, value);
            }
        }
    }
}

