/**
 *  Copyright (c) 2011-2013 Terracotta, Inc.
 *  Copyright (c) 2011-2013 Oracle and/or its affiliates.
 *
 *  All rights reserved. Use is subject to license terms.
 */

package javax.cache.annotation;

import java.lang.annotation.Annotation;

/**
 * Runtime information about an intercepted method invocation for a method
 * annotated with {@link CacheResult}, {@link CachePut}, {@link CacheRemove},
 * or {@link CacheRemoveAll}
 * <p>
 * Used with {@link CacheResolver#resolveCache(CacheInvocationContext)} to
 * determine the {@link javax.cache.Cache} to use at runtime for the method
 * invocation.
 *
 * @param <A> The type of annotation this context information is for. One of
 *            {@link CacheResult}, {@link CachePut}, {@link CacheRemove}, or {@link
 *            CacheRemoveAll}.
 * @author Eric Dalquist
 * @see CacheResolver
 */
public interface CacheInvocationContext<A extends Annotation>
    extends CacheMethodDetails<A> {

  /**
   * @return The object the intercepted method was invoked on.
   */
  Object getTarget();

  /**
   * Returns a clone of the array of all method parameters.
   *
   * @return An array of all parameters for the annotated method
   */
  CacheInvocationParameter[] getAllParameters();

  /**
   * Return an object of the specified type to allow access to the
   * provider-specific API. If the provider's
   * implementation does not support the specified class, the {@link
   * IllegalArgumentException} is thrown.
   *
   * @param cls the class of the object to be returned. This is normally either the
   *            underlying implementation class or an interface that it implements.
   * @return an instance of the specified class
   * @throws IllegalArgumentException if the provider doesn't support the specified
   *            class.
   */
  <T> T unwrap(java.lang.Class<T> cls);
}
