/**
 * Copyright 2011-2016 Terracotta, Inc.
 * Copyright 2011-2016 Oracle America Incorporated
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package javax.cache.annotation;

import java.io.Serializable;

/**
 * A {@link Serializable}, immutable, thread-safe object that is used as a key,
 * automatically generated by a {@link CacheKeyGenerator}.
 * <p>
 * The implementation MUST follow the Java contract for {@link Object#hashCode()}
 * and {@link Object#equals(Object)} to ensure correct behavior.
 * <p>
 * It is recommended that implementations also override {@link Object#toString()}
 * and provide a human-readable string representation of the key.
 *
 * @author Eric Dalquist
 * @see CacheKeyGenerator
 * @since 1.0
 */
public interface GeneratedCacheKey extends Serializable {

  /**
   * The immutable hash code of the cache key.
   *
   * @return The hash code of the object
   * @see Object#hashCode()
   */
  @Override
  int hashCode();

  /**
   * Compare this {@link GeneratedCacheKey} with another. If the two objects
   * are equal their {@link #hashCode()} values MUST be equal as well.
   *
   * @param object The other object to compare to.
   * @return true if the objects are equal
   * @see Object#equals(Object)
   */
  @Override
  boolean equals(Object object);
}
