/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.event;

import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.processor.EntryProcessor;
import org.jsr107.tck.event.CacheEntryListenerClient;
import org.jsr107.tck.event.CacheEntryListenerServer;
import org.jsr107.tck.processor.MultiArgumentHandlingEntryProcessor;
import org.jsr107.tck.processor.RemoveEntryProcessor;
import org.jsr107.tck.processor.SetEntryProcessor;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class CacheListenerTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheListenerTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };
    private CacheEntryListenerServer cacheEntryListenerServer;

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> extraSetup(MutableConfiguration<Long, String> configuration) {
        this.cacheEntryListenerServer = new CacheEntryListenerServer(10011, Long.class, String.class);
        try {
            this.cacheEntryListenerServer.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.listener = new CacheTestSupport.MyCacheEntryListener();
        this.cacheEntryListenerServer.addCacheEventListener((CacheEntryListener)this.listener);
        CacheEntryListenerClient clientListener = new CacheEntryListenerClient(this.cacheEntryListenerServer.getInetAddress(), this.cacheEntryListenerServer.getPort());
        this.listenerConfiguration = new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf((Serializable)clientListener), null, true, true);
        return configuration.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)this.listenerConfiguration);
    }

    @After
    public void onAfterEachTest() {
        String cacheName = this.cache.getName();
        this.cache.getCacheManager().destroyCache(cacheName);
        this.cacheEntryListenerServer.close();
        this.cacheEntryListenerServer = null;
        this.cache = null;
    }

    @Test
    public void testCacheEntryListener() {
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
        Assert.assertEquals((long)0L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        this.cache.put((Object)1L, (Object)"Sooty");
        Assert.assertEquals((long)1L, (long)this.listener.getCreated());
        Assert.assertEquals((long)0L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        HashMap<Long, String> entries = new HashMap<Long, String>();
        entries.put(2L, "Lucky");
        entries.put(3L, "Prince");
        this.cache.putAll(entries);
        Assert.assertEquals((long)3L, (long)this.listener.getCreated());
        Assert.assertEquals((long)0L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        this.cache.put((Object)1L, (Object)"Sooty");
        Assert.assertEquals((long)3L, (long)this.listener.getCreated());
        Assert.assertEquals((long)1L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        this.cache.putAll(entries);
        Assert.assertEquals((long)3L, (long)this.listener.getCreated());
        Assert.assertEquals((long)3L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        this.cache.getAndPut((Object)4L, (Object)"Cody");
        Assert.assertEquals((long)4L, (long)this.listener.getCreated());
        Assert.assertEquals((long)3L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        this.cache.getAndPut((Object)4L, (Object)"Cody");
        Assert.assertEquals((long)4L, (long)this.listener.getCreated());
        Assert.assertEquals((long)4L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        String value = (String)this.cache.get((Object)1L);
        Assert.assertEquals((long)4L, (long)this.listener.getCreated());
        Assert.assertEquals((long)4L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        MultiArgumentHandlingEntryProcessor multiArgEP = new MultiArgumentHandlingEntryProcessor((Object)value);
        String result = (String)this.cache.invoke((Object)1L, (EntryProcessor)multiArgEP, new Object[]{"These", "are", "arguments", 1L});
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((long)4L, (long)this.listener.getCreated());
        Assert.assertEquals((long)4L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        result = (String)this.cache.invoke((Object)1L, (EntryProcessor)new SetEntryProcessor((Object)"Zoot"), new Object[0]);
        Assert.assertEquals((Object)"Zoot", (Object)result);
        Assert.assertEquals((long)4L, (long)this.listener.getCreated());
        Assert.assertEquals((long)5L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        result = (String)this.cache.invoke((Object)1L, (EntryProcessor)new RemoveEntryProcessor(), new Object[0]);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)4L, (long)this.listener.getCreated());
        Assert.assertEquals((long)5L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)1L, (long)this.listener.getRemoved());
        result = (String)this.cache.invoke((Object)1L, (EntryProcessor)new SetEntryProcessor((Object)"Moose"), new Object[0]);
        Assert.assertEquals((Object)"Moose", (Object)result);
        Assert.assertEquals((long)5L, (long)this.listener.getCreated());
        Assert.assertEquals((long)5L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)1L, (long)this.listener.getRemoved());
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        Assert.assertEquals((long)5L, (long)this.listener.getCreated());
        Assert.assertEquals((long)5L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)5L, (long)this.listener.getRemoved());
    }

    @Test
    public void testBrokenCacheEntryListener() {
        String result;
        this.cacheEntryListenerServer.removeCacheEventListener((CacheEntryListener)this.listener);
        this.cache.deregisterCacheEntryListener((CacheEntryListenerConfiguration)this.listenerConfiguration);
        MyBrokenCacheEntryListener brokenListener = new MyBrokenCacheEntryListener();
        CacheEntryListenerClient clientListener = new CacheEntryListenerClient(this.cacheEntryListenerServer.getInetAddress(), this.cacheEntryListenerServer.getPort());
        this.listenerConfiguration = new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf((Serializable)clientListener), null, true, true);
        this.cache.registerCacheEntryListener((CacheEntryListenerConfiguration)this.listenerConfiguration);
        this.cacheEntryListenerServer.addCacheEventListener(brokenListener);
        try {
            this.cache.put((Object)1L, (Object)"Sooty");
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
        HashMap<Long, String> entries = new HashMap<Long, String>();
        entries.put(2L, "Lucky");
        entries.put(3L, "Prince");
        try {
            this.cache.put((Object)1L, (Object)"Sooty");
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
        try {
            this.cache.putAll(entries);
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
        try {
            this.cache.put((Object)1L, (Object)"Sooty");
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
        try {
            this.cache.putAll(entries);
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
        try {
            this.cache.getAndPut((Object)4L, (Object)"Cody");
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
        try {
            this.cache.remove((Object)4L);
        }
        catch (IOError e) {
            // empty catch block
        }
        try {
            this.cache.remove((Object)4L);
        }
        catch (IOError e) {
            // empty catch block
        }
        String value = (String)this.cache.get((Object)1L);
        MultiArgumentHandlingEntryProcessor multiArgEP = new MultiArgumentHandlingEntryProcessor(null);
        try {
            result = (String)this.cache.invoke((Object)1L, (EntryProcessor)multiArgEP, new Object[]{"These", "are", "arguments", 1L});
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
        try {
            result = (String)this.cache.invoke((Object)1L, (EntryProcessor)new SetEntryProcessor((Object)"Zoot"), new Object[0]);
            Iterator iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        catch (CacheEntryListenerException e) {
            // empty catch block
        }
    }

    @Test
    public void testCacheClearListener() {
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
        Assert.assertEquals((long)0L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        this.cache.put((Object)1L, (Object)"Sooty");
        Assert.assertEquals((long)1L, (long)this.listener.getCreated());
        Assert.assertEquals((long)0L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
        this.cache.clear();
        Assert.assertEquals((long)1L, (long)this.listener.getCreated());
        Assert.assertEquals((long)0L, (long)this.listener.getUpdated());
        Assert.assertEquals((long)0L, (long)this.listener.getRemoved());
    }

    @Test
    public void testFilteredListener() throws InterruptedException {
        this.cacheEntryListenerServer.removeCacheEventListener((CacheEntryListener)this.listener);
        this.cache.deregisterCacheEntryListener((CacheEntryListenerConfiguration)this.listenerConfiguration);
        CacheEntryListenerClient clientListener = new CacheEntryListenerClient(this.cacheEntryListenerServer.getInetAddress(), this.cacheEntryListenerServer.getPort());
        CacheTestSupport.MyCacheEntryListener filteredListener = new CacheTestSupport.MyCacheEntryListener();
        MutableCacheEntryListenerConfiguration listenerConfiguration = new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf((Serializable)clientListener), FactoryBuilder.factoryOf((Serializable)new MyCacheEntryEventFilter()), true, true);
        this.cache.registerCacheEntryListener((CacheEntryListenerConfiguration)listenerConfiguration);
        this.cacheEntryListenerServer.addCacheEventListener(filteredListener);
        Assert.assertEquals((long)0L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)0L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)0L, (long)filteredListener.getRemoved());
        this.cache.put((Object)1L, (Object)"Sooty");
        Assert.assertEquals((long)1L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)0L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)0L, (long)filteredListener.getRemoved());
        HashMap<Long, String> entries = new HashMap<Long, String>();
        entries.put(2L, "Lucky");
        entries.put(3L, "Bryn");
        this.cache.putAll(entries);
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)0L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)0L, (long)filteredListener.getRemoved());
        this.cache.put((Object)1L, (Object)"Zyn");
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)0L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)0L, (long)filteredListener.getRemoved());
        this.cache.remove((Object)2L);
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)0L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        this.cache.replace((Object)1L, (Object)"Fred");
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)1L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        this.cache.replace((Object)3L, (Object)"Bryn", (Object)"Sooty");
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)2L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        this.cache.get((Object)1L);
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)2L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        this.cache.containsKey((Object)1L);
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)2L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        for (Cache.Entry entry : this.cache) {
            String value = (String)entry.getValue();
            System.out.println(value);
        }
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)2L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        this.cache.getAndPut((Object)1L, (Object)"Pistachio");
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)3L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        HashSet<Long> keys = new HashSet<Long>();
        keys.add(1L);
        this.cache.getAll(keys);
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)3L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        this.cache.getAndReplace((Object)1L, (Object)"Prince");
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)4L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)1L, (long)filteredListener.getRemoved());
        this.cache.getAndRemove((Object)1L);
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)4L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)2L, (long)filteredListener.getRemoved());
        Assert.assertEquals((long)2L, (long)filteredListener.getCreated());
        Assert.assertEquals((long)4L, (long)filteredListener.getUpdated());
        Assert.assertEquals((long)2L, (long)filteredListener.getRemoved());
    }

    @Test
    public void testDynamicRegistration() {
        Assert.assertEquals((long)1L, (long)this.getConfigurationCacheEntryListenerConfigurationSize(this.cache));
        CacheTestSupport.MyCacheEntryListener secondListener = new CacheTestSupport.MyCacheEntryListener();
        MutableCacheEntryListenerConfiguration listenerConfiguration = new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf(secondListener), null, false, true);
        this.cache.registerCacheEntryListener((CacheEntryListenerConfiguration)listenerConfiguration);
        Assert.assertEquals((long)2L, (long)this.getConfigurationCacheEntryListenerConfigurationSize(this.cache));
        CompleteConfiguration cacheConfig = (CompleteConfiguration)this.cache.getConfiguration(CompleteConfiguration.class);
        for (CacheEntryListenerConfiguration config : cacheConfig.getCacheEntryListenerConfigurations()) {
            config.hashCode();
            config.isOldValueRequired();
            config.isSynchronous();
        }
        try {
            this.cache.registerCacheEntryListener((CacheEntryListenerConfiguration)listenerConfiguration);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test(expected=NullPointerException.class)
    public void testDeregistration_nullParameter() {
        this.cache.deregisterCacheEntryListener(null);
    }

    private int getConfigurationCacheEntryListenerConfigurationSize(Cache cache) {
        int i = 0;
        CompleteConfiguration cacheConfig = (CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class);
        for (CacheEntryListenerConfiguration listenerConfig : cacheConfig.getCacheEntryListenerConfigurations()) {
            ++i;
        }
        return i;
    }

    @Test
    public void testDeregistration() {
        Assert.assertEquals((long)1L, (long)this.getConfigurationCacheEntryListenerConfigurationSize(this.cache));
        CacheTestSupport.MyCacheEntryListener secondListener = new CacheTestSupport.MyCacheEntryListener();
        MutableCacheEntryListenerConfiguration secondListenerConfiguration = new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf(secondListener), null, false, true);
        this.cache.registerCacheEntryListener((CacheEntryListenerConfiguration)secondListenerConfiguration);
        Assert.assertEquals((long)2L, (long)this.getConfigurationCacheEntryListenerConfigurationSize(this.cache));
        this.cache.deregisterCacheEntryListener((CacheEntryListenerConfiguration)secondListenerConfiguration);
        Assert.assertEquals((long)1L, (long)this.getConfigurationCacheEntryListenerConfigurationSize(this.cache));
        this.cache.deregisterCacheEntryListener((CacheEntryListenerConfiguration)secondListenerConfiguration);
        Assert.assertEquals((long)1L, (long)this.getConfigurationCacheEntryListenerConfigurationSize(this.cache));
        this.cache.deregisterCacheEntryListener((CacheEntryListenerConfiguration)this.listenerConfiguration);
        Assert.assertEquals((long)0L, (long)this.getConfigurationCacheEntryListenerConfigurationSize(this.cache));
    }

    static class MyBrokenCacheEntryListener<K, V>
    implements CacheEntryCreatedListener<K, V>,
    CacheEntryUpdatedListener<K, V>,
    CacheEntryExpiredListener<K, V>,
    CacheEntryRemovedListener<K, V>,
    Serializable {
        AtomicInteger created = new AtomicInteger();
        AtomicInteger updated = new AtomicInteger();
        AtomicInteger removed = new AtomicInteger();
        ArrayList<CacheEntryEvent<K, V>> entries = new ArrayList();

        MyBrokenCacheEntryListener() {
        }

        public int getCreated() {
            return this.created.get();
        }

        public int getUpdated() {
            return this.updated.get();
        }

        public int getRemoved() {
            return this.removed.get();
        }

        public ArrayList<CacheEntryEvent<K, V>> getEntries() {
            return this.entries;
        }

        public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            Iterator<CacheEntryEvent<K, V>> i$ = events.iterator();
            if (i$.hasNext()) {
                CacheEntryEvent<? extends K, ? extends V> event = i$.next();
                Assert.assertEquals((Object)EventType.CREATED, (Object)event.getEventType());
                throw new CacheEntryListenerException("I broke");
            }
        }

        public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        }

        public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            Iterator<CacheEntryEvent<K, V>> i$ = events.iterator();
            if (i$.hasNext()) {
                CacheEntryEvent<? extends K, ? extends V> event = i$.next();
                Assert.assertEquals((Object)EventType.REMOVED, (Object)event.getEventType());
                throw new IOError(null);
            }
        }

        public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            Iterator<CacheEntryEvent<K, V>> i$ = events.iterator();
            if (i$.hasNext()) {
                CacheEntryEvent<? extends K, ? extends V> event = i$.next();
                Assert.assertEquals((Object)EventType.UPDATED, (Object)event.getEventType());
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class MyCacheEntryEventFilter
    implements CacheEntryEventFilter<Long, String>,
    Serializable {
        private MyCacheEntryEventFilter() {
        }

        public boolean evaluate(CacheEntryEvent<? extends Long, ? extends String> event) throws CacheEntryListenerException {
            return ((String)event.getValue()).contains("a") || ((String)event.getValue()).contains("e") || ((String)event.getValue()).contains("i") || ((String)event.getValue()).contains("o") || ((String)event.getValue()).contains("u");
        }
    }
}

