/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import javax.cache.Cache;
import javax.cache.integration.CacheWriter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.CacheWriterClient;
import org.jsr107.tck.integration.CacheWriterServer;
import org.jsr107.tck.integration.FailingCacheWriter;
import org.jsr107.tck.integration.RecordingCacheWriter;
import org.junit.Assert;
import org.junit.Test;

public class CacheWriterClientServerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWriteFromServerWithClient() {
        RecordingCacheWriter recordingCacheWriter = new RecordingCacheWriter();
        try (CacheWriterServer serverCacheWriter = new CacheWriterServer(10000, (CacheWriter)recordingCacheWriter);){
            serverCacheWriter.open();
            CacheWriterClient clientCacheWriter = new CacheWriterClient(serverCacheWriter.getInetAddress(), serverCacheWriter.getPort());
            Entry<String, String> entry = new Entry<String, String>("hello", "gudday");
            clientCacheWriter.write(entry);
            String writtenValue = (String)recordingCacheWriter.get((Object)"hello");
            Assert.assertThat((Object)writtenValue, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Assert.assertThat((Object)writtenValue, (Matcher)CoreMatchers.is((Object)"gudday"));
            Assert.assertThat((Object)recordingCacheWriter.hasWritten((Object)"hello"), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRethrowExceptions() {
        FailingCacheWriter failingCacheWriter = new FailingCacheWriter();
        try (CacheWriterServer serverCacheWriter = new CacheWriterServer(10000, (CacheWriter)failingCacheWriter);){
            serverCacheWriter.open();
            CacheWriterClient clientCacheWriter = new CacheWriterClient(serverCacheWriter.getInetAddress(), serverCacheWriter.getPort());
            Entry<String, String> entry = new Entry<String, String>("hello", "gudday");
            clientCacheWriter.write(entry);
            Assert.fail((String)"An UnsupportedOperationException should have been thrown");
        }
    }

    private static class Entry<K, V>
    implements Cache.Entry<K, V> {
        private K key;
        private V value;

        public Entry(K key, V value) {
            this.setKey(key);
            this.setValue(value);
        }

        public K getKey() {
            throw new UnsupportedOperationException("not implemented");
        }

        public V getValue() {
            throw new UnsupportedOperationException("not implemented");
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void setKey(K key) {
            this.key = key;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

