/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.management;

import java.util.HashMap;
import java.util.Iterator;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jsr107.tck.processor.GetEntryProcessor;
import org.jsr107.tck.processor.NoOpEntryProcessor;
import org.jsr107.tck.processor.RemoveEntryProcessor;
import org.jsr107.tck.processor.SetEntryProcessor;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class CacheMBStatisticsBeanTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheMBStatisticsBeanTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
        this.cache.getCacheManager().enableStatistics(this.cache.getName(), true);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> extraSetup(MutableConfiguration<Long, String> configuration) {
        return configuration.setStoreByValue(true);
    }

    @Test
    public void testCacheStatisticsAllZero() throws Exception {
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime"));
    }

    @Test
    public void testCacheStatistics() throws Exception {
        float DELTA = 1.0f;
        this.cache.put((Object)1L, (Object)"Sooty");
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        HashMap<Long, String> entries = new HashMap<Long, String>();
        entries.put(2L, "Lucky");
        entries.put(3L, "Prince");
        this.cache.putAll(entries);
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.put((Object)1L, (Object)"Sooty");
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)4L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.putAll(entries);
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)6L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.getAndPut((Object)4L, (Object)"Cody");
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)7L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.getAndPut((Object)4L, (Object)"Cody");
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)8L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        String value = (String)this.cache.get((Object)1L);
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((float)66.0f, (float)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")).floatValue(), (float)1.0f);
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((float)33.0f, (float)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")).floatValue(), (float)1.0f);
        Assert.assertEquals((Object)8L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        value = (String)this.cache.get((Object)1234324324L);
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)8L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1234324324L));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)8L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        junit.framework.Assert.assertTrue((boolean)this.cache.remove((Object)1L));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)8L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        junit.framework.Assert.assertFalse((boolean)this.cache.remove((Object)1L));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)8L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.put((Object)1L, (Object)"Sooty");
        junit.framework.Assert.assertTrue((boolean)this.cache.remove((Object)1L, (Object)"Sooty"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((float)60.0f, (float)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")).floatValue(), (float)1.0f);
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((float)40.0f, (float)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")).floatValue(), (float)1.0f);
        Assert.assertEquals((Object)9L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        junit.framework.Assert.assertFalse((boolean)this.cache.remove((Object)1L, (Object)"Sooty"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)9L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.clear();
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)9L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.removeAll();
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)9L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        entries.put(21L, "Trinity");
        this.cache.putAll(entries);
        this.cache.removeAll();
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)12L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)5L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.putAll(entries);
        entries.remove(21L);
        this.cache.removeAll(entries.keySet());
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)15L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)7L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        this.cache.removeAll(entries.keySet());
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)3L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)15L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)7L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorNoOp() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        this.cache.invoke((Object)1L, (EntryProcessor)new NoOpEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1L, (EntryProcessor)new NoOpEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1000L, (EntryProcessor)new NoOpEntryProcessor(), new Object[0]);
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(66.65f)));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Float.valueOf(33.34f)));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorGet() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        String result = (String)this.cache.invoke((Object)1L, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1L, (EntryProcessor)new NoOpEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1000L, (EntryProcessor)new NoOpEntryProcessor(), new Object[0]);
        Assert.assertEquals((Object)result, (Object)"Sooty");
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(66.65f)));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Float.valueOf(33.34f)));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorUpdate() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        String result = (String)this.cache.invoke((Object)1L, (EntryProcessor)new SetEntryProcessor((Object)"Trinity"), new Object[0]);
        Assert.assertEquals((Object)result, (Object)"Trinity");
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)2L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorRemove() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        String result = (String)this.cache.invoke((Object)1L, (EntryProcessor)new RemoveEntryProcessor(true), new Object[0]);
        Assert.assertEquals((Object)result, (Object)"Sooty");
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
    }

    @Test
    public void testIterateAndRemove() throws Exception {
        for (long i = 0L; i < 100L; ++i) {
            String word = "";
            word = word + " " + "Trinity";
            this.cache.put((Object)i, (Object)word);
        }
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        Assert.assertEquals((Object)100L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
        Assert.assertEquals((Object)100L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheGets"));
        Assert.assertEquals((Object)100L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)100L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
        Assert.assertThat((Object)((Float)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
    }

    @Test
    public void testGetAndReplace() throws Exception {
        long hitCount = 0L;
        long missCount = 0L;
        long putCount = 0L;
        String result = (String)this.cache.getAndReplace((Object)1L, (Object)"MissingNoReplace");
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
        Assert.assertEquals(null, (Object)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
        this.cache.put((Object)1L, (Object)"Sooty");
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)(++putCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        result = (String)this.cache.getAndReplace((Object)2L, (Object)"InvalidReplace");
        Assert.assertEquals(null, (Object)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)2L));
        result = (String)this.cache.getAndReplace((Object)1L, (Object)"Replaced");
        Assert.assertEquals((Object)"Sooty", (Object)result);
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)(++hitCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)(++putCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
    }

    @Test
    public void testReplace() throws Exception {
        long hitCount = 0L;
        long missCount = 0L;
        long putCount = 0L;
        boolean result = this.cache.replace((Object)1L, (Object)"MissingNoReplace");
        junit.framework.Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
        this.cache.put((Object)1L, (Object)"Sooty");
        ++putCount;
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        result = this.cache.replace((Object)2L, (Object)"InvalidReplace");
        junit.framework.Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)2L));
        result = this.cache.replace((Object)1L, (Object)"Replaced");
        junit.framework.Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)(++hitCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)(++putCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
    }

    @Test
    public void testConditionalReplace() throws Exception {
        long hitCount = 0L;
        long missCount = 0L;
        long putCount = 0L;
        boolean result = this.cache.replace((Object)1L, (Object)"MissingNoReplace", (Object)"NewValue");
        junit.framework.Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
        this.cache.put((Object)1L, (Object)"Sooty");
        ++putCount;
        Assert.assertEquals((Object)1L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        result = this.cache.replace((Object)1L, (Object)"Sooty", (Object)"Replaced");
        junit.framework.Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)(++hitCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)(++putCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        result = this.cache.replace((Object)1L, (Object)"Sooty", (Object)"InvalidReplace");
        junit.framework.Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)(++hitCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
    }

    @Test
    public void testPutIfAbsent() throws Exception {
        long hitCount = 0L;
        long missCount = 0L;
        long putCount = 0L;
        boolean result = this.cache.putIfAbsent((Object)1L, (Object)"succeeded");
        junit.framework.Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)(++putCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        result = this.cache.putIfAbsent((Object)1L, (Object)"succeeded");
        junit.framework.Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
    }

    @Test
    public void testGetAndRemove() throws Exception {
        long hitCount = 0L;
        long missCount = 0L;
        long removeCount = 0L;
        String result = (String)this.cache.getAndRemove((Object)1L);
        Assert.assertEquals(null, (Object)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)removeCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
        this.cache.put((Object)1L, (Object)"added");
        result = (String)this.cache.getAndRemove((Object)1L);
        Assert.assertEquals((Object)"added", (Object)result);
        Assert.assertEquals((Object)(++removeCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)(++hitCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
    }

    @Test
    public void testExpiryOnCreation() throws Exception {
        CacheManager mgr = this.cache.getCacheManager();
        mgr.destroyCache(this.cache.getName());
        MutableConfiguration config = new MutableConfiguration();
        config.setStatisticsEnabled(true);
        config.setTypes(Long.class, String.class);
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf(ExpireOnCreationPolicy.class));
        this.cache = mgr.createCache(this.getTestCacheName(), (Configuration)config);
        this.cache.put((Object)1L, (Object)"hello");
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        HashMap<Long, String> map = new HashMap<Long, String>();
        map.put(2L, "goodbye");
        map.put(3L, "world");
        this.cache.putAll(map);
        Assert.assertEquals((Object)0L, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
    }

    public static class ExpireOnCreationPolicy
    implements ExpiryPolicy {
        public Duration getExpiryForCreation() {
            return Duration.ZERO;
        }

        public Duration getExpiryForAccess() {
            return Duration.ZERO;
        }

        public Duration getExpiryForUpdate() {
            return Duration.ZERO;
        }
    }
}

