/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.integration.CacheLoader;

public class RecordingCacheLoader<K>
implements CacheLoader<K, K>,
AutoCloseable {
    private ConcurrentHashMap<K, K> loaded = new ConcurrentHashMap();
    private AtomicInteger loadCount = new AtomicInteger(0);

    public K load(K key) {
        if (key == null) {
            throw new NullPointerException("Attempted to load a null key!");
        }
        this.loaded.put(key, key);
        this.loadCount.incrementAndGet();
        return key;
    }

    public Map<K, K> loadAll(Iterable<? extends K> keys) {
        HashMap<K, K> map = new HashMap<K, K>();
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException("Attempted to load a null key!");
            }
            map.put(key, key);
        }
        this.loaded.putAll(map);
        this.loadCount.addAndGet(map.size());
        return map;
    }

    public int getLoadCount() {
        return this.loadCount.get();
    }

    public boolean hasLoaded(K key) {
        return key == null ? false : this.loaded.containsKey(key);
    }

    @Override
    public void close() throws Exception {
    }
}

