/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.support;

import java.io.Serializable;
import java.net.InetAddress;
import org.jsr107.tck.support.Client;

public class CacheClient
implements AutoCloseable,
Serializable {
    protected InetAddress address;
    protected int port;
    protected transient Client client;

    protected CacheClient(InetAddress address, int port) {
        this.address = address;
        this.port = port;
        this.client = null;
    }

    protected synchronized Client getClient() {
        if (this.client == null) {
            try {
                this.client = new Client(this.address, this.port);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to acquire Client address:" + this.address + ":" + this.port, e);
            }
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        if (this.client != null) {
            try {
                this.client.close();
            }
            finally {
                this.client = null;
            }
        }
    }
}

