/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.net.URI;
import java.util.Properties;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CachingTest {
    @After
    public void resetSystemProperty() {
        System.clearProperty("javax.cache.spi.CachingProvider");
        Assert.assertEquals(null, (Object)System.getProperty("javax.cache.spi.CachingProvider"));
    }

    @Test
    public void testSetDefaultClassLoader() {
        ClassLoader defaultClassLoader = Caching.getDefaultClassLoader();
        MyClassLoader uniqueClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        Caching.setDefaultClassLoader((ClassLoader)uniqueClassLoader);
        Assert.assertEquals((Object)uniqueClassLoader, (Object)Caching.getDefaultClassLoader());
        Caching.setDefaultClassLoader(null);
        Assert.assertEquals((Object)defaultClassLoader, (Object)Caching.getDefaultClassLoader());
    }

    @Test
    public void testJCacheCachingProviderSystemProperty() {
        System.setProperty("javax.cache.spi.CachingProvider", "javax.cache.CachingTest$ACachingProviderImpl");
        MyClassLoader uniqueClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)uniqueClassLoader);
        Assert.assertEquals(provider.getClass(), ACachingProviderImpl.class);
    }

    @Test
    public void testJCacheCachingProviderSystemPropertyUsingClassLoader() {
        System.setProperty("javax.cache.spi.CachingProvider", "javax.cache.CachingTest$AlternativeCachingProviderImpl");
        MyClassLoader alternativeClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)alternativeClassLoader);
        Assert.assertEquals(provider.getClass(), AlternativeCachingProviderImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJCacheCachingProvider() {
        MyClassLoader uniqueClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        Caching.setDefaultClassLoader((ClassLoader)uniqueClassLoader);
        try {
            CachingProvider defaultProvider = Caching.getCachingProvider();
            CachingProvider alternativeProvider = Caching.getCachingProvider((String)"javax.cache.CachingTest$AlternativeCachingProviderImpl", null);
            Assert.assertNotEquals((Object)defaultProvider, (Object)alternativeProvider);
            Assert.assertEquals(AlternativeCachingProviderImpl.class, alternativeProvider.getClass());
        }
        finally {
            Caching.setDefaultClassLoader(null);
        }
    }

    @Test
    public void testJCacheCachingProviderUsingClassLoader() {
        MyClassLoader alternativeClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        CachingProvider provider = Caching.getCachingProvider((String)"javax.cache.CachingTest$AlternativeCachingProviderImpl", (ClassLoader)alternativeClassLoader);
        Assert.assertEquals(provider.getClass(), AlternativeCachingProviderImpl.class);
    }

    @Test(expected=CacheException.class)
    public void testInvalidJCacheCachingProviderSystemProperty() {
        System.setProperty("javax.cache.spi.CachingProvider", "java.lang.String");
        MyClassLoader uniqueClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)uniqueClassLoader);
        Assert.fail((String)"expected an exception to be thrown");
    }

    @Test(expected=CacheException.class)
    public void testNonexistentCacheCachingProviderSystemProperty() {
        System.setProperty("javax.cache.spi.CachingProvider", "NonExistentCachingProvider");
        MyClassLoader uniqueClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)uniqueClassLoader);
        Assert.fail((String)"expected an exception to be thrown");
    }

    @Test(expected=CacheException.class)
    public void testInvalidCacheProvider() {
        Caching.getCachingProvider((String)CachingTest.class.getCanonicalName());
        Assert.fail((String)"expect CacheException");
    }

    @Test
    public void testJCacheCachingProviders() {
        Iterable iterable = Caching.getCachingProviders();
        int i = 0;
        for (CachingProvider provider : iterable) {
            System.out.println("provider=" + provider.getClass().getCanonicalName());
            ++i;
        }
        Assert.assertEquals((long)1L, (long)i);
        i = 0;
        iterable = Caching.getCachingProviders((ClassLoader)Caching.getDefaultClassLoader());
        for (CachingProvider provider : iterable) {
            System.out.println("provider=" + provider.getClass().getCanonicalName());
            ++i;
        }
        Assert.assertEquals((long)1L, (long)i);
        i = 0;
        iterable = Caching.getCachingProviders(null);
        for (CachingProvider provider : iterable) {
            System.out.println("provider=" + provider.getClass().getCanonicalName());
            ++i;
        }
        Assert.assertEquals((long)1L, (long)i);
    }

    @Test(expected=CacheException.class)
    public void testMultipleCacheProvidersWithClassLoader() {
        MyClassLoader uniqueClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        CachingProvider provider1 = Caching.getCachingProvider((String)"javax.cache.CachingTest$AlternativeCachingProviderImpl", (ClassLoader)uniqueClassLoader);
        CachingProvider provider2 = Caching.getCachingProvider((String)"javax.cache.CachingTest$ACachingProviderImpl", (ClassLoader)uniqueClassLoader);
        Assert.assertNotEquals((Object)provider1, (Object)provider2);
        CachingProvider provider3 = Caching.getCachingProvider((String)"javax.cache.CachingTest$ACachingProviderImpl", (ClassLoader)uniqueClassLoader);
        Assert.assertEquals((Object)provider2, (Object)provider3);
        Caching.getCachingProvider((ClassLoader)uniqueClassLoader);
        Assert.fail((String)"expected CacheException MultipleCacheProviders");
    }

    public void testNoCacheProvidersWithClassLoader() {
        MyClassLoader uniqueClassLoader = new MyClassLoader(Thread.currentThread().getContextClassLoader());
        Caching.getCachingProvider((ClassLoader)uniqueClassLoader);
        Assert.fail((String)"expected CacheException MultipleCacheProviders");
    }

    public static class AlternativeCachingProviderImpl
    extends CachingProviderImpl {
    }

    public static class ACachingProviderImpl
    extends CachingProviderImpl {
    }

    public static class CachingProviderImpl
    implements CachingProvider {
        public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
            throw new UnsupportedOperationException("not implemented");
        }

        public ClassLoader getDefaultClassLoader() {
            throw new UnsupportedOperationException("not implemented");
        }

        public URI getDefaultURI() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Properties getDefaultProperties() {
            throw new UnsupportedOperationException("not implemented");
        }

        public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
            throw new UnsupportedOperationException("not implemented");
        }

        public CacheManager getCacheManager() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void close() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void close(ClassLoader classLoader) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void close(URI uri, ClassLoader classLoader) {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean isSupported(OptionalFeature optionalFeature) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }
    }
}

