/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.management;

import java.awt.Color;
import java.math.BigDecimal;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.management.InstanceNotFoundException;
import junit.framework.TestCase;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class CacheMXBeanTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheMXBeanTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
        this.cache.getCacheManager().enableStatistics(this.cache.getName(), true);
        this.cache.getCacheManager().enableManagement(this.cache.getName(), true);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> extraSetup(MutableConfiguration<Long, String> configuration) {
        return configuration.setStoreByValue(true);
    }

    @Test
    public void testCacheMXBeanManagementTurnedOff() throws Exception {
        this.cache.getCacheManager().enableManagement(this.cache.getName(), false);
        try {
            CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "ReadThrough");
            TestCase.fail();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCacheMXBean() throws Exception {
        Assert.assertEquals((Object)"java.lang.Long", (Object)CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "KeyType"));
        Assert.assertEquals((Object)"java.lang.String", (Object)CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "ValueType"));
        Assert.assertEquals((Object)false, (Object)CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "ReadThrough"));
        Assert.assertEquals((Object)false, (Object)CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "WriteThrough"));
        Assert.assertEquals((Object)true, (Object)CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "StoreByValue"));
        Assert.assertEquals((Object)true, (Object)CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "StatisticsEnabled"));
        Assert.assertEquals((Object)true, (Object)CacheMXBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheConfiguration, "ManagementEnabled"));
    }

    @Test
    public void testCustomConfiguration() throws Exception {
        boolean storeByValue = false;
        MutableConfiguration configuration = new MutableConfiguration().setReadThrough(false).setWriteThrough(false).setStoreByValue(storeByValue).setTypes(BigDecimal.class, Color.class).setManagementEnabled(true).setStatisticsEnabled(false);
        Cache cache = null;
        try {
            cache = this.getCacheManager().createCache("customCache", (Configuration)configuration);
        }
        catch (UnsupportedOperationException e) {
            storeByValue = true;
            configuration.setStoreByValue(storeByValue);
            cache = this.getCacheManager().createCache("customCache", (Configuration)configuration);
        }
        Assert.assertEquals((Object)"java.math.BigDecimal", (Object)CacheMXBeanTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheConfiguration, "KeyType"));
        Assert.assertEquals((Object)"java.awt.Color", (Object)CacheMXBeanTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheConfiguration, "ValueType"));
        Assert.assertEquals((Object)false, (Object)CacheMXBeanTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheConfiguration, "ReadThrough"));
        Assert.assertEquals((Object)false, (Object)CacheMXBeanTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheConfiguration, "WriteThrough"));
        Assert.assertEquals((Object)storeByValue, (Object)CacheMXBeanTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheConfiguration, "StoreByValue"));
        Assert.assertEquals((Object)false, (Object)CacheMXBeanTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheConfiguration, "StatisticsEnabled"));
        Assert.assertEquals((Object)true, (Object)CacheMXBeanTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheConfiguration, "ManagementEnabled"));
        cache.getCacheManager().destroyCache("customCache");
    }
}

