/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.testutil;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class CacheTestSupport<K, V>
extends TestSupport {
    protected Cache<K, V> cache;
    protected MyCacheEntryListener<K, V> listener;
    protected MutableCacheEntryListenerConfiguration<K, V> listenerConfiguration;

    @Before
    public void setUp() throws IOException {
        this.cache = this.getCacheManager().createCache(this.getTestCacheName(), this.extraSetup(this.newMutableConfiguration()));
    }

    @After
    public void teardown() {
        this.getCacheManager().destroyCache(this.getTestCacheName());
    }

    protected abstract MutableConfiguration<K, V> newMutableConfiguration();

    protected MutableConfiguration<K, V> extraSetup(MutableConfiguration<K, V> configuration) {
        return configuration;
    }

    private LinkedHashMap<Long, String> createLSData(int count, long now) {
        LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>(count);
        for (int i = 0; i < count; ++i) {
            Long key = now + (long)i;
            map.put(key, "value" + key);
        }
        return map;
    }

    private LinkedHashMap<Date, Date> createDDData(int count, long now) {
        LinkedHashMap<Date, Date> map = new LinkedHashMap<Date, Date>(count);
        for (int i = 0; i < count; ++i) {
            map.put(new Date(now + (long)i), new Date(now + 1000L + (long)i));
        }
        return map;
    }

    protected LinkedHashMap<Date, Date> createDDData(int count) {
        return this.createDDData(count, System.currentTimeMillis());
    }

    protected LinkedHashMap<Long, String> createLSData(int count) {
        return this.createLSData(count, System.currentTimeMillis());
    }

    public static class MyCacheEntryListener<K, V>
    implements CacheEntryCreatedListener<K, V>,
    CacheEntryUpdatedListener<K, V>,
    CacheEntryExpiredListener<K, V>,
    CacheEntryRemovedListener<K, V>,
    Serializable,
    AutoCloseable {
        final boolean oldValueRequired;
        AtomicInteger created = new AtomicInteger();
        AtomicInteger updated = new AtomicInteger();
        AtomicInteger removed = new AtomicInteger();
        ArrayList<CacheEntryEvent<K, V>> entries = new ArrayList();

        public MyCacheEntryListener() {
            this(false);
        }

        public MyCacheEntryListener(boolean oldValueRequired) {
            this.oldValueRequired = oldValueRequired;
        }

        public boolean isOldValueRequired() {
            return this.oldValueRequired;
        }

        public int getCreated() {
            return this.created.get();
        }

        public int getUpdated() {
            return this.updated.get();
        }

        public int getRemoved() {
            return this.removed.get();
        }

        public ArrayList<CacheEntryEvent<K, V>> getEntries() {
            return this.entries;
        }

        public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
                Assert.assertEquals((Object)EventType.CREATED, (Object)cacheEntryEvent.getEventType());
                Assert.assertFalse((boolean)cacheEntryEvent.isOldValueAvailable());
                this.created.incrementAndGet();
                cacheEntryEvent.getKey();
                cacheEntryEvent.getValue();
                cacheEntryEvent.getSource();
            }
        }

        public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
                Assert.assertEquals((Object)EventType.EXPIRED, (Object)cacheEntryEvent.getEventType());
                this.assertOldValueForExpiredRemovedListener(cacheEntryEvent);
            }
        }

        public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
                Assert.assertEquals((Object)EventType.REMOVED, (Object)cacheEntryEvent.getEventType());
                this.removed.incrementAndGet();
                cacheEntryEvent.getKey();
                this.assertOldValueForExpiredRemovedListener(cacheEntryEvent);
            }
        }

        public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
                Assert.assertEquals((Object)EventType.UPDATED, (Object)cacheEntryEvent.getEventType());
                this.updated.incrementAndGet();
                cacheEntryEvent.getKey();
                if (!this.oldValueRequired) continue;
                Assert.assertTrue((String)("Old value should be available for " + this.eventAsString(cacheEntryEvent)), (boolean)cacheEntryEvent.isOldValueAvailable());
                Assert.assertNotNull((Object)cacheEntryEvent.getOldValue());
            }
        }

        @Override
        public void close() throws Exception {
        }

        private void assertOldValueForExpiredRemovedListener(CacheEntryEvent<? extends K, ? extends V> event) {
            if (this.isOldValueRequired()) {
                Assert.assertTrue((String)("Old value should be available for " + this.eventAsString(event)), (boolean)event.isOldValueAvailable());
                Assert.assertNotNull((String)("Old value should be available for " + this.eventAsString(event)), (Object)event.getOldValue());
                Assert.assertNotNull((String)("Old value should be available for " + this.eventAsString(event)), (Object)event.getValue());
            } else if (event.isOldValueAvailable()) {
                Assert.assertNotNull((String)("Old value should be available for " + this.eventAsString(event)), (Object)event.getOldValue());
                Assert.assertNotNull((String)("Old value should be available for " + this.eventAsString(event)), (Object)event.getValue());
            } else {
                Assert.assertNull((String)("Old value should be null for " + this.eventAsString(event)), (Object)event.getOldValue());
                Assert.assertNull((String)("Old value should be null for " + this.eventAsString(event)), (Object)event.getValue());
            }
        }

        private String eventAsString(CacheEntryEvent<? extends K, ? extends V> event) {
            StringBuilder sb = new StringBuilder();
            sb.append("CacheEntryEvent{eventType = ").append(event.getEventType()).append(", isOldValueAvailable = ").append(event.isOldValueAvailable()).append(", value = ").append(event.getValue()).append(", oldValue = ").append(event.getOldValue()).append("}");
            return sb.toString();
        }
    }
}

