/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.support;

import java.io.Closeable;
import java.io.Serializable;
import java.net.InetAddress;
import org.jsr107.tck.support.Client;
import org.jsr107.tck.support.Server;

public class CacheClient
implements Closeable,
Serializable {
    protected InetAddress address;
    protected int port;
    protected transient Client client;

    protected CacheClient(InetAddress address, int port) {
        this.address = address;
        this.port = port;
        this.client = null;
    }

    protected synchronized Client getClient() {
        if (this.client == null) {
            try {
                this.client = new Client(this.address, this.port);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to acquire Client address:" + this.address + ":" + this.port, e);
            }
        }
        return this.client;
    }

    @Override
    public synchronized void close() {
        if (this.client != null) {
            try {
                this.client.invoke(Server.CLOSE_OPERATION);
                this.client.close();
            }
            finally {
                this.client = null;
            }
        }
    }
}

