/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import java.util.Date;
import javax.cache.configuration.MutableConfiguration;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class StoreByValueTest
extends CacheTestSupport<Date, Date> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Date.class, Date.class);
    }

    @Override
    protected MutableConfiguration<Date, Date> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Date.class, Date.class);
    }

    @Test
    public void get_Existing_MutateValue() {
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date existingValue = new Date(now);
        this.cache.put((Object)existingKey, (Object)existingValue);
        existingValue.setTime(now + 1L);
        Assert.assertEquals((Object)new Date(now), (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void get_Existing_MutateKey() {
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date existingValue = new Date(now);
        this.cache.put((Object)existingKey, (Object)existingValue);
        existingKey.setTime(now + 1L);
        Assert.assertEquals((Object)new Date(now), (Object)this.cache.get((Object)new Date(now)));
    }

    @Test
    public void getAndPut_NotThere() {
        if (this.cache == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date existingValue = new Date(now);
        Assert.assertNull((Object)this.cache.getAndPut((Object)existingKey, (Object)existingValue));
        existingValue.setTime(now + 1L);
        Assert.assertEquals((Object)new Date(now), (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void getAndPut_Existing_MutateValue() {
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date value1 = new Date(now);
        this.cache.getAndPut((Object)existingKey, (Object)value1);
        Date value2 = new Date(now + 1L);
        value1.setTime(now + 2L);
        Assert.assertEquals((Object)new Date(now), (Object)this.cache.getAndPut((Object)existingKey, (Object)value2));
        value2.setTime(now + 3L);
        Assert.assertEquals((Object)new Date(now + 1L), (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void getAndPut_Existing_NonSameKey_MutateValue() throws Exception {
        long now = System.currentTimeMillis();
        Date key1 = new Date(now);
        Date value1 = new Date(now);
        this.cache.getAndPut((Object)key1, (Object)value1);
        value1.setTime(now + 1L);
        Date key2 = new Date(now);
        Date value2 = new Date(now + 2L);
        Assert.assertEquals((Object)new Date(now), (Object)this.cache.getAndPut((Object)key2, (Object)value2));
        value2.setTime(now + 3L);
        Assert.assertEquals((Object)new Date(now + 2L), (Object)this.cache.get((Object)key1));
        Assert.assertEquals((Object)new Date(now + 2L), (Object)this.cache.get((Object)key2));
    }

    @Test
    public void getAndPut_Existing_NonSameKey_MutateKey() {
        long now = System.currentTimeMillis();
        Date key1 = new Date(now);
        Date value1 = new Date(now);
        this.cache.getAndPut((Object)key1, (Object)value1);
        key1.setTime(now + 1L);
        Date key2 = new Date(now);
        Date value2 = new Date(now + 2L);
        Assert.assertEquals((Object)new Date(now), (Object)this.cache.getAndPut((Object)key2, (Object)value2));
        Assert.assertEquals((Object)new Date(now + 2L), (Object)this.cache.get((Object)key2));
    }
}

