/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jsr107.tck.support.Client;
import org.jsr107.tck.support.Operation;
import org.jsr107.tck.support.OperationHandler;
import org.jsr107.tck.support.Server;
import org.junit.Assert;
import org.junit.Test;

public class ClientServerTest {
    @Test
    public void shouldPingPong() {
        Server server = new Server(10000);
        server.addOperationHandler((OperationHandler)new PingPong());
        try {
            server.open();
            Client client = new Client(server.getInetAddress(), server.getPort());
            String result = (String)client.invoke((Operation)new PingPong());
            Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"pong"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class PingPong
    implements Operation<String>,
    OperationHandler {
        public String getType() {
            return "pingpong";
        }

        public String onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            oos.writeObject("ping");
            return (String)ois.readObject();
        }

        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            String request = (String)ois.readObject();
            oos.writeObject("pong");
        }
    }
}

