/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.integration;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.cache.integration.CompletionListenerFuture;
import org.junit.Assert;
import org.junit.Test;

public class CompletionListenerFutureTest {
    @Test(expected=IllegalStateException.class)
    public void testOnCompletionIllegalStateExceptionThrown() {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.onCompletion();
    }

    @Test(expected=IllegalStateException.class)
    public void testOnExceptionIllegalStateExceptionThrown() {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onException((Exception)new IllegalStateException());
        future.onException((Exception)new IllegalStateException());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCancel() {
        CompletionListenerFuture future = new CompletionListenerFuture();
        Assert.assertFalse((boolean)future.isCancelled());
        future.cancel(true);
    }

    @Test
    public void testTimedGetNoWait() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testTimedGet() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=TimeoutException.class)
    public void testTimedGetTimeOutException() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=TimeoutException.class)
    public void testTimedGetTimeOutException0ms() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.get(0L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=ExecutionException.class)
    public void testTimedGetOnException() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onException((Exception)new IllegalStateException());
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=ExecutionException.class)
    public void testTimedGetOnException0ms() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onException((Exception)new IllegalStateException());
        future.get(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testGetCompleted() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetOnException() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onException((Exception)new IllegalStateException());
        future.get();
    }

    @Test
    public void testIsDone() {
        CompletionListenerFuture future = new CompletionListenerFuture();
        Assert.assertFalse((boolean)future.isDone());
        future.onCompletion();
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void testWakeup() throws InterruptedException {
        Thread t;
        int i;
        boolean THREAD_COUNT = true;
        long TIMEOUT_MILLIS = 60000L;
        final CompletionListenerFuture future = new CompletionListenerFuture();
        Thread[] threads = new Thread[1];
        for (i = 0; i < 1; ++i) {
            t = threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
        }
        future.onCompletion();
        for (i = 0; i < 1; ++i) {
            t = threads[i];
            t.join(60000L);
            if (!t.isAlive()) continue;
            Assert.fail((String)"thread not terminated");
        }
    }

    @Test
    public void testCorrectWaitTime() throws Exception {
        long TIMEOUT_MILLIS = 42L;
        CompletionListenerFuture future = new CompletionListenerFuture();
        long t0 = System.currentTimeMillis();
        try {
            future.get(42L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"exception expected");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertTrue((String)"minimum time passed", (System.currentTimeMillis() - t0 >= 42L ? 1 : 0) != 0);
    }
}

