/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheManagerTest
extends TestSupport {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheManagerTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };

    @Before
    public void startUp() {
        try {
            Caching.getCachingProvider().close();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    @After
    public void teardown() {
        CacheManager cacheManager = this.getCacheManager();
        for (String cacheName : cacheManager.getCacheNames()) {
            cacheManager.destroyCache(cacheName);
        }
        cacheManager.close();
    }

    @Test
    public void getOrCreateCache_NullCacheName() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.createCache(null, (Configuration)new MutableConfiguration());
            Assert.fail((String)"should have thrown an exception - null cache name not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void createCache_NullCacheName() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.createCache(null, (Configuration)new MutableConfiguration());
            Assert.fail((String)"should have thrown an exception - null cache name not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getOrCreateCache_NullCacheConfiguration() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.createCache("cache", null);
            Assert.fail((String)"should have thrown an exception - null cache configuration not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void createCache_NullCacheConfiguration() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.createCache("cache", null);
            Assert.fail((String)"should have thrown an exception - null cache configuration not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getOrCreateCache_Same() {
        String name = "c1";
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCache(name, (Configuration)new MutableConfiguration());
        Cache cache = cacheManager.getCache(name);
        Assert.assertSame((Object)cache, (Object)cacheManager.getCache(name));
    }

    @Test
    public void createCache_Same() {
        String name = "c1";
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.createCache(name, (Configuration)new MutableConfiguration());
            Cache cache1 = cacheManager.getCache(name);
            cacheManager.createCache(name, (Configuration)new MutableConfiguration());
            Cache cache2 = cacheManager.getCache(name);
            Assert.fail();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    @Test
    public void testReuseCacheManager() throws Exception {
        CachingProvider provider = Caching.getCachingProvider();
        URI uri = provider.getDefaultURI();
        CacheManager cacheManager = provider.getCacheManager(uri, provider.getDefaultClassLoader());
        Assert.assertFalse((boolean)cacheManager.isClosed());
        cacheManager.close();
        Assert.assertTrue((boolean)cacheManager.isClosed());
        try {
            cacheManager.createCache("Dog", (Configuration)new MutableConfiguration());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CacheManager otherCacheManager = provider.getCacheManager(uri, provider.getDefaultClassLoader());
        Assert.assertFalse((boolean)otherCacheManager.isClosed());
        Assert.assertNotSame((Object)cacheManager, (Object)otherCacheManager);
    }

    @Test
    public void testReuseCacheManagerGetCache() throws Exception {
        CachingProvider provider = Caching.getCachingProvider();
        URI uri = provider.getDefaultURI();
        CacheManager cacheManager = provider.getCacheManager(uri, provider.getDefaultClassLoader());
        Assert.assertFalse((boolean)cacheManager.isClosed());
        cacheManager.close();
        Assert.assertTrue((boolean)cacheManager.isClosed());
        try {
            cacheManager.getCache("nonExistent", Integer.class, Integer.class);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CacheManager otherCacheManager = provider.getCacheManager(uri, provider.getDefaultClassLoader());
        Assert.assertFalse((boolean)otherCacheManager.isClosed());
        Assert.assertNotSame((Object)cacheManager, (Object)otherCacheManager);
    }

    @Test
    public void getOrCreateCache_NameOK() {
        String name = "c1";
        this.getCacheManager().createCache(name, (Configuration)new MutableConfiguration());
        Cache cache = this.getCacheManager().getCache(name);
        Assert.assertEquals((Object)name, (Object)cache.getName());
    }

    @Test
    public void createCache_NameOK() {
        String name = "c1";
        this.getCacheManager().createCache(name, (Configuration)new MutableConfiguration());
        Cache cache = this.getCacheManager().getCache(name);
        Assert.assertEquals((Object)name, (Object)cache.getName());
    }

    @Test
    public void cachingProviderGetCache() {
        String name = "c1";
        this.getCacheManager().createCache(name, (Configuration)new MutableConfiguration().setTypes(Long.class, String.class));
        Cache cache = Caching.getCache((String)name, Long.class, String.class);
        Assert.assertEquals((Object)name, (Object)cache.getName());
    }

    @Test
    public void getOrCreateCache_StatusOK() {
        String name = "c1";
        this.getCacheManager().createCache(name, (Configuration)new MutableConfiguration());
        Cache cache = this.getCacheManager().getCache(name);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals((Object)name, (Object)cache.getName());
    }

    @Test
    public void getOrCreateCache_Different() {
        String name1 = "c1";
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCache(name1, (Configuration)new MutableConfiguration());
        Cache cache1 = cacheManager.getCache(name1);
        String name2 = "c2";
        cacheManager.createCache(name2, (Configuration)new MutableConfiguration());
        Cache cache2 = cacheManager.getCache(name2);
        Assert.assertEquals((Object)cache1, (Object)cacheManager.getCache(name1));
        Assert.assertEquals((Object)cache2, (Object)cacheManager.getCache(name2));
    }

    @Test
    public void createCacheSameName() {
        CacheManager cacheManager = this.getCacheManager();
        String name1 = "c1";
        cacheManager.createCache(name1, (Configuration)new MutableConfiguration());
        Cache cache1 = cacheManager.getCache(name1);
        Assert.assertEquals((Object)cache1, (Object)cacheManager.getCache(name1));
        this.ensureOpen(cache1);
        try {
            cacheManager.createCache(name1, (Configuration)new MutableConfiguration());
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        Cache cache2 = cacheManager.getCache(name1);
    }

    @Test
    public void removeCache_Null() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.destroyCache(null);
            Assert.fail((String)"should have thrown an exception - cache name null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void removeCache_There() {
        CacheManager cacheManager = this.getCacheManager();
        String name1 = "c1";
        cacheManager.createCache(name1, (Configuration)new MutableConfiguration());
        cacheManager.destroyCache(name1);
        Assert.assertFalse((boolean)cacheManager.getCacheNames().iterator().hasNext());
    }

    @Test
    public void removeCache_CacheStopped() {
        CacheManager cacheManager = this.getCacheManager();
        String name1 = "c1";
        cacheManager.createCache(name1, (Configuration)new MutableConfiguration());
        Cache cache1 = cacheManager.getCache(name1);
        cacheManager.destroyCache(name1);
        this.ensureClosed(cache1);
    }

    @Test
    public void removeCache_NotThere() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.destroyCache("c1");
    }

    @Test
    public void removeCache_Stopped() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.close();
        try {
            cacheManager.destroyCache("c1");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void close_cachesClosed() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCache("c1", (Configuration)new MutableConfiguration());
        Cache cache1 = cacheManager.getCache("c1");
        cacheManager.createCache("c2", (Configuration)new MutableConfiguration());
        Cache cache2 = cacheManager.getCache("c2");
        cacheManager.close();
        this.ensureClosed(cache1);
        this.ensureClosed(cache2);
    }

    @Test
    public void close() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.assertFalse((boolean)cacheManager.isClosed());
        cacheManager.close();
        Assert.assertTrue((boolean)cacheManager.isClosed());
    }

    @Test
    public void close_twice() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.close();
        cacheManager.close();
    }

    @Test
    public void close_cachesEmpty() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCache("c1", (Configuration)new MutableConfiguration());
        cacheManager.createCache("c2", (Configuration)new MutableConfiguration());
        cacheManager.close();
        try {
            cacheManager.getCacheNames();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getCache_Missing() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.assertNull((Object)cacheManager.getCache("notThere"));
    }

    @Test
    public void getCache_There() {
        String name = this.toString();
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCache(name, (Configuration)new MutableConfiguration());
        Cache cache = cacheManager.getCache(name);
        Assert.assertSame((Object)cache, (Object)cacheManager.getCache(name));
    }

    @Test
    public void getCache_Missing_Stopped() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.close();
        try {
            cacheManager.getCache("notThere");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalStateException.class)
    public void enableStatistics_managerStopped() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.close();
        cacheManager.enableStatistics("notThere", true);
        Assert.fail();
    }

    @Test(expected=IllegalStateException.class)
    public void enableManagement_managerStopped() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.close();
        cacheManager.enableManagement("notThere", true);
        Assert.fail();
    }

    @Test(expected=NullPointerException.class)
    public void enableStatistics_nullCacheName() {
        CacheManager cacheManager = this.getCacheManager();
        String NULL_CACHE_NAME = null;
        cacheManager.enableStatistics(NULL_CACHE_NAME, true);
        Assert.fail();
    }

    @Test(expected=NullPointerException.class)
    public void enableManagement_nullCacheName() {
        CacheManager cacheManager = this.getCacheManager();
        String NULL_CACHE_NAME = null;
        cacheManager.enableManagement(NULL_CACHE_NAME, true);
        Assert.fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void unwrapThrowsInvalidArgument() {
        Class<Exception> ALWAYS_INVALID_UNWRAP_CLASS = Exception.class;
        this.getCacheManager().unwrap(Exception.class);
        Assert.fail();
    }

    @Test
    public void getCache_There_Stopped() {
        String name = this.toString();
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCache(name, (Configuration)new MutableConfiguration());
        cacheManager.close();
        try {
            cacheManager.getCache(name);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getCaches_Empty() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.assertFalse((boolean)cacheManager.getCacheNames().iterator().hasNext());
    }

    @Test
    public void getCaches_NotEmpty() {
        CacheManager cacheManager = this.getCacheManager();
        ArrayList<String> caches1 = new ArrayList<String>();
        cacheManager.createCache("c1", (Configuration)new MutableConfiguration());
        cacheManager.createCache("c2", (Configuration)new MutableConfiguration());
        cacheManager.createCache("c3", (Configuration)new MutableConfiguration());
        caches1.add(cacheManager.getCache("c1").getName());
        caches1.add(cacheManager.getCache("c2").getName());
        caches1.add(cacheManager.getCache("c3").getName());
        this.checkCollections(caches1, cacheManager.getCacheNames());
    }

    @Test
    public void getCaches_MutateReturn() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCache("c1", (Configuration)new MutableConfiguration());
        Cache cache1 = cacheManager.getCache("c1");
        try {
            Iterator iterator = cacheManager.getCacheNames().iterator();
            iterator.next();
            iterator.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void getCaches_MutateCacheManager() {
        CacheManager cacheManager = this.getCacheManager();
        String removeName = "c2";
        ArrayList<String> cacheNames1 = new ArrayList<String>();
        cacheManager.createCache("c1", (Configuration)new MutableConfiguration());
        Cache c1 = cacheManager.getCache("c1");
        cacheNames1.add(c1.getName());
        cacheManager.createCache(removeName, (Configuration)new MutableConfiguration());
        cacheManager.createCache("c3", (Configuration)new MutableConfiguration());
        Cache c3 = cacheManager.getCache("c3");
        cacheNames1.add(c3.getName());
        Iterable cacheNames = cacheManager.getCacheNames();
        int size = 0;
        for (String cacheName : cacheNames) {
            ++size;
        }
        Assert.assertEquals((long)3L, (long)size);
        cacheManager.destroyCache(removeName);
        size = 0;
        for (String cacheName : cacheNames) {
            ++size;
        }
        Assert.assertEquals((long)3L, (long)size);
        cacheNames = cacheManager.getCacheNames();
        size = 0;
        for (String cacheName : cacheNames) {
            ++size;
        }
        Assert.assertEquals((long)2L, (long)size);
        this.checkCollections(cacheNames1, cacheNames);
    }

    @Test
    public void getUntypedCache() {
        CacheManager cacheManager = this.getCacheManager();
        MutableConfiguration config = new MutableConfiguration();
        cacheManager.createCache("untyped-cache", (Configuration)config);
        Cache cache = cacheManager.getCache("untyped-cache");
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals(Object.class, (Object)cache.getConfiguration(CompleteConfiguration.class).getKeyType());
        Assert.assertEquals(Object.class, (Object)cache.getConfiguration(CompleteConfiguration.class).getValueType());
    }

    @Test
    public void getTypedCache() {
        CacheManager cacheManager = this.getCacheManager();
        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, Long.class);
        cacheManager.createCache("typed-cache", (Configuration)config);
        Cache cache = cacheManager.getCache("typed-cache", String.class, Long.class);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals(String.class, (Object)((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getKeyType());
        Assert.assertEquals(Long.class, (Object)((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getValueType());
    }

    @Test(expected=ClassCastException.class)
    public void getIncorrectCacheType() {
        CacheManager cacheManager = this.getCacheManager();
        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, Long.class);
        cacheManager.createCache("typed-cache", (Configuration)config);
        Cache cache = cacheManager.getCache("typed-cache", Long.class, String.class);
    }

    @Test(expected=ClassCastException.class)
    public void getIncorrectCacheValueType() {
        CacheManager cacheManager = this.getCacheManager();
        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, Long.class);
        cacheManager.createCache("typed-cache", (Configuration)config);
        Cache cache = cacheManager.getCache("typed-cache", String.class, String.class);
    }

    @Test
    public void getUnsafeTypedCacheRequest() {
        CacheManager cacheManager = this.getCacheManager();
        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, Long.class);
        cacheManager.createCache("typed-cache", (Configuration)config);
        Cache cache = cacheManager.getCache("typed-cache");
    }

    @Test(expected=NullPointerException.class)
    public void getNullTypeCacheRequest() {
        CacheManager cacheManager = this.getCacheManager();
        MutableConfiguration config = new MutableConfiguration();
        cacheManager.createCache("untyped-cache", (Configuration)config);
        Cache cache = cacheManager.getCache("untyped-cache", null, null);
    }

    @Test
    public void testUnwrap() {
        Class<?> unwrapClass = this.getUnwrapClass(CacheManager.class);
        CacheManager cacheManager = this.getCacheManager();
        Object unwrappedCacheManager = cacheManager.unwrap(unwrapClass);
        Assert.assertTrue((boolean)unwrapClass.isAssignableFrom(unwrappedCacheManager.getClass()));
    }

    private <T> void checkCollections(Collection<T> collection1, Iterable<?> iterable2) {
        ArrayList collection2 = new ArrayList();
        for (Object element : iterable2) {
            Assert.assertTrue((boolean)collection1.contains(element));
            collection2.add(element);
        }
        Assert.assertEquals((long)collection1.size(), (long)collection2.size());
        for (Object element : collection1) {
            Assert.assertTrue((boolean)collection2.contains(element));
        }
    }

    private void ensureOpen(Cache cache) {
        if (cache.isClosed()) {
            Assert.fail();
        }
    }

    private void ensureClosed(Cache cache) {
        if (!cache.isClosed()) {
            Assert.fail();
        }
    }
}

