/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.expiry;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import javax.cache.processor.EntryProcessor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jsr107.tck.event.CacheEntryListenerClient;
import org.jsr107.tck.event.CacheEntryListenerServer;
import org.jsr107.tck.expiry.ExpiryPolicyClient;
import org.jsr107.tck.expiry.ExpiryPolicyServer;
import org.jsr107.tck.integration.CacheLoaderClient;
import org.jsr107.tck.integration.CacheLoaderServer;
import org.jsr107.tck.integration.RecordingCacheLoader;
import org.jsr107.tck.processor.AssertNotPresentEntryProcessor;
import org.jsr107.tck.processor.CombineEntryProcessor;
import org.jsr107.tck.processor.GetEntryProcessor;
import org.jsr107.tck.processor.SetEntryProcessor;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheExpiryTest
extends CacheTestSupport<Integer, Integer> {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());
    private ExpiryPolicyServer expiryPolicyServer;
    private ExpiryPolicyClient expiryPolicyClient;
    private CacheEntryListenerServer<Integer, Integer> cacheEntryListenerServer;
    private CacheEntryListenerClient<Integer, Integer> cacheEntryListerClient;

    @Override
    @Before
    public void setUp() throws IOException {
        this.expiryPolicyServer = new ExpiryPolicyServer(10005);
        this.expiryPolicyServer.open();
        this.expiryPolicyClient = new ExpiryPolicyClient(this.expiryPolicyServer.getInetAddress(), this.expiryPolicyServer.getPort());
        this.cacheEntryListenerServer = new CacheEntryListenerServer(10011, Integer.class, Integer.class);
        this.cacheEntryListenerServer.open();
        this.cacheEntryListerClient = new CacheEntryListenerClient(this.cacheEntryListenerServer.getInetAddress(), this.cacheEntryListenerServer.getPort());
    }

    @Override
    protected MutableConfiguration<Integer, Integer> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Integer.class, Integer.class);
    }

    @Override
    protected MutableConfiguration<Integer, Integer> extraSetup(MutableConfiguration<Integer, Integer> configuration) {
        this.listener = new CacheTestSupport.MyCacheEntryListener(true);
        this.listenerConfiguration = new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf(this.cacheEntryListerClient), null, true, true);
        this.cacheEntryListenerServer.addCacheEventListener((CacheEntryListener)this.listener);
        return configuration.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)this.listenerConfiguration);
    }

    @After
    public void cleanupAfterEachTest() throws InterruptedException {
        for (String cacheName : this.getCacheManager().getCacheNames()) {
            this.getCacheManager().destroyCache(cacheName);
        }
        this.expiryPolicyServer.close();
        this.expiryPolicyServer = null;
        this.cacheEntryListenerServer.close();
        this.cacheEntryListenerServer = null;
    }

    @Test
    public void testCacheStatisticsRemoveAll() throws Exception {
        CreatedExpiryPolicy policy = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)policy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient)).setStatisticsEnabled(true);
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)(i + 100));
        }
        Thread.sleep(1100L);
        cache.removeAll();
        Assert.assertEquals((Object)100L, (Object)CacheExpiryTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)0L, (Object)CacheExpiryTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
    }

    @Test
    public void testCacheStatisticsRemoveAllNoneExpired() throws Exception {
        CreatedExpiryPolicy policy = new CreatedExpiryPolicy(Duration.ETERNAL);
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)policy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient)).setStatisticsEnabled(true);
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)(i + 100));
        }
        cache.removeAll();
        Assert.assertEquals((Object)100L, (Object)CacheExpiryTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        Assert.assertEquals((Object)100L, (Object)CacheExpiryTest.lookupManagementAttribute(cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void microsecondsInvalidDuration() {
        Duration invalidDuration = new Duration(TimeUnit.MICROSECONDS, 0L);
        Assert.assertTrue((String)"expected IllegalArgumentException for TimeUnit below minimum of MILLISECONDS", (invalidDuration == null ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nanosecondsInvalidDuration() {
        Duration invalidDuration = new Duration(TimeUnit.NANOSECONDS, 0L);
        Assert.assertTrue((String)"expected IllegalArgumentException for TimeUnit below minimum of MILLISECONDS", (invalidDuration == null ? 1 : 0) != 0);
    }

    private void expire_whenCreated(Factory<? extends ExpiryPolicy> expiryPolicyFactory) {
        MutableConfiguration<Integer, Integer> config = new MutableConfiguration<Integer, Integer>();
        config.setTypes(Integer.class, Integer.class);
        config.setExpiryPolicyFactory(expiryPolicyFactory);
        config = this.extraSetup(config);
        config.setStatisticsEnabled(true);
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), config);
        cache.put((Object)1, (Object)1);
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
        cache.put((Object)1, (Object)1);
        Assert.assertFalse((boolean)cache.remove((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertFalse((boolean)cache.remove((Object)1, (Object)1));
        cache.getAndPut((Object)1, (Object)1);
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.putIfAbsent((Object)1, (Object)1);
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 1);
        cache.putAll(map);
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
        Assert.assertFalse((boolean)cache.iterator().hasNext());
        cache.getAndPut((Object)1, (Object)1);
        Assert.assertEquals((long)0L, (long)this.listener.getCreated());
    }

    @Test
    public void expire_whenCreated_ParameterizedExpiryPolicy() {
        this.expire_whenCreated((Factory<? extends ExpiryPolicy>)FactoryBuilder.factoryOf((Serializable)new ParameterizedExpiryPolicy(Duration.ZERO, null, null)));
    }

    @Test
    public void expire_whenCreated_CreatedExpiryPolicy() {
        this.expire_whenCreated((Factory<? extends ExpiryPolicy>)FactoryBuilder.factoryOf((Serializable)new CreatedExpiryPolicy(Duration.ZERO)));
    }

    @Test
    public void expire_whenCreated_AccessedExpiryPolicy() {
        this.expire_whenCreated((Factory<? extends ExpiryPolicy>)FactoryBuilder.factoryOf((Serializable)new AccessedExpiryPolicy(Duration.ZERO)));
    }

    @Test
    public void expire_whenCreated_TouchedExpiryPolicy() {
        this.expire_whenCreated((Factory<? extends ExpiryPolicy>)FactoryBuilder.factoryOf((Serializable)new TouchedExpiryPolicy(Duration.ZERO)));
    }

    @Test
    public void expire_whenCreated_ModifiedExpiryPolicy() {
        this.expire_whenCreated((Factory<? extends ExpiryPolicy>)FactoryBuilder.factoryOf((Serializable)new ModifiedExpiryPolicy(Duration.ZERO)));
    }

    @Test
    public void expire_whenAccessed() {
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new ParameterizedExpiryPolicy(Duration.ETERNAL, Duration.ZERO, null)));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.getAndReplace((Object)1, (Object)2));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.getAndRemove((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.remove((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.remove((Object)1, (Object)1));
        cache.getAndPut((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.getAndPut((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.getAndPut((Object)1, (Object)1));
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.putIfAbsent((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 1);
        cache.putAll(map);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertNotNull((Object)cache.get((Object)1));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Iterator iterator = cache.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)1, (Object)((Cache.Entry)iterator.next()).getValue());
        Assert.assertFalse((boolean)cache.iterator().hasNext());
    }

    @Test
    public void expire_whenModified() {
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new ParameterizedExpiryPolicy(Duration.ETERNAL, null, Duration.ZERO)));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        cache.put((Object)1, (Object)2);
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        cache.put((Object)1, (Object)2);
        Assert.assertFalse((boolean)cache.remove((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        cache.put((Object)1, (Object)2);
        Assert.assertFalse((boolean)cache.remove((Object)1, (Object)2));
        cache.getAndPut((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        cache.put((Object)1, (Object)2);
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.getAndPut((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.getAndPut((Object)1, (Object)2));
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 2);
        cache.putAll(map);
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        cache.replace((Object)1, (Object)2);
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)cache.get((Object)1));
        cache.replace((Object)1, (Object)1, (Object)2);
        Assert.assertFalse((boolean)cache.containsKey((Object)1));
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)1, (Object)1);
        Assert.assertTrue((boolean)cache.iterator().hasNext());
        Assert.assertEquals((Object)1, (Object)((Cache.Entry)cache.iterator().next()).getValue());
        Assert.assertTrue((boolean)cache.containsKey((Object)1));
        Assert.assertEquals((Object)1, (Object)((Cache.Entry)cache.iterator().next()).getValue());
        cache.put((Object)1, (Object)2);
        Assert.assertFalse((boolean)cache.iterator().hasNext());
    }

    @Test
    public void containsKeyShouldNotCallExpiryPolicyMethods() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void getShouldCallGetExpiryForAccessedEntry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.get((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        cache.get((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
    }

    @Test
    public void getAllShouldCallGetExpiryForAccessedEntry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(1);
        keys.add(2);
        cache.getAll(keys);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        cache.get((Object)1);
        cache.get((Object)2);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
    }

    @Test
    public void getAndPutShouldCallEitherCreatedOrModifiedExpiryPolicy() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.getAndPut((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        cache.getAndPut((Object)1, (Object)2);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        expiryPolicy.resetCount();
    }

    @Test
    public void getAndRemoveShouldNotCallExpiryPolicyMethods() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.getAndRemove((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        int value = (Integer)cache.getAndRemove((Object)1);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void getAndReplaceShouldCallGetExpiryForModifiedEntry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.getAndReplace((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        int oldValue = (Integer)cache.getAndReplace((Object)1, (Object)2);
        Assert.assertEquals((long)1L, (long)oldValue);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        expiryPolicy.resetCount();
    }

    @Test
    public void iteratorNextShouldCallGetExpiryForAccessedEntry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(1);
        keys.add(2);
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        Iterator iter = cache.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Cache.Entry entry = (Cache.Entry)iter.next();
            ++count;
            Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
            expiryPolicy.resetCount();
        }
    }

    @Test
    public void loadAllWithReadThroughEnabledShouldCallGetExpiryForCreatedEntry() throws IOException, ExecutionException, InterruptedException {
        RecordingCacheLoader recordingCacheLoader = new RecordingCacheLoader();
        try (CacheLoaderServer cacheLoaderServer = new CacheLoaderServer(10000, (CacheLoader)recordingCacheLoader);){
            cacheLoaderServer.open();
            CacheLoaderClient cacheLoader = new CacheLoaderClient(cacheLoaderServer.getInetAddress(), cacheLoaderServer.getPort());
            CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
            this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
            MutableConfiguration config = new MutableConfiguration();
            config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
            config.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
            config.setReadThrough(true);
            Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
            Integer INITIAL_KEY = 123;
            Integer MAX_KEY_VALUE = INITIAL_KEY + 4;
            HashSet<Integer> keys = new HashSet<Integer>();
            for (int key = INITIAL_KEY.intValue(); key <= MAX_KEY_VALUE; ++key) {
                keys.add(key);
            }
            CompletionListenerFuture future = new CompletionListenerFuture();
            cache.loadAll(keys, false, (CompletionListener)future);
            future.get();
            Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)keys.size()));
            Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(keys.size())));
            Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
            expiryPolicy.resetCount();
            for (Integer key : keys) {
                Assert.assertThat((Object)recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
            }
            Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(keys.size())));
            expiryPolicy.resetCount();
            boolean REPLACE_EXISTING_VALUES = true;
            future = new CompletionListenerFuture();
            cache.loadAll(keys, true, (CompletionListener)future);
            future.get();
            Assert.assertThat((Object)future.isDone(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)recordingCacheLoader.getLoadCount(), (Matcher)CoreMatchers.is((Object)(keys.size() * 2)));
            Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(keys.size())));
            expiryPolicy.resetCount();
            for (Integer key : keys) {
                Assert.assertThat((Object)recordingCacheLoader.hasLoaded((Object)key), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)key)));
            }
            this.closeTestCache();
        }
    }

    @Test
    public void putShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        expiryPolicy.resetCount();
    }

    @Test
    public void putAllShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 1);
        map.put(2, 2);
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        cache.putAll(map);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        expiryPolicy.resetCount();
    }

    @Test
    public void putIfAbsentShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        boolean result = cache.putIfAbsent((Object)1, (Object)1);
        Assert.assertTrue((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        result = cache.putIfAbsent((Object)1, (Object)2);
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void removeEntryShouldNotCallExpiryPolicyMethods() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        boolean result = cache.remove((Object)1);
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        result = cache.remove((Object)1);
        Assert.assertTrue((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void removeSpecifiedEntryShouldNotCallExpiryPolicyMethods() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        boolean result = cache.remove((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        result = cache.remove((Object)1, (Object)2);
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        result = cache.remove((Object)1, (Object)1);
        Assert.assertTrue((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void invokeSetValueShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        Integer key = 123;
        Integer setValue = 456;
        Integer modifySetValue = 789;
        EntryProcessor[] processors = new EntryProcessor[]{new AssertNotPresentEntryProcessor(null), new SetEntryProcessor((Object)setValue), new GetEntryProcessor()};
        Object[] result = (Object[])cache.invoke((Object)key, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
        Assert.assertEquals((Object)setValue, (Object)result[1]);
        Assert.assertEquals((Object)setValue, (Object)result[2]);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        Integer resultValue = (Integer)cache.invoke((Object)key, (EntryProcessor)new SetEntryProcessor((Object)modifySetValue), new Object[0]);
        Assert.assertEquals((Object)modifySetValue, (Object)resultValue);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void invokeMultiSetValueShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        Integer key = 123;
        Integer setValue = 456;
        Integer modifySetValue = 789;
        EntryProcessor[] processors = new EntryProcessor[]{new AssertNotPresentEntryProcessor(null), new SetEntryProcessor((Object)111), new SetEntryProcessor((Object)setValue), new GetEntryProcessor()};
        Object[] result = (Object[])cache.invoke((Object)key, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
        Assert.assertEquals((Object)111, (Object)result[1]);
        Assert.assertEquals((Object)setValue, (Object)result[2]);
        Assert.assertEquals((Object)setValue, (Object)result[3]);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void invokeGetValueShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        Integer key = 123;
        Integer setValue = 456;
        Integer resultValue = (Integer)cache.invoke((Object)key, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
        Assert.assertEquals(null, (Object)resultValue);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        resultValue = (Integer)cache.invoke((Object)key, (EntryProcessor)new SetEntryProcessor((Object)setValue), new Object[0]);
        Assert.assertEquals((Object)setValue, (Object)resultValue);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        resultValue = (Integer)cache.invoke((Object)key, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
        Assert.assertEquals((Object)setValue, (Object)resultValue);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void invokeGetValueWithReadThroughForNonExistentEntryShouldCallGetExpiryForCreatedEntry() throws IOException {
        RecordingCacheLoader recordingCacheLoader = new RecordingCacheLoader();
        try (CacheLoaderServer cacheLoaderServer = new CacheLoaderServer(10000, (CacheLoader)recordingCacheLoader);){
            Integer key;
            cacheLoaderServer.open();
            CacheLoaderClient cacheLoader = new CacheLoaderClient(cacheLoaderServer.getInetAddress(), cacheLoaderServer.getPort());
            CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
            this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
            MutableConfiguration config = new MutableConfiguration();
            config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
            config.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
            config.setReadThrough(true);
            Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
            Integer recordingCacheLoaderValue = key = Integer.valueOf(123);
            Integer resultValue = (Integer)cache.invoke((Object)key, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
            Assert.assertEquals((Object)recordingCacheLoaderValue, (Object)resultValue);
            Assert.assertTrue((boolean)recordingCacheLoader.hasLoaded((Object)key));
            Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
            this.closeTestCache();
        }
    }

    @Test
    public void invokeAllSetValueShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        Integer INITIAL_KEY = 123;
        Integer MAX_KEY_VALUE = INITIAL_KEY + 4;
        Integer setValue = 456;
        Integer modifySetValue = 789;
        HashSet<Integer> keys = new HashSet<Integer>();
        int createdCount = 0;
        for (int key = INITIAL_KEY.intValue(); key <= MAX_KEY_VALUE; ++key) {
            keys.add(key);
            if (key > MAX_KEY_VALUE - 2) continue;
            cache.put((Object)key, (Object)setValue);
            ++createdCount;
        }
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(createdCount)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        cache.invokeAll(keys, (EntryProcessor)new SetEntryProcessor((Object)setValue), new Object[0]);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(keys.size() - createdCount)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(createdCount)));
        expiryPolicy.resetCount();
        cache.invokeAll(keys, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(keys.size())));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void invokeAllReadThroughEnabledGetOnNonExistentEntry() throws IOException {
        RecordingCacheLoader recordingCacheLoader = new RecordingCacheLoader();
        try (CacheLoaderServer cacheLoaderServer = new CacheLoaderServer(10000, (CacheLoader)recordingCacheLoader);){
            cacheLoaderServer.open();
            CacheLoaderClient cacheLoader = new CacheLoaderClient(cacheLoaderServer.getInetAddress(), cacheLoaderServer.getPort());
            CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
            this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
            MutableConfiguration config = new MutableConfiguration();
            config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
            config.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
            config.setReadThrough(true);
            Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
            Integer INITIAL_KEY = 123;
            Integer MAX_KEY_VALUE = INITIAL_KEY + 4;
            HashSet<Integer> keys = new HashSet<Integer>();
            for (int key = INITIAL_KEY.intValue(); key <= MAX_KEY_VALUE; ++key) {
                keys.add(key);
            }
            cache.invokeAll(keys, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
            Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(keys.size())));
            Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
            expiryPolicy.resetCount();
            this.closeTestCache();
        }
    }

    private void closeTestCache() {
        this.getCacheManager().destroyCache(this.getTestCacheName());
    }

    @Test
    public void replaceShouldCallGetExpiryForModifiedEntry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        boolean result = cache.replace((Object)1, (Object)1);
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        result = cache.replace((Object)1, (Object)2);
        Assert.assertTrue((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void replaceSpecificShouldCallGetExpiry() {
        CountingExpiryPolicy expiryPolicy = new CountingExpiryPolicy();
        this.expiryPolicyServer.setExpiryPolicy((ExpiryPolicy)expiryPolicy);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)this.expiryPolicyClient));
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName(), (Configuration)config);
        cache.containsKey((Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        boolean result = cache.replace((Object)1, (Object)1, (Object)2);
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        cache.put((Object)1, (Object)1);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        result = cache.replace((Object)1, (Object)2, (Object)5);
        Assert.assertFalse((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)CoreMatchers.is((Object)0));
        expiryPolicy.resetCount();
        result = cache.replace((Object)1, (Object)1, (Object)2);
        Assert.assertTrue((boolean)result);
        Assert.assertThat((Object)expiryPolicy.getCreationCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getAccessCount(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)expiryPolicy.getUpdatedCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        expiryPolicy.resetCount();
    }

    public static class ParameterizedExpiryPolicy
    implements ExpiryPolicy,
    Serializable {
        public static final long serialVersionUID = 201306141148L;
        private Duration createdExpiryDuration;
        private Duration accessedExpiryDuration;
        private Duration updatedExpiryDuration;

        public ParameterizedExpiryPolicy(Duration createdExpiryDuration, Duration accessedExpiryDuration, Duration updatedExpiryDuration) {
            if (createdExpiryDuration == null) {
                throw new NullPointerException("createdExpiryDuration can't be null");
            }
            this.createdExpiryDuration = createdExpiryDuration;
            this.accessedExpiryDuration = accessedExpiryDuration;
            this.updatedExpiryDuration = updatedExpiryDuration;
        }

        public Duration getExpiryForCreation() {
            return this.createdExpiryDuration;
        }

        public Duration getExpiryForAccess() {
            return this.accessedExpiryDuration;
        }

        public Duration getExpiryForUpdate() {
            return this.updatedExpiryDuration;
        }
    }

    public static class CountingExpiryPolicy
    implements ExpiryPolicy,
    Serializable {
        private AtomicInteger creationCount = new AtomicInteger(0);
        private AtomicInteger accessedCount = new AtomicInteger(0);
        private AtomicInteger updatedCount = new AtomicInteger(0);

        public Duration getExpiryForCreation() {
            this.creationCount.incrementAndGet();
            return Duration.ETERNAL;
        }

        public int getCreationCount() {
            return this.creationCount.get();
        }

        public Duration getExpiryForAccess() {
            this.accessedCount.incrementAndGet();
            return null;
        }

        public int getAccessCount() {
            return this.accessedCount.get();
        }

        public Duration getExpiryForUpdate() {
            this.updatedCount.incrementAndGet();
            return null;
        }

        public int getUpdatedCount() {
            return this.updatedCount.get();
        }

        public void resetCount() {
            this.creationCount.set(0);
            this.accessedCount.set(0);
            this.updatedCount.set(0);
        }
    }
}

