/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.testutil;

import java.util.logging.Logger;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public abstract class AbstractTestExcluder
implements MethodRule {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Statement apply(Statement statement, FrameworkMethod frameworkMethod, Object o) {
        String methodName = frameworkMethod.getName();
        String className = frameworkMethod.getMethod().getDeclaringClass().getName();
        if (this.isExcluded(methodName)) {
            return new ExcludedStatement(className, methodName, this.logger);
        }
        return statement;
    }

    protected abstract boolean isExcluded(String var1);

    protected Logger getLogger() {
        return this.logger;
    }

    private static final class ExcludedStatement
    extends Statement {
        private final String methodName;
        private final String className;
        private final Logger logger;

        private ExcludedStatement(String className, String methodName, Logger logger) {
            this.className = className;
            this.methodName = methodName;
            this.logger = logger;
        }

        public void evaluate() throws Throwable {
            this.logger.info("===== EXCLUDING TEST '" + this.className + "'\t'" + this.methodName + "'.");
        }
    }
}

