/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.expiry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.jsr107.tck.expiry.ExpiryPolicyServer;
import org.jsr107.tck.support.CacheClient;
import org.jsr107.tck.support.Operation;

public class ExpiryPolicyClient
extends CacheClient
implements ExpiryPolicy {
    public ExpiryPolicyClient(InetAddress address, int port) {
        super(address, port);
        this.client = null;
    }

    public Duration getExpiryForCreation() {
        return this.getClient().invoke(new GetExpiryOperation(ExpiryPolicyServer.EntryOperation.CREATION));
    }

    public Duration getExpiryForAccess() {
        return this.getClient().invoke(new GetExpiryOperation(ExpiryPolicyServer.EntryOperation.ACCESSED));
    }

    public Duration getExpiryForUpdate() {
        return this.getClient().invoke(new GetExpiryOperation(ExpiryPolicyServer.EntryOperation.UPDATED));
    }

    private static class GetExpiryOperation
    implements Operation<Duration> {
        private ExpiryPolicyServer.EntryOperation entryOperation;

        public GetExpiryOperation(ExpiryPolicyServer.EntryOperation entryOperation) {
            this.entryOperation = entryOperation;
        }

        @Override
        public String getType() {
            return "getExpiry";
        }

        @Override
        public Duration onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            oos.writeObject(this.entryOperation.name());
            Object o = ois.readObject();
            if (o instanceof RuntimeException) {
                throw (RuntimeException)o;
            }
            return (Duration)o;
        }
    }
}

