/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.jsr107.tck.integration.RecordingCacheWriter;

public class BatchPartialSuccessRecordingClassWriter<K, V>
extends RecordingCacheWriter<K, V> {
    private int simulatedDeleteFailure = 3;
    private int simulatedWriteFailure = 3;
    private AtomicInteger numWrite = new AtomicInteger(1);
    private AtomicInteger numDelete = new AtomicInteger(1);

    public BatchPartialSuccessRecordingClassWriter(int simulatedWriteFailure, int simulatedDeleteFailure) {
        this.simulatedWriteFailure = simulatedWriteFailure;
        this.simulatedDeleteFailure = simulatedDeleteFailure;
    }

    @Override
    public void write(Cache.Entry<? extends K, ? extends V> entry) {
        if (this.numWrite.getAndIncrement() % this.simulatedWriteFailure == 0) {
            throw new CacheException("simulated failure of write entry=[" + entry.getKey() + "," + entry.getValue() + "]");
        }
        super.write(entry);
    }

    @Override
    public void delete(Object key) {
        if (this.numDelete.getAndIncrement() % this.simulatedDeleteFailure == 0) {
            throw new CacheException("simulated failure of delete(" + key + ")");
        }
        super.delete(key);
    }

    @Override
    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        Iterator<Cache.Entry<K, V>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Cache.Entry<? extends K, ? extends V> entry = iterator.next();
            if (this.numWrite.getAndIncrement() % this.simulatedWriteFailure == 0) {
                throw new CacheException("simulated write failure for entry " + entry.getKey() + "," + entry.getValue());
            }
            super.write(entry);
            iterator.remove();
        }
    }

    @Override
    public void deleteAll(Collection<?> entries) {
        Iterator<?> keys = entries.iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (this.numDelete.getAndIncrement() % this.simulatedDeleteFailure == 0) {
                throw new CacheException("simulated delete failure for key " + key);
            }
            super.delete(key);
            keys.remove();
        }
    }
}

