/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.cache.CacheException;
import javax.cache.implementation.Binary;
import javax.cache.implementation.RIByReferenceSimpleCache;
import javax.cache.implementation.RISimpleCache;
import javax.cache.implementation.Serializer;

class RIByValueSimpleCache<K, V>
implements RISimpleCache<K, V> {
    private final Serializer<V> valueSerializer;
    private final Serializer<K> keySerializer;
    private final RIByReferenceSimpleCache<Binary<K>, Binary<V>> store = new RIByReferenceSimpleCache();

    public RIByValueSimpleCache(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        return this.store.putIfAbsent(this.createKeyHolder(key), this.createValueHolder(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.store.replace(this.createKeyHolder(key), this.createValueHolder(oldValue), this.createValueHolder(newValue));
    }

    @Override
    public boolean replace(K key, V value) {
        return this.store.replace(this.createKeyHolder(key), this.createValueHolder(value));
    }

    @Override
    public V getAndReplace(K key, V value) {
        return this.returnValue(this.store.getAndReplace(this.createKeyHolder(key), this.createValueHolder(value)));
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.store.containsKey(this.createSearchObject(key));
    }

    @Override
    public V get(Object key) {
        return this.returnValue(this.store.get(this.createSearchObject(key)));
    }

    @Override
    public void put(K key, V value) {
        this.store.put(this.createKeyHolder(key), this.createValueHolder(value));
    }

    @Override
    public V getAndPut(K key, V value) {
        return this.returnValue(this.store.getAndPut(this.createKeyHolder(key), this.createValueHolder(value)));
    }

    @Override
    public boolean remove(Object key) {
        return this.store.remove(this.createSearchObject(key));
    }

    @Override
    public boolean remove(Object key, V oldValue) throws CacheException {
        return this.store.remove(this.createSearchObject(key), (Object)this.createValueHolder(oldValue));
    }

    @Override
    public V getAndRemove(Object key) {
        return this.returnValue(this.store.getAndRemove(this.createSearchObject(key)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        HashMap<Binary<K>, Binary<V>> toStore = new HashMap<Binary<K>, Binary<V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            toStore.put(this.createKeyHolder(entry.getKey()), this.createValueHolder(entry.getValue()));
        }
        this.store.putAll(toStore);
    }

    @Override
    public void removeAll() {
        this.store.removeAll();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new WrappedIterator(this.store.iterator());
    }

    private V returnValue(Binary<V> binary) {
        return binary == null ? null : (V)binary.get();
    }

    private Binary<V> createValueHolder(V value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.valueSerializer.createBinary(value);
    }

    private Binary<K> createKeyHolder(K key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.keySerializer.createBinary(key);
    }

    private Object createSearchObject(Object o) {
        return new SearchObject(o);
    }

    private static final class WrappedIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Binary<K>, Binary<V>>> iterator;

        private WrappedIterator(Iterator<Map.Entry<Binary<K>, Binary<V>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry<Binary<K>, Binary<V>> next = this.iterator.next();
            return new WrappedEntry(next);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        private static final class WrappedEntry<K, V>
        implements Map.Entry<K, V> {
            private final Map.Entry<Binary<K>, Binary<V>> entry;

            private WrappedEntry(Map.Entry<Binary<K>, Binary<V>> entry) {
                this.entry = entry;
            }

            @Override
            public K getKey() {
                return this.entry.getKey().get();
            }

            @Override
            public V getValue() {
                return this.entry.getValue().get();
            }

            @Override
            public V setValue(V v) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static final class SearchObject {
        private final Object searchObject;

        private SearchObject(Object searchObject) {
            this.searchObject = searchObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Binary)) {
                return false;
            }
            Binary that = (Binary)o;
            return this.searchObject.hashCode() == that.hashCode() && this.searchObject.equals(that.get());
        }

        public int hashCode() {
            return this.searchObject.hashCode();
        }
    }
}

