/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheConfiguration;
import javax.cache.Caching;
import javax.cache.InvalidConfigurationException;
import javax.cache.OptionalFeature;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public final class RICacheConfiguration
implements CacheConfiguration {
    private final AtomicBoolean readThrough;
    private final AtomicBoolean writeThrough;
    private final AtomicBoolean storeByValue;
    private final AtomicBoolean statisticsEnabled;
    private volatile IsolationLevel isolationLevel;
    private volatile Mode transactionMode;
    private final CacheConfiguration.Duration[] timeToLive;

    private RICacheConfiguration(boolean readThrough, boolean writeThrough, boolean storeByValue, boolean statisticsEnabled, IsolationLevel isolationLevel, Mode transactionMode, CacheConfiguration.Duration[] timeToLive) {
        this.readThrough = new AtomicBoolean(readThrough);
        this.writeThrough = new AtomicBoolean(writeThrough);
        this.storeByValue = new AtomicBoolean(storeByValue);
        this.statisticsEnabled = new AtomicBoolean(statisticsEnabled);
        this.isolationLevel = isolationLevel;
        this.transactionMode = transactionMode;
        this.timeToLive = timeToLive;
    }

    public boolean isReadThrough() {
        return this.readThrough.get();
    }

    public void setReadThrough(boolean readThrough) {
        this.readThrough.set(readThrough);
    }

    public boolean isWriteThrough() {
        return this.writeThrough.get();
    }

    public void setWriteThrough(boolean writeThrough) {
        this.writeThrough.set(writeThrough);
    }

    public boolean isStoreByValue() {
        return this.storeByValue.get();
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled.get();
    }

    public void setStatisticsEnabled(boolean enableStatistics) {
        this.statisticsEnabled.set(enableStatistics);
    }

    public boolean isTransactionEnabled() {
        return this.isolationLevel != null && this.transactionMode != null;
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return this.isolationLevel;
    }

    public Mode getTransactionMode() {
        return this.transactionMode;
    }

    public void setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
        if (duration == null) {
            throw new NullPointerException();
        }
        this.timeToLive[type.ordinal()] = duration;
    }

    public CacheConfiguration.Duration getExpiry(CacheConfiguration.ExpiryType type) {
        return this.timeToLive[type.ordinal()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheConfiguration)) {
            return false;
        }
        CacheConfiguration that = (CacheConfiguration)o;
        if (this.getTransactionIsolationLevel() != that.getTransactionIsolationLevel()) {
            return false;
        }
        if (this.isReadThrough() != this.isReadThrough()) {
            return false;
        }
        if (this.isStatisticsEnabled() != that.isStatisticsEnabled()) {
            return false;
        }
        if (this.isStoreByValue() != that.isStoreByValue()) {
            return false;
        }
        for (CacheConfiguration.ExpiryType ttyType : CacheConfiguration.ExpiryType.values()) {
            if (this.getExpiry(ttyType) == that.getExpiry(ttyType)) continue;
            return false;
        }
        if (this.getTransactionMode() != that.getTransactionMode()) {
            return false;
        }
        return this.isWriteThrough() == that.isWriteThrough();
    }

    public int hashCode() {
        int result = this.readThrough.hashCode();
        Boolean b = this.writeThrough.get();
        result = 31 * result + (b != false ? 1 : 0);
        b = this.storeByValue.get();
        result = 31 * result + (b != false ? 1 : 0);
        b = this.statisticsEnabled.get();
        result = 31 * result + (b != false ? 1 : 0);
        result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 31 * result + (this.transactionMode != null ? this.transactionMode.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.timeToLive);
        return result;
    }

    public static class Builder {
        private static final boolean DEFAULT_READ_THROUGH = false;
        private static final boolean DEFAULT_WRITE_THROUGH = false;
        private static final boolean DEFAULT_STORE_BY_VALUE = true;
        private static final boolean DEFAULT_STATISTICS_ENABLED = false;
        private static final CacheConfiguration.Duration DEFAULT_TIME_TO_LIVE = CacheConfiguration.Duration.ETERNAL;
        private static final IsolationLevel DEFAULT_TRANSACTION_ISOLATION_LEVEL = null;
        private static final Mode DEFAULT_TRANSACTION_MODE = null;
        private boolean readThrough = false;
        private boolean writeThrough = false;
        private boolean storeByValue = true;
        private boolean statisticsEnabled = false;
        private IsolationLevel isolationLevel = DEFAULT_TRANSACTION_ISOLATION_LEVEL;
        private Mode transactionMode = DEFAULT_TRANSACTION_MODE;
        private final CacheConfiguration.Duration[] timeToLive = new CacheConfiguration.Duration[CacheConfiguration.ExpiryType.values().length];

        public Builder() {
            for (int i = 0; i < this.timeToLive.length; ++i) {
                this.timeToLive[i] = DEFAULT_TIME_TO_LIVE;
            }
        }

        public Builder setReadThrough(boolean readThrough) {
            this.readThrough = readThrough;
            return this;
        }

        public Builder setWriteThrough(boolean writeThrough) {
            this.writeThrough = writeThrough;
            return this;
        }

        public Builder setStoreByValue(boolean storeByValue) {
            if (!storeByValue && !Caching.isSupported((OptionalFeature)OptionalFeature.STORE_BY_REFERENCE)) {
                throw new InvalidConfigurationException("storeByValue");
            }
            this.storeByValue = storeByValue;
            return this;
        }

        public Builder setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
            return this;
        }

        public Builder setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration timeToLive) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (timeToLive == null) {
                throw new NullPointerException();
            }
            this.timeToLive[type.ordinal()] = timeToLive;
            return this;
        }

        public Builder setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            if (!Caching.isSupported((OptionalFeature)OptionalFeature.TRANSACTIONS)) {
                throw new InvalidConfigurationException("transactionsEnabled");
            }
            this.isolationLevel = isolationLevel;
            this.transactionMode = mode;
            return this;
        }

        public RICacheConfiguration build() {
            return new RICacheConfiguration(this.readThrough, this.writeThrough, this.storeByValue, this.statisticsEnabled, this.isolationLevel, this.transactionMode, this.timeToLive);
        }
    }
}

