/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheException;
import javax.cache.CacheLoader;
import javax.cache.CacheManager;
import javax.cache.CacheWriter;
import javax.cache.Caching;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.NotificationScope;
import javax.cache.implementation.RICache;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import javax.transaction.UserTransaction;

public class RICacheManager
implements CacheManager {
    private static final Logger LOGGER = Logger.getLogger("javax.cache");
    private final HashMap<String, Cache<?, ?>> caches = new HashMap();
    private final HashSet<Class<?>> immutableClasses = new HashSet();
    private final String name;
    private final ClassLoader classLoader;
    private volatile Status status = Status.UNINITIALISED;

    public RICacheManager(String name, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("No classLoader specified");
        }
        if (name == null) {
            throw new NullPointerException("No name specified");
        }
        this.classLoader = classLoader;
        this.name = name;
        this.status = Status.STARTED;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public <K, V> CacheBuilder<K, V> createCacheBuilder(String cacheName) {
        return new RICacheBuilder(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName) {
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            Cache<?, ?> cache = this.caches.get(cacheName);
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Set<Cache<K, V>> getCaches() {
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            HashSet set = new HashSet();
            Iterator<Cache<?, ?>> i$ = this.caches.values().iterator();
            while (i$.hasNext()) {
                Cache<?, ?> cache;
                Cache<?, ?> castCache = cache = i$.next();
                set.add(castCache);
            }
            return Collections.unmodifiableSet(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCacheInternal(Cache<?, ?> cache) throws CacheException {
        Cache<?, ?> oldCache;
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            oldCache = this.caches.put(cache.getName(), cache);
        }
        cache.start();
        if (oldCache != null) {
            oldCache.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCache(String cacheName) {
        Cache<?, ?> oldCache;
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            oldCache = this.caches.remove(cacheName);
        }
        if (oldCache != null) {
            oldCache.stop();
        }
        return oldCache != null;
    }

    public UserTransaction getUserTransaction() {
        throw new UnsupportedOperationException();
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return Caching.isSupported((OptionalFeature)optionalFeature);
    }

    public void addImmutableClass(Class<?> immutableClass) {
        if (immutableClass == null) {
            throw new NullPointerException();
        }
        this.immutableClasses.add(immutableClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList cacheList;
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        HashSet<Class<?>> hashSet = this.immutableClasses;
        synchronized (hashSet) {
            this.immutableClasses.clear();
        }
        HashMap<String, Cache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            cacheList = new ArrayList(this.caches.values());
            this.caches.clear();
        }
        for (Cache<?, ?> cache : cacheList) {
            try {
                cache.stop();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error stopping cache: " + cache);
            }
        }
        this.status = Status.STOPPED;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwapping to " + cls + " is not a supported by this implementation");
    }

    Logger getLogger() {
        return LOGGER;
    }

    private class RICacheBuilder<K, V>
    implements CacheBuilder<K, V> {
        private final RICache.Builder<K, V> cacheBuilder;

        public RICacheBuilder(String cacheName) {
            this.cacheBuilder = new RICache.Builder(cacheName, RICacheManager.this.name, RICacheManager.this.immutableClasses, RICacheManager.this.classLoader);
        }

        public Cache<K, V> build() {
            Cache cache = this.cacheBuilder.build();
            RICacheManager.this.addCacheInternal(cache);
            return cache;
        }

        public CacheBuilder<K, V> setCacheLoader(CacheLoader<K, V> cacheLoader) {
            this.cacheBuilder.setCacheLoader((CacheLoader)cacheLoader);
            return this;
        }

        public CacheBuilder<K, V> setCacheWriter(CacheWriter<K, V> cacheWriter) {
            this.cacheBuilder.setCacheWriter(cacheWriter);
            return this;
        }

        public CacheBuilder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> listener, NotificationScope scope, boolean synchronous) {
            this.cacheBuilder.registerCacheEntryListener(listener, scope, synchronous);
            return this;
        }

        public CacheBuilder<K, V> setStoreByValue(boolean storeByValue) {
            this.cacheBuilder.setStoreByValue(storeByValue);
            return this;
        }

        public CacheBuilder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
            this.cacheBuilder.setTransactionEnabled(isolationLevel, mode);
            return this;
        }

        public CacheBuilder<K, V> setStatisticsEnabled(boolean enableStatistics) {
            this.cacheBuilder.setStatisticsEnabled(enableStatistics);
            return this;
        }

        public CacheBuilder<K, V> setReadThrough(boolean readThrough) {
            this.cacheBuilder.setReadThrough(readThrough);
            return this;
        }

        public CacheBuilder<K, V> setWriteThrough(boolean writeThrough) {
            this.cacheBuilder.setWriteThrough(writeThrough);
            return this;
        }

        public CacheBuilder<K, V> setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration timeToLive) {
            this.cacheBuilder.setExpiry(type, timeToLive);
            return this;
        }
    }
}

